

CREATE TABLE `wpjs_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `wpjs_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wpjs_comments VALUES("1","1","A WordPress Commenter","wapuu@wordpress.example","https://wordpress.org/","","2018-09-21 18:06:32","2018-09-21 18:06:32","Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com\">Gravatar</a>.","0","1","","","0","0");



CREATE TABLE `wpjs_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `wpjs_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=247 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wpjs_options VALUES("1","siteurl","http://www.destinationttn.com","yes");
INSERT INTO wpjs_options VALUES("2","home","http://www.destinationttn.com","yes");
INSERT INTO wpjs_options VALUES("3","blogname","Trenton-Mercer Ariport","yes");
INSERT INTO wpjs_options VALUES("4","blogdescription","Trenton-Mercer Ariport","yes");
INSERT INTO wpjs_options VALUES("5","users_can_register","0","yes");
INSERT INTO wpjs_options VALUES("6","admin_email","kbosko@cmasolutions.com","yes");
INSERT INTO wpjs_options VALUES("7","start_of_week","1","yes");
INSERT INTO wpjs_options VALUES("8","use_balanceTags","0","yes");
INSERT INTO wpjs_options VALUES("9","use_smilies","1","yes");
INSERT INTO wpjs_options VALUES("10","require_name_email","1","yes");
INSERT INTO wpjs_options VALUES("11","comments_notify","1","yes");
INSERT INTO wpjs_options VALUES("12","posts_per_rss","10","yes");
INSERT INTO wpjs_options VALUES("13","rss_use_excerpt","0","yes");
INSERT INTO wpjs_options VALUES("14","mailserver_url","mail.example.com","yes");
INSERT INTO wpjs_options VALUES("15","mailserver_login","login@example.com","yes");
INSERT INTO wpjs_options VALUES("16","mailserver_pass","password","yes");
INSERT INTO wpjs_options VALUES("17","mailserver_port","110","yes");
INSERT INTO wpjs_options VALUES("18","default_category","1","yes");
INSERT INTO wpjs_options VALUES("19","default_comment_status","open","yes");
INSERT INTO wpjs_options VALUES("20","default_ping_status","open","yes");
INSERT INTO wpjs_options VALUES("21","default_pingback_flag","1","yes");
INSERT INTO wpjs_options VALUES("22","posts_per_page","10","yes");
INSERT INTO wpjs_options VALUES("23","date_format","F j, Y","yes");
INSERT INTO wpjs_options VALUES("24","time_format","g:i a","yes");
INSERT INTO wpjs_options VALUES("25","links_updated_date_format","F j, Y g:i a","yes");
INSERT INTO wpjs_options VALUES("26","comment_moderation","0","yes");
INSERT INTO wpjs_options VALUES("27","moderation_notify","1","yes");
INSERT INTO wpjs_options VALUES("28","permalink_structure","/{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}year{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}/{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}monthnum{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}/{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}day{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}/{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}postname{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}/","yes");
INSERT INTO wpjs_options VALUES("29","rewrite_rules","a:388:{s:7:\"team/?$\";s:29:\"index.php?post_type=employees\";s:37:\"team/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=employees&feed=$matches[1]\";s:32:\"team/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=employees&feed=$matches[1]\";s:24:\"team/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=employees&paged=$matches[1]\";s:12:\"faq-items/?$\";s:23:\"index.php?post_type=faq\";s:42:\"faq-items/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?post_type=faq&feed=$matches[1]\";s:37:\"faq-items/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?post_type=faq&feed=$matches[1]\";s:29:\"faq-items/page/([0-9]{1,})/?$\";s:41:\"index.php?post_type=faq&paged=$matches[1]\";s:13:\"news-posts/?$\";s:24:\"index.php?post_type=news\";s:43:\"news-posts/feed/(feed|rdf|rss|rss2|atom)/?$\";s:41:\"index.php?post_type=news&feed=$matches[1]\";s:38:\"news-posts/(feed|rdf|rss|rss2|atom)/?$\";s:41:\"index.php?post_type=news&feed=$matches[1]\";s:30:\"news-posts/page/([0-9]{1,})/?$\";s:42:\"index.php?post_type=news&paged=$matches[1]\";s:18:\"portfolio-posts/?$\";s:29:\"index.php?post_type=portfolio\";s:48:\"portfolio-posts/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:43:\"portfolio-posts/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:35:\"portfolio-posts/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:9:\"albums/?$\";s:31:\"index.php?post_type=photo_album\";s:39:\"albums/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=photo_album&feed=$matches[1]\";s:34:\"albums/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=photo_album&feed=$matches[1]\";s:26:\"albums/page/([0-9]{1,})/?$\";s:49:\"index.php?post_type=photo_album&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:35:\"clients/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"clients/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"clients/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"clients/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"clients/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"clients/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"clients/([^/]+)/embed/?$\";s:40:\"index.php?clients=$matches[1]&embed=true\";s:28:\"clients/([^/]+)/trackback/?$\";s:34:\"index.php?clients=$matches[1]&tb=1\";s:36:\"clients/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?clients=$matches[1]&paged=$matches[2]\";s:43:\"clients/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?clients=$matches[1]&cpage=$matches[2]\";s:32:\"clients/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?clients=$matches[1]&page=$matches[2]\";s:24:\"clients/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"clients/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"clients/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"clients/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"clients/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"clients/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"animated-columns/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"animated-columns/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"animated-columns/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"animated-columns/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"animated-columns/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"animated-columns/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"animated-columns/([^/]+)/embed/?$\";s:49:\"index.php?animated-columns=$matches[1]&embed=true\";s:37:\"animated-columns/([^/]+)/trackback/?$\";s:43:\"index.php?animated-columns=$matches[1]&tb=1\";s:45:\"animated-columns/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?animated-columns=$matches[1]&paged=$matches[2]\";s:52:\"animated-columns/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?animated-columns=$matches[1]&cpage=$matches[2]\";s:41:\"animated-columns/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?animated-columns=$matches[1]&page=$matches[2]\";s:33:\"animated-columns/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"animated-columns/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"animated-columns/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"animated-columns/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"animated-columns/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"animated-columns/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"banner_builder/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"banner_builder/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"banner_builder/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"banner_builder/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"banner_builder/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"banner_builder/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"banner_builder/([^/]+)/embed/?$\";s:47:\"index.php?banner_builder=$matches[1]&embed=true\";s:35:\"banner_builder/([^/]+)/trackback/?$\";s:41:\"index.php?banner_builder=$matches[1]&tb=1\";s:43:\"banner_builder/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?banner_builder=$matches[1]&paged=$matches[2]\";s:50:\"banner_builder/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?banner_builder=$matches[1]&cpage=$matches[2]\";s:39:\"banner_builder/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?banner_builder=$matches[1]&page=$matches[2]\";s:31:\"banner_builder/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"banner_builder/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"banner_builder/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"banner_builder/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"banner_builder/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"banner_builder/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"edge/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"edge/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"edge/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"edge/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"edge/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"edge/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"edge/([^/]+)/embed/?$\";s:37:\"index.php?edge=$matches[1]&embed=true\";s:25:\"edge/([^/]+)/trackback/?$\";s:31:\"index.php?edge=$matches[1]&tb=1\";s:33:\"edge/([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?edge=$matches[1]&paged=$matches[2]\";s:40:\"edge/([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?edge=$matches[1]&cpage=$matches[2]\";s:29:\"edge/([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?edge=$matches[1]&page=$matches[2]\";s:21:\"edge/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:31:\"edge/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:51:\"edge/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"edge/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"edge/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:27:\"edge/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"team/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"team/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"team/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"team/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"team/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"team/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"team/([^/]+)/embed/?$\";s:42:\"index.php?employees=$matches[1]&embed=true\";s:25:\"team/([^/]+)/trackback/?$\";s:36:\"index.php?employees=$matches[1]&tb=1\";s:45:\"team/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?employees=$matches[1]&feed=$matches[2]\";s:40:\"team/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?employees=$matches[1]&feed=$matches[2]\";s:33:\"team/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?employees=$matches[1]&paged=$matches[2]\";s:40:\"team/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?employees=$matches[1]&cpage=$matches[2]\";s:29:\"team/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?employees=$matches[1]&page=$matches[2]\";s:21:\"team/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:31:\"team/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:51:\"team/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"team/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"team/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:27:\"team/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"employees_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?employees_category=$matches[1]&feed=$matches[2]\";s:54:\"employees_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?employees_category=$matches[1]&feed=$matches[2]\";s:35:\"employees_category/([^/]+)/embed/?$\";s:51:\"index.php?employees_category=$matches[1]&embed=true\";s:47:\"employees_category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?employees_category=$matches[1]&paged=$matches[2]\";s:29:\"employees_category/([^/]+)/?$\";s:40:\"index.php?employees_category=$matches[1]\";s:37:\"faq-items/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"faq-items/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"faq-items/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"faq-items/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"faq-items/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"faq-items/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"faq-items/([^/]+)/embed/?$\";s:36:\"index.php?faq=$matches[1]&embed=true\";s:30:\"faq-items/([^/]+)/trackback/?$\";s:30:\"index.php?faq=$matches[1]&tb=1\";s:50:\"faq-items/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?faq=$matches[1]&feed=$matches[2]\";s:45:\"faq-items/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?faq=$matches[1]&feed=$matches[2]\";s:38:\"faq-items/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?faq=$matches[1]&paged=$matches[2]\";s:45:\"faq-items/([^/]+)/comment-page-([0-9]{1,})/?$\";s:43:\"index.php?faq=$matches[1]&cpage=$matches[2]\";s:34:\"faq-items/([^/]+)(?:/([0-9]+))?/?$\";s:42:\"index.php?faq=$matches[1]&page=$matches[2]\";s:26:\"faq-items/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"faq-items/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"faq-items/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"faq-items/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"faq-items/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"faq-items/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"faq_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?faq_category=$matches[1]&feed=$matches[2]\";s:48:\"faq_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?faq_category=$matches[1]&feed=$matches[2]\";s:29:\"faq_category/([^/]+)/embed/?$\";s:45:\"index.php?faq_category=$matches[1]&embed=true\";s:41:\"faq_category/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?faq_category=$matches[1]&paged=$matches[2]\";s:23:\"faq_category/([^/]+)/?$\";s:34:\"index.php?faq_category=$matches[1]\";s:38:\"news-posts/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"news-posts/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"news-posts/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"news-posts/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"news-posts/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"news-posts/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"news-posts/([^/]+)/embed/?$\";s:37:\"index.php?news=$matches[1]&embed=true\";s:31:\"news-posts/([^/]+)/trackback/?$\";s:31:\"index.php?news=$matches[1]&tb=1\";s:51:\"news-posts/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?news=$matches[1]&feed=$matches[2]\";s:46:\"news-posts/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?news=$matches[1]&feed=$matches[2]\";s:39:\"news-posts/([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?news=$matches[1]&paged=$matches[2]\";s:46:\"news-posts/([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?news=$matches[1]&cpage=$matches[2]\";s:35:\"news-posts/([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?news=$matches[1]&page=$matches[2]\";s:27:\"news-posts/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"news-posts/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"news-posts/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"news-posts/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"news-posts/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"news-posts/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"news_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?news_category=$matches[1]&feed=$matches[2]\";s:49:\"news_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?news_category=$matches[1]&feed=$matches[2]\";s:30:\"news_category/([^/]+)/embed/?$\";s:46:\"index.php?news_category=$matches[1]&embed=true\";s:42:\"news_category/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?news_category=$matches[1]&paged=$matches[2]\";s:24:\"news_category/([^/]+)/?$\";s:35:\"index.php?news_category=$matches[1]\";s:43:\"portfolio-posts/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"portfolio-posts/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"portfolio-posts/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"portfolio-posts/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"portfolio-posts/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"portfolio-posts/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"portfolio-posts/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:36:\"portfolio-posts/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:56:\"portfolio-posts/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:51:\"portfolio-posts/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:44:\"portfolio-posts/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:51:\"portfolio-posts/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:40:\"portfolio-posts/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:32:\"portfolio-posts/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"portfolio-posts/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"portfolio-posts/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"portfolio-posts/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"portfolio-posts/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"portfolio-posts/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"portfolio_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:54:\"portfolio_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?portfolio_category=$matches[1]&feed=$matches[2]\";s:35:\"portfolio_category/([^/]+)/embed/?$\";s:51:\"index.php?portfolio_category=$matches[1]&embed=true\";s:47:\"portfolio_category/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?portfolio_category=$matches[1]&paged=$matches[2]\";s:29:\"portfolio_category/([^/]+)/?$\";s:40:\"index.php?portfolio_category=$matches[1]\";s:35:\"pricing/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"pricing/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"pricing/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"pricing/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"pricing/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"pricing/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"pricing/([^/]+)/embed/?$\";s:40:\"index.php?pricing=$matches[1]&embed=true\";s:28:\"pricing/([^/]+)/trackback/?$\";s:34:\"index.php?pricing=$matches[1]&tb=1\";s:36:\"pricing/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?pricing=$matches[1]&paged=$matches[2]\";s:43:\"pricing/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?pricing=$matches[1]&cpage=$matches[2]\";s:32:\"pricing/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?pricing=$matches[1]&page=$matches[2]\";s:24:\"pricing/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"pricing/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"pricing/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"pricing/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"pricing/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"pricing/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"slideshow/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"slideshow/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"slideshow/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"slideshow/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"slideshow/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"slideshow/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"slideshow/([^/]+)/embed/?$\";s:42:\"index.php?slideshow=$matches[1]&embed=true\";s:30:\"slideshow/([^/]+)/trackback/?$\";s:36:\"index.php?slideshow=$matches[1]&tb=1\";s:38:\"slideshow/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?slideshow=$matches[1]&paged=$matches[2]\";s:45:\"slideshow/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?slideshow=$matches[1]&cpage=$matches[2]\";s:34:\"slideshow/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?slideshow=$matches[1]&page=$matches[2]\";s:26:\"slideshow/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"slideshow/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"slideshow/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"slideshow/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"slideshow/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"slideshow/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"tab_slider/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"tab_slider/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"tab_slider/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"tab_slider/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"tab_slider/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"tab_slider/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"tab_slider/([^/]+)/embed/?$\";s:43:\"index.php?tab_slider=$matches[1]&embed=true\";s:31:\"tab_slider/([^/]+)/trackback/?$\";s:37:\"index.php?tab_slider=$matches[1]&tb=1\";s:39:\"tab_slider/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?tab_slider=$matches[1]&paged=$matches[2]\";s:46:\"tab_slider/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?tab_slider=$matches[1]&cpage=$matches[2]\";s:35:\"tab_slider/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?tab_slider=$matches[1]&page=$matches[2]\";s:27:\"tab_slider/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"tab_slider/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"tab_slider/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"tab_slider/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"tab_slider/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"tab_slider/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"testimonial/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"testimonial/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"testimonial/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"testimonial/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"testimonial/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"testimonial/([^/]+)/embed/?$\";s:44:\"index.php?testimonial=$matches[1]&embed=true\";s:32:\"testimonial/([^/]+)/trackback/?$\";s:38:\"index.php?testimonial=$matches[1]&tb=1\";s:40:\"testimonial/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&paged=$matches[2]\";s:47:\"testimonial/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?testimonial=$matches[1]&cpage=$matches[2]\";s:36:\"testimonial/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?testimonial=$matches[1]&page=$matches[2]\";s:28:\"testimonial/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"testimonial/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"testimonial/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"testimonial/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"testimonial/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:61:\"testimonial_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?testimonial_category=$matches[1]&feed=$matches[2]\";s:56:\"testimonial_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?testimonial_category=$matches[1]&feed=$matches[2]\";s:37:\"testimonial_category/([^/]+)/embed/?$\";s:53:\"index.php?testimonial_category=$matches[1]&embed=true\";s:49:\"testimonial_category/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?testimonial_category=$matches[1]&paged=$matches[2]\";s:31:\"testimonial_category/([^/]+)/?$\";s:42:\"index.php?testimonial_category=$matches[1]\";s:34:\"albums/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"albums/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"albums/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"albums/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"albums/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"albums/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"albums/([^/]+)/embed/?$\";s:44:\"index.php?photo_album=$matches[1]&embed=true\";s:27:\"albums/([^/]+)/trackback/?$\";s:38:\"index.php?photo_album=$matches[1]&tb=1\";s:47:\"albums/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?photo_album=$matches[1]&feed=$matches[2]\";s:42:\"albums/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?photo_album=$matches[1]&feed=$matches[2]\";s:35:\"albums/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?photo_album=$matches[1]&paged=$matches[2]\";s:42:\"albums/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?photo_album=$matches[1]&cpage=$matches[2]\";s:31:\"albums/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?photo_album=$matches[1]&page=$matches[2]\";s:23:\"albums/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"albums/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"albums/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"albums/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"albums/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"albums/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:61:\"photo_album_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?photo_album_category=$matches[1]&feed=$matches[2]\";s:56:\"photo_album_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?photo_album_category=$matches[1]&feed=$matches[2]\";s:37:\"photo_album_category/([^/]+)/embed/?$\";s:53:\"index.php?photo_album_category=$matches[1]&embed=true\";s:49:\"photo_album_category/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?photo_album_category=$matches[1]&paged=$matches[2]\";s:31:\"photo_album_category/([^/]+)/?$\";s:42:\"index.php?photo_album_category=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:39:\"mkhb_header/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"mkhb_header/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"mkhb_header/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"mkhb_header/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"mkhb_header/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"mkhb_header/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"mkhb_header/([^/]+)/embed/?$\";s:44:\"index.php?mkhb_header=$matches[1]&embed=true\";s:32:\"mkhb_header/([^/]+)/trackback/?$\";s:38:\"index.php?mkhb_header=$matches[1]&tb=1\";s:40:\"mkhb_header/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?mkhb_header=$matches[1]&paged=$matches[2]\";s:47:\"mkhb_header/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?mkhb_header=$matches[1]&cpage=$matches[2]\";s:36:\"mkhb_header/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?mkhb_header=$matches[1]&page=$matches[2]\";s:28:\"mkhb_header/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"mkhb_header/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"mkhb_header/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"mkhb_header/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"mkhb_header/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"mkhb_header/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}","yes");
INSERT INTO wpjs_options VALUES("30","hack_file","0","yes");
INSERT INTO wpjs_options VALUES("31","blog_charset","UTF-8","yes");
INSERT INTO wpjs_options VALUES("32","moderation_keys","","no");
INSERT INTO wpjs_options VALUES("33","active_plugins","a:0:{}","yes");
INSERT INTO wpjs_options VALUES("34","category_base","","yes");
INSERT INTO wpjs_options VALUES("35","ping_sites","http://rpc.pingomatic.com/","yes");
INSERT INTO wpjs_options VALUES("36","comment_max_links","2","yes");
INSERT INTO wpjs_options VALUES("37","gmt_offset","0","yes");
INSERT INTO wpjs_options VALUES("38","default_email_category","1","yes");
INSERT INTO wpjs_options VALUES("39","recently_edited","","no");
INSERT INTO wpjs_options VALUES("40","template","jupiter","yes");
INSERT INTO wpjs_options VALUES("41","stylesheet","jupiter-child","yes");
INSERT INTO wpjs_options VALUES("42","comment_whitelist","1","yes");
INSERT INTO wpjs_options VALUES("43","blacklist_keys","","no");
INSERT INTO wpjs_options VALUES("44","comment_registration","0","yes");
INSERT INTO wpjs_options VALUES("45","html_type","text/html","yes");
INSERT INTO wpjs_options VALUES("46","use_trackback","0","yes");
INSERT INTO wpjs_options VALUES("47","default_role","subscriber","yes");
INSERT INTO wpjs_options VALUES("48","db_version","38590","yes");
INSERT INTO wpjs_options VALUES("49","uploads_use_yearmonth_folders","1","yes");
INSERT INTO wpjs_options VALUES("50","upload_path","","yes");
INSERT INTO wpjs_options VALUES("51","blog_public","1","yes");
INSERT INTO wpjs_options VALUES("52","default_link_category","2","yes");
INSERT INTO wpjs_options VALUES("53","show_on_front","posts","yes");
INSERT INTO wpjs_options VALUES("54","tag_base","","yes");
INSERT INTO wpjs_options VALUES("55","show_avatars","1","yes");
INSERT INTO wpjs_options VALUES("56","avatar_rating","G","yes");
INSERT INTO wpjs_options VALUES("57","upload_url_path","","yes");
INSERT INTO wpjs_options VALUES("58","thumbnail_size_w","150","yes");
INSERT INTO wpjs_options VALUES("59","thumbnail_size_h","150","yes");
INSERT INTO wpjs_options VALUES("60","thumbnail_crop","1","yes");
INSERT INTO wpjs_options VALUES("61","medium_size_w","300","yes");
INSERT INTO wpjs_options VALUES("62","medium_size_h","300","yes");
INSERT INTO wpjs_options VALUES("63","avatar_default","mystery","yes");
INSERT INTO wpjs_options VALUES("64","large_size_w","1024","yes");
INSERT INTO wpjs_options VALUES("65","large_size_h","1024","yes");
INSERT INTO wpjs_options VALUES("66","image_default_link_type","none","yes");
INSERT INTO wpjs_options VALUES("67","image_default_size","","yes");
INSERT INTO wpjs_options VALUES("68","image_default_align","","yes");
INSERT INTO wpjs_options VALUES("69","close_comments_for_old_posts","0","yes");
INSERT INTO wpjs_options VALUES("70","close_comments_days_old","14","yes");
INSERT INTO wpjs_options VALUES("71","thread_comments","1","yes");
INSERT INTO wpjs_options VALUES("72","thread_comments_depth","5","yes");
INSERT INTO wpjs_options VALUES("73","page_comments","0","yes");
INSERT INTO wpjs_options VALUES("74","comments_per_page","50","yes");
INSERT INTO wpjs_options VALUES("75","default_comments_page","newest","yes");
INSERT INTO wpjs_options VALUES("76","comment_order","asc","yes");
INSERT INTO wpjs_options VALUES("77","sticky_posts","a:0:{}","yes");
INSERT INTO wpjs_options VALUES("78","widget_categories","a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("79","widget_text","a:0:{}","yes");
INSERT INTO wpjs_options VALUES("80","widget_rss","a:0:{}","yes");
INSERT INTO wpjs_options VALUES("81","uninstall_plugins","a:0:{}","no");
INSERT INTO wpjs_options VALUES("82","timezone_string","","yes");
INSERT INTO wpjs_options VALUES("83","page_for_posts","0","yes");
INSERT INTO wpjs_options VALUES("84","page_on_front","0","yes");
INSERT INTO wpjs_options VALUES("85","default_post_format","0","yes");
INSERT INTO wpjs_options VALUES("86","link_manager_enabled","0","yes");
INSERT INTO wpjs_options VALUES("87","finished_splitting_shared_terms","1","yes");
INSERT INTO wpjs_options VALUES("88","site_icon","0","yes");
INSERT INTO wpjs_options VALUES("89","medium_large_size_w","768","yes");
INSERT INTO wpjs_options VALUES("90","medium_large_size_h","0","yes");
INSERT INTO wpjs_options VALUES("91","wp_page_for_privacy_policy","3","yes");
INSERT INTO wpjs_options VALUES("92","show_comments_cookies_opt_in","0","yes");
INSERT INTO wpjs_options VALUES("93","initial_db_version","38590","yes");
INSERT INTO wpjs_options VALUES("94","wpjs_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","yes");
INSERT INTO wpjs_options VALUES("95","fresh_site","1","yes");
INSERT INTO wpjs_options VALUES("96","widget_search","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("97","widget_recent-posts","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("98","widget_recent-comments","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("99","widget_archives","a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("100","widget_meta","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("101","sidebars_widgets","a:19:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:0:{}s:9:\"sidebar-7\";a:0:{}s:9:\"sidebar-8\";a:0:{}s:9:\"sidebar-9\";a:0:{}s:10:\"sidebar-10\";a:0:{}s:10:\"sidebar-11\";a:0:{}s:10:\"sidebar-12\";a:0:{}s:10:\"sidebar-13\";a:0:{}s:10:\"sidebar-14\";a:0:{}s:10:\"sidebar-15\";a:0:{}s:10:\"sidebar-16\";a:0:{}s:10:\"sidebar-17\";a:0:{}s:13:\"array_version\";i:3;}","yes");
INSERT INTO wpjs_options VALUES("102","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("103","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("104","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("105","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("106","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("107","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("108","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("109","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("110","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("111","cron","a:6:{i:1537895192;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1537898792;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1537898797;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1537901271;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"c9059feef497c200e69cb9956a81f005\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:5;}}}}i:1537901313;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"686c8315be36c96dc00d0d7ed3656b43\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:6;}}}}s:7:\"version\";i:2;}","yes");
INSERT INTO wpjs_options VALUES("112","theme_mods_twentyseventeen","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1537894121;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}","yes");
INSERT INTO wpjs_options VALUES("116","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.9.8.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.9.8.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.9.8-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.9.8-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.9.8\";s:7:\"version\";s:5:\"4.9.8\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1537894072;s:15:\"version_checked\";s:5:\"4.9.8\";s:12:\"translations\";a:0:{}}","no");
INSERT INTO wpjs_options VALUES("118","_site_transient_update_plugins","O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1537894113;s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:2:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"4.0.8\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.4.0.8.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:59:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=969272\";s:2:\"1x\";s:59:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=969272\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:61:\"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904\";}s:11:\"banners_rtl\";a:0:{}}s:9:\"hello.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:25:\"w.org/plugins/hello-dolly\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/hello-dolly.1.6.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=969907\";s:2:\"1x\";s:63:\"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=969907\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/hello-dolly/assets/banner-772x250.png?rev=478342\";}s:11:\"banners_rtl\";a:0:{}}}}","no");
INSERT INTO wpjs_options VALUES("220","_site_transient_timeout_theme_roots","1537895913","no");
INSERT INTO wpjs_options VALUES("221","_site_transient_theme_roots","a:5:{s:13:\"jupiter-child\";s:7:\"/themes\";s:7:\"jupiter\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";s:15:\"twentyseventeen\";s:7:\"/themes\";s:13:\"twentysixteen\";s:7:\"/themes\";}","no");
INSERT INTO wpjs_options VALUES("123","_site_transient_timeout_browser_1c4b28f97c33971d038c15125d7a2e12","1538157998","no");
INSERT INTO wpjs_options VALUES("124","_site_transient_browser_1c4b28f97c33971d038c15125d7a2e12","a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"62.0\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:24:\"https://www.firefox.com/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}","no");
INSERT INTO wpjs_options VALUES("208","_site_transient_timeout_community-events-a8baa5c4e140b7de14293fb237703125","1537936987","no");
INSERT INTO wpjs_options VALUES("209","_site_transient_community-events-a8baa5c4e140b7de14293fb237703125","a:2:{s:8:\"location\";a:1:{s:2:\"ip\";s:10:\"50.77.65.0\";}s:6:\"events\";a:5:{i:0;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:49:\"Streamline local WordPress development with devly\";s:3:\"url\";s:67:\"https://www.meetup.com/WordPress-Montclair-Meetup/events/254434905/\";s:6:\"meetup\";s:26:\"WordPress Montclair Meetup\";s:10:\"meetup_url\";s:50:\"https://www.meetup.com/WordPress-Montclair-Meetup/\";s:4:\"date\";s:19:\"2018-09-24 19:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:18:\"Montclair, NJ, USA\";s:7:\"country\";s:2:\"us\";s:8:\"latitude\";d:40.811272000000002435626811347901821136474609375;s:9:\"longitude\";d:-74.21935999999999467036104761064052581787109375;}}i:1;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:58:\"WordCamp Montclair Planning Meeting (Not a Regular Meetup)\";s:3:\"url\";s:67:\"https://www.meetup.com/WordPress-Montclair-Meetup/events/254981207/\";s:6:\"meetup\";s:26:\"WordPress Montclair Meetup\";s:10:\"meetup_url\";s:50:\"https://www.meetup.com/WordPress-Montclair-Meetup/\";s:4:\"date\";s:19:\"2018-10-01 19:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:14:\"Montclair, USA\";s:7:\"country\";s:2:\"US\";s:8:\"latitude\";d:40.8112789999999989731804816983640193939208984375;s:9:\"longitude\";d:-74.219345000000004120010999031364917755126953125;}}i:2;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:58:\"WordCamp Montclair Planning Meeting (Not a Regular Meetup)\";s:3:\"url\";s:67:\"https://www.meetup.com/WordPress-Montclair-Meetup/events/253085441/\";s:6:\"meetup\";s:26:\"WordPress Montclair Meetup\";s:10:\"meetup_url\";s:50:\"https://www.meetup.com/WordPress-Montclair-Meetup/\";s:4:\"date\";s:19:\"2018-10-01 19:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:14:\"Montclair, USA\";s:7:\"country\";s:2:\"US\";s:8:\"latitude\";d:40.8112799999999964484231895767152309417724609375;s:9:\"longitude\";d:-74.219345000000004120010999031364917755126953125;}}i:3;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:15:\"WPNYC Help Desk\";s:3:\"url\";s:53:\"https://www.meetup.com/WordPressNYC/events/254830879/\";s:6:\"meetup\";s:26:\"WordPress NYC Meetup Group\";s:10:\"meetup_url\";s:36:\"https://www.meetup.com/WordPressNYC/\";s:4:\"date\";s:19:\"2018-10-03 18:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:17:\"New York, NY, USA\";s:7:\"country\";s:2:\"us\";s:8:\"latitude\";d:40.75;s:9:\"longitude\";d:-73.9899999999999948840923025272786617279052734375;}}i:4;a:7:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:18:\"WordCamp Baltimore\";s:3:\"url\";s:35:\"https://2018.baltimore.wordcamp.org\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2018-10-06 00:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:18:\"Baltimore, MD, USA\";s:7:\"country\";s:2:\"US\";s:8:\"latitude\";d:39.2861003000000010842995834536850452423095703125;s:9:\"longitude\";d:-76.60570830000000341897248290479183197021484375;}}}}","no");
INSERT INTO wpjs_options VALUES("210","_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca","1537936987","no");
INSERT INTO wpjs_options VALUES("211","_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"\n	Mon, 03 Sep 2018 11:00:43 +0000	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=5.0-alpha-43653\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"The Month in WordPress: August 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/news/2018/09/the-month-in-wordpress-august-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 03 Sep 2018 11:00:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6191\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:355:\"Many of the WordPress contribution teams have been working hard on the new WordPress editor, and the tools, services, and documentation surrounding it. Read on to find out more about this ongoing project, as well as everything else that has been happening around the WordPress community in August. WordPress 4.9.8 is Released WordPress 4.9.8 was [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5554:\"<p>Many of the WordPress contribution teams have been working hard on the new WordPress editor, and the tools, services, and documentation surrounding it. Read on to find out more about this ongoing project, as well as everything else that has been happening around the WordPress community in August.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>WordPress 4.9.8 is Released</h2>\n\n<p><a href=\"https://wordpress.org/news/2018/08/wordpress-4-9-8-maintenance-release/\">WordPress 4.9.8 was released</a> at the beginning of the month. While this was a maintenance release fixing 46 bugs, it was significant for Core development because it made a point of highlighting Gutenberg — the new WordPress editor that is currently in development (more on that below).<br /></p>\n\n<p>This release also included some important updates to the privacy tools that were added to Core earlier this year.<br /></p>\n\n<p>Want to get involved in building WordPress Core? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a> and join the #core channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>New WordPress Editor Development Continues</h2>\n\n<p>Active development continues on <a href=\"https://wordpress.org/gutenberg/\">Gutenberg</a>, the new editing experience for WordPress Core. <a href=\"https://make.wordpress.org/core/2018/08/31/whats-new-in-gutenberg-31st-august/\">The latest version</a> features a number of important user experience improvements, including a new unified toolbar and support for a more focussed writing mode.<br /></p>\n\n<p>Users can test Gutenberg right now by installing <a href=\"https://wordpress.org/plugins/gutenberg/\">the plugin</a>, which currently has nearly 300,000 active installs. Along with that, <a href=\"https://wordpress.org/gutenberg/handbook/reference/faq/\">the Gutenberg Handbook</a> has some very useful information about how to use and develop for the new editor.<br /></p>\n\n<p>Want to get involved in building Gutenberg? Follow <a href=\"https://make.wordpress.org/core/tag/gutenberg/\">the #gutenberg tag on the Core team blog</a> and join the #core-editor channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>Planning Begins for the Next Global WordPress Translation Day</h2>\n\n<p>The Global WordPress Translation Day is a 24-hour event held online and all across the world. It is designed to bring communities together to translate WordPress into their local languages, and to help them connect with other communities doing the same thing.<br /></p>\n\n<p>There have been three Translation Days since April 2016, and <a href=\"https://make.wordpress.org/polyglots/2018/08/29/global-wordpress-translation-day-4-preliminary-planning/\">the fourth edition is in the planning stages now</a>. The Polyglots team, who organizes these events, is currently looking for input on the date, format, and content for the event and would love some feedback from the community.<br /></p>\n\n<p>Want to get involved in translating WordPress into your own language? Follow <a href=\"https://make.wordpress.org/polyglots/\">the Polyglots team blog</a> and join the #polyglots channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.<br /></p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Further Reading:</h2>\n\n<ul><li><a href=\"https://wordpress.org/support/upgrade-php/\">The Update PHP page on WordPress.org</a> has been revised and improved to make the reasons for upgrading more clear.</li><li>The Mobile team is looking for people to help test the latest versions of the <a href=\"https://make.wordpress.org/mobile/2018/08/29/call-for-testing-wordpress-for-android-10-8/\">Android</a> and <a href=\"https://make.wordpress.org/mobile/2018/08/28/call-for-testing-wordpress-for-ios-10-8/\">iOS</a> apps for WordPress.</li><li><a href=\"https://wordbits.io/\">WordBits</a> is a innovative new platform for publishing WordPress-based code snippets with the ability to download each snippet as a working plugin.</li><li>The Community Team <a href=\"https://make.wordpress.org/community/2018/08/27/wordcamp-incubator-2018-update-thread-august-edition/\">has some updates</a> about how things are going with this year’s WordCamp Incubator program.</li><li>The WordPress Support Forums <a href=\"https://make.wordpress.org/support/2018/08/august-16th-support-team-meeting-summary/\">now include a feature</a> allowing forum volunteers to easily report a post to the moderators for a follow-up.</li><li>WordCamp Kochi, India <a href=\"https://2018.kochi.wordcamp.org/wordcamp-kochi-2018-is-postponed-to-november-3rd-2018-saturday/\">has unfortunately had to postpone their event</a> due to floods in the region.</li><li><a href=\"http://www.wpglossary.net/\">WP Glossary</a> is a new site that offers helpful definitions of words that you could encounter when using WordPress.</li><li>A few WordPress community members <a href=\"https://make.wordpress.org/community/2018/08/13/in-the-words-of-the/\">have started a working group</a> to tackle the idea of building diverse WordPress  communities all across the world.</li><li>A new <a href=\"https://editorblockswp.com/library/\">Gutenberg Block Library</a> is available, listing the details of the many blocks available for the new editor.</li></ul>\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6191\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 4.9.8 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2018/08/wordpress-4-9-8-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2018 21:25:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6165\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:398:\"We are pleased to announce the immediate availability of WordPress 4.9.8.  This maintenance release fixes 46 bugs, enhancements and blessed tasks, including updating the Twenty Seventeen bundled theme. Following are the highlights of what is now available. “Try Gutenberg” callout Most users will now be presented with a notice in their WordPress dashboard. This “Try Gutenberg” [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Paul Biron\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10398:\"<p>We are pleased to announce the immediate availability of WordPress 4.9.8.  This maintenance release fixes 46 bugs, enhancements and blessed tasks, including updating the Twenty Seventeen bundled theme.</p>\n<p><span style=\"font-weight: 400\">Following are the highlights of what is now available.</span></p>\n<h2>“Try Gutenberg” callout</h2>\n<p><span style=\"font-weight: 400\">Most users will now be presented with a notice in their WordPress dashboard. This </span>“Try Gutenberg” is an opportunity for users to use the Gutenberg block editor before it is released in WordPress 5.0.</p>\n<p><img class=\"alignnone wp-image-6168 size-full\" src=\"https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?resize=632{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2C392&#038;ssl=1\" alt=\"\" width=\"632\" height=\"392\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?w=2528&amp;ssl=1 2528w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?resize=300{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2C186&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?resize=768{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2C476&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?resize=1024{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2C634&amp;ssl=1 1024w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?w=1264&amp;ssl=1 1264w, https://i0.wp.com/wordpress.org/news/files/2018/08/Screen-Shot-2018-08-02-at-11.42.39-am.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></p>\n<p>In WordPress 4.9.8, the callout will be shown to the following users:</p>\n<ul>\n<li>If Gutenberg <em>is not</em> installed or activated, the callout will be shown to Admin users on single sites, and Super Admin users on multisites.</li>\n<li>If Gutenberg <em>is</em> installed and activated, the callout will be shown to Contributor users and above.</li>\n<li>If the Classic Editor plugin is installed and activated, the callout will be hidden for all users.</li>\n</ul>\n<p class=\"entry-title\"><span style=\"font-weight: 400\">You can learn more by reading  </span><a href=\"https://make.wordpress.org/core/2018/08/02/try-gutenberg-callout-in-wordpress-4-9-8/\">“Try Gutenberg” Callout in WordPress 4.9.8</a>.</p>\n<h2>Privacy fixes/enhancements</h2>\n<p>This release includes 18 Privacy fixes focused on ensuring consistency and flexibility in the new personal data tools <span style=\"font-weight: 400\">that were </span>added in 4.9.6, including:</p>\n<ul>\n<li>The type of request being confirmed is now included in the subject line for all privacy confirmation emails.</li>\n<li>Improved consistency with site name being used for privacy emails in multisite.</li>\n<li>Pagination for Privacy request admin screens can now be adjusted.</li>\n<li>Increased the test coverage for several core privacy functions.</li>\n</ul>\n<p><a href=\"https://make.wordpress.org/core/2018/08/02/wordpress-4-9-8/\">This post has more information about all of the issues fixed in 4.9.8 if you&#8217;d like to learn more</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.9.8</a> or venture over to Dashboard → Updates and click &#8220;Update Now.&#8221; Sites that support automatic background updates are already beginning to update automatically.</p>\n<p>Thank you to everyone who contributed to WordPress 4.9.8:</p>\n<p><a href=\"https://profiles.wordpress.org/1naveengiri/\">1naveengiri</a>, <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/abdullahramzan/\">Abdullah Ramzan</a>, <a href=\"https://profiles.wordpress.org/alejandroxlopez/\">alejandroxlopez</a>, <a href=\"https://profiles.wordpress.org/allendav/\">Allen Snook</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/andrewtaylor-1/\">Andrew Taylor</a>, <a href=\"https://profiles.wordpress.org/aryamaaru/\">Arun</a>, <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a>, <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a>, <a href=\"https://profiles.wordpress.org/bjornw/\">BjornW</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/burhandodhy/\">Burhan Nasir</a>, <a href=\"https://profiles.wordpress.org/chetan200891/\">Chetan Prajapati</a>, <a href=\"https://profiles.wordpress.org/chrislema/\">Chris Lema</a>, <a href=\"https://profiles.wordpress.org/coreymckrill/\">Corey McKrill</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/danieltj/\">Daniel James</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/dontstealmyfish/\">dontstealmyfish</a>, <a href=\"https://profiles.wordpress.org/dyrer/\">dyrer</a>, <a href=\"https://profiles.wordpress.org/felipeelia/\">Felipe Elia</a>, <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/fclaussen/\">Fernando Claussen</a>, <a href=\"https://profiles.wordpress.org/garetharnold/\">Gareth</a>, <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a>, <a href=\"https://profiles.wordpress.org/gm_alex/\">GM_Alex</a>, <a href=\"https://profiles.wordpress.org/idea15/\">Heather Burns</a>, <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ianbelanger/\">ibelanger</a>, <a href=\"https://profiles.wordpress.org/imath/\">imath</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/jpry/\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">JJJ</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a>, <a href=\"https://profiles.wordpress.org/joshuawold/\">JoshuaWold</a>, <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a>, <a href=\"https://profiles.wordpress.org/jrf/\">jrf</a>, <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a>, <a href=\"https://profiles.wordpress.org/khaihong/\">khaihong</a>, <a href=\"https://profiles.wordpress.org/kjellr/\">kjellr</a>, <a href=\"https://profiles.wordpress.org/xkon/\">Konstantinos Xenos</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>, <a href=\"https://profiles.wordpress.org/lbenicio/\">lbenicio</a>, <a href=\"https://profiles.wordpress.org/leanderiversen/\">Leander Iversen</a>, <a href=\"https://profiles.wordpress.org/leemon/\">leemon</a>, <a href=\"https://profiles.wordpress.org/macbookandrew/\">macbookandrew</a>, <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a>, <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/mensmaximus/\">mensmaximus</a>, <a href=\"https://profiles.wordpress.org/mermel/\">mermel</a>, <a href=\"https://profiles.wordpress.org/metalandcoffee/\">metalandcoffee</a>, <a href=\"https://profiles.wordpress.org/michelleweber/\">michelleweber</a>, <a href=\"https://profiles.wordpress.org/dimadin/\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/xpertone/\">Muhammad Kashif</a>, <a href=\"https://profiles.wordpress.org/nao/\">Naoko Takano</a>, <a href=\"https://profiles.wordpress.org/nathanatmoz/\">Nathan Johnson</a>, <a href=\"https://profiles.wordpress.org/ov3rfly/\">Ov3rfly</a>, <a href=\"https://profiles.wordpress.org/palmiak/\">palmiak</a>, <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a>, <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a>, <a href=\"https://profiles.wordpress.org/presstigers/\">PressTigers</a>, <a href=\"https://profiles.wordpress.org/programmin/\">programmin</a>, <a href=\"https://profiles.wordpress.org/rafsuntaskin/\">Rafsun Chowdhury</a>, <a href=\"https://profiles.wordpress.org/redcastor/\">redcastor</a>, <a href=\"https://profiles.wordpress.org/littlerchicken/\">Robin Cornett</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/pross/\">Simon Prosser</a>, <a href=\"https://profiles.wordpress.org/skoldin/\">skoldin</a>, <a href=\"https://profiles.wordpress.org/spyderbytes/\">spyderbytes</a>, <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a>, <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a>, <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/tharsheblows/\">tharsheblows</a>, <a href=\"https://profiles.wordpress.org/thomasplevy/\">Thomas Patrick Levy</a>, <a href=\"https://profiles.wordpress.org/timbowesohft/\">timbowesohft</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/tz-media/\">Tobias Zimpel</a>, <a href=\"https://profiles.wordpress.org/tobifjellner/\">Tor-Bjorn Fjellner</a>, <a href=\"https://profiles.wordpress.org/itowhid06/\">Towhidul Islam</a>, <a href=\"https://profiles.wordpress.org/usmankhalid/\">Usman Khalid</a>, <a href=\"https://profiles.wordpress.org/warmlaundry/\">warmlaundry</a>, <a href=\"https://profiles.wordpress.org/earnjam/\">William Earnhardt</a>, <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a>, and <a href=\"https://profiles.wordpress.org/yuriv/\">YuriV</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6165\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"The Month in WordPress: July 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2018/08/the-month-in-wordpress-july-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 01 Aug 2018 09:11:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6158\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:333:\"With WordPress 5.0 coming closer, there’s lots of work going on all across the project. Read on to learn about how we progressed in July. Release of WordPress 4.9.7 On July 5, WordPress 4.9.7 was released,  fixing one security issue and 17 other bugs across the platform. While this is a minor release, incremental fixes [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6411:\"<p>With WordPress 5.0 coming closer, there’s lots of work going on all across the project. Read on to learn about how we progressed in July.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Release of WordPress 4.9.7</h2>\n\n<p>On July 5, <a href=\"https://wordpress.org/news/2018/07/wordpress-4-9-7-security-and-maintenance-release/\">WordPress 4.9.7 was released</a>,  fixing one security issue and 17 other bugs across the platform.<br /></p>\n\n<p>While this is a minor release, incremental fixes are essential to keep WordPress running smoothly. Everyone is encouraged to update as soon as possible and to make sure that automatic updates are switched on.<br /></p>\n\n<p>Would you like to get involved in building WordPress Core? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a> and join the #core channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>The New WordPress Editor</h2>\n\n<p>In the upcoming minor release of WordPress, 4.9.8, a new section in the dashboard will feature Gutenberg, the upcoming content editor for WordPress.<br /></p>\n\n<p>While the official release of Gutenberg <a href=\"https://wordpress.org/news/2018/07/update-on-gutenberg/\">is scheduled</a> for the coming months, you can already install it as <a href=\"https://wordpress.org/plugins/gutenberg/\">a plugin</a> to test it out right now. Additionally, <a href=\"https://wordpress.org/gutenberg/\">a brand new demo page</a> is now available — play around with the many features the editor has to offer, without installing it on your own site.<br /></p>\n\n<p>Would you like to help build or test Gutenberg? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a> and join the #core-editor channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>Page Design Updates on WordPress.org</h2>\n\n<p>Bit by bit we’re refreshing the design of WordPress.org. The latest pages to get a new treatment have been <a href=\"https://wordpress.org/download/\">the Download page</a> and <a href=\"https://profiles.wordpress.org/matt/\">user profiles</a>.<br /></p>\n\n<p>The Meta and Design teams worked hard to make these new designs a reality, with notable contributions from <a href=\'https://profiles.wordpress.org/melchoyce/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>melchoyce</a>, <a href=\'https://profiles.wordpress.org/obenland/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>obenland</a>, <a href=\'https://profiles.wordpress.org/mapk/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mapk</a>, and <a href=\'https://profiles.wordpress.org/kjellr/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>kjellr</a>. The new designs enhance the overall look of the site and provide more relevant information to those searching.<br /></p>\n\n<p>Would you like to get involved in the design refresh? Follow the <a href=\"https://make.wordpress.org/meta/\">Meta</a> and <a href=\"https://make.wordpress.org/design/\">Design</a> team blogs and join the #meta and #design channels in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>The First WP-CLI Hack Day</h2>\n\n<p>On Friday July 20, the WP-CLI team <a href=\"https://make.wordpress.org/cli/2018/07/04/wp-cli-hack-day/\">held their first hack day</a> — a global event encouraging people to contribute to the official command line tool for WordPress.<br /></p>\n\n<p>Run by <a href=\'https://profiles.wordpress.org/schlessera/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>schlessera</a>, the event <a href=\"https://make.wordpress.org/cli/2018/07/21/wp-cli-hack-day-results/\"> was a great success</a>. Twelve pull requests were  merged and another 13 submitted. It also included a video chat to give all contributors a space to meet each other and connect directly.<br /></p>\n\n<p>Would  you like to get involved in contributing to WP-CLI? Follow <a href=\"https://make.wordpress.org/cli/\">the team blog</a> and join the #cli channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Further Reading:</h2>\n\n<ul><li>The WordPress Foundation is <a href=\"https://wordpressfoundation.org/2018/call-for-organizers-introduction-to-open-source-workshops-for-2018/\">looking for local community organizers to run introductory open-source workshops</a> in 2018.</li><li><a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a> compiled <a href=\"https://wordpress.org/news/2018/07/quarterly-updates-q2-2018/\">updates for the last quarter</a> from the contribution teams all across the WordPress project.</li><li>In a great move for internationalization, <a href=\"https://en.blog.wordpress.com/2018/03/29/the-wordpress-mobile-apps-now-support-right-to-left-languages/\">the WordPress Mobile Apps now support right-to-left languages</a>.</li><li><a href=\"https://make.wordpress.org/community/2018/07/10/stripe-is-now-available-to-all-wordcamps/\">WordCamp events can now accept payment via Stripe</a> — PayPal remains an alternative option.</li><li>The WP-CLI team will soon <a href=\"https://make.wordpress.org/cli/2018/07/19/details-on-the-upcoming-major-release/\">release v2.0</a> of the official WordPress command line tool.</li><li>The Fields API project in WordPress Core <a href=\"https://wptavern.com/wordpress-core-fields-api-project-is-seeking-new-leadership\">is looking for a new lead</a> to drive it forward.</li><li>In WordPress 4.9.8, <a href=\"https://make.wordpress.org/core/2018/07/27/registering-metadata-in-4-9-8/\">it will  be possible</a> for developers to fully register the meta fields used by their plugins and themes.</li><li>After many years of hard work, <a href=\"https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards\">v1.0.0 of the WordPress Coding Standards for PHP_CodeSniffer</a> has been released.</li><li>The Mobile team <a href=\"https://make.wordpress.org/mobile/2018/07/31/call-for-testing-wordpress-for-ios-10-6/\">is looking for people to help test</a> v10.6 of WordPress for iOS.</li></ul>\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6158\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:51:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Quarterly Updates | Q2 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://wordpress.org/news/2018/07/quarterly-updates-q2-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 Jul 2018 14:50:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6140\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:347:\"To keep everyone aware of big projects and efforts across WordPress contributor teams, I&#8217;ve reached out to each team&#8217;s listed representatives. I asked each of them to share their Top Priority (and when they hope for it to be completed), as well as their biggest Wins and Worries. Have questions? I&#8217;ve included a link to [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:15622:\"<p><em>To keep everyone aware of big projects and efforts across WordPress contributor teams, I&#8217;ve reached out to each team&#8217;s <a href=\"https://make.wordpress.org/updates/team-reps/\">listed representatives</a>. I asked each of them to share their Top Priority (and when they hope for it to be completed), as well as their biggest Wins and Worries. Have questions? I&#8217;ve included a link to each team&#8217;s site in the headings.﻿</em></p>\n\n<h2><a href=\"https://make.wordpress.org/accessibility/\">Accessibility</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/rianrietveld/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rianrietveld</a>, <a href=\'https://profiles.wordpress.org/joedolson/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joedolson</a>, <a href=\'https://profiles.wordpress.org/afercia/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>afercia</a></li>\n	<li><strong>Priority</strong>: Working to make sure that Gutenberg is reasonably accessible prior to merge. ETA is before 5.0</li>\n	<li><strong>Struggle</strong>: Lack of developers and accessibility experts to help test and code the milestone issues. <em>The team is doing outreach to help solve this problem.</em></li>\n	<li><strong>Big Win</strong>: Interest from companies like The Paciello Group and Tenon.io to help out with Gutenberg code review and testing tools.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/cli/\">CLI</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: @danielbachhuber, <a href=\'https://profiles.wordpress.org/schlessera/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>schlessera</a></li>\n	<li><strong>Priority</strong>: Very first global <a href=\"https://make.wordpress.org/cli/2018/07/04/wp-cli-hack-day/\">Hack Day</a> is coming up July 20. Version 2.0.0 is still in progress (new <a href=\"https://github.com/wp-cli/wp-cli/issues/4752\">ETA</a> is end of July).</li>\n	<li><strong>Struggle</strong>: The team continues to need new contributors. The current team is tiny but tough.</li>\n	<li><strong>Big Win</strong>: WP-CLI is currently one of the project&#8217;s four main focuses, as mentioned in the Summer Update at WordCamp Europe.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/community/\">Community</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/francina/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>francina</a>, <a href=\'https://profiles.wordpress.org/hlashbrooke/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>hlashbrooke</a></li>\n	<li><strong>Priority</strong>: Focusing on smoothing out the processes in our community management by building up our team of volunteers and establishing what tools we need to keep things running well. ETA is ongoing.</li>\n	<li><strong>Struggle</strong>: Our two biggest struggles at the moment are tracking what we need to get done, and making final decisions on things. <em>There is current work on the tools available to assist with tracking progress.﻿</em></li>\n	<li><strong>Big Win</strong>: After making a concerted effort to get more contributors on the Community Team, we now have a much larger group of volunteers working as deputies and WordCamp mentors</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/core/\">Core</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a></li>\n	<li><strong>Priority</strong>: Following the <a href=\"https://wordpress.tv/2018/07/04/matt-mullenweg-a-summertime-update-keynote-and-qa/\">WordCamp Europe summer update</a> ﻿(and the companion post <a href=\"https://wordpress.org/news/2018/07/update-on-gutenberg/\">here</a>), the team is getting Gutenberg (the new WordPress editing experience) into a strong state for the 5.0 release. Potential ETA as soon as August.</li>\n	<li><strong>Struggle</strong>: Coordinating momentum and direction as we start seeing more contributors offering their time. Still working our way through open issues. <em>﻿The team is starting multiple bug scrubs each week to work through these more quickly and transparently.</em></li>\n	<li><strong>Big Win</strong>: Had a <a href=\"https://wordpress.org/news/2018/05/wordpress-4-9-6-privacy-and-maintenance-release/\">sizable release in 4.9.6</a> which featured major updates around privacy tools and functionality in Core.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/design/\">Design</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/melchoyce/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>melchoyce</a>, <a href=\'https://profiles.wordpress.org/karmatosed/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>karmatosed</a>, <a href=\'https://profiles.wordpress.org/boemedia/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>boemedia</a>, <a href=\'https://profiles.wordpress.org/joshuawold/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>joshuawold</a>, <a href=\'https://profiles.wordpress.org/mizejewski/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mizejewski</a></li>\n	<li><strong>Priority</strong>: Better on-boarding of new contributors, especially creating better documentation. ETA is end of July.</li>\n	<li><strong>Struggle</strong>: It&#8217;s hard to identify reasonably small tasks for first-time contributors.</li>\n	<li><strong>Big Win</strong>: The team is much more organized now which has helped clear out the design backlog, bring in new contributors, and also keep current contributors coming back. <em>Bonus: Joshua Wold will co-lead the upcoming release.</em></li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/docs/\">Documentation</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/kenshino/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>kenshino</a><br /></li>\n	<li><strong>Priority</strong>: Opening up the work on <a href=\"https://make.wordpress.org/docs/2018/02/26/state-of-helphub-february-2018/\">HelpHub</a> to new contributors and easing the onboarding process. No ETA.<br /></li>\n	<li><strong>Struggle</strong>: Some blockers with making sure the code and database can be ready to launch on https://wordpress.org/support/<br /></li>\n	<li><strong>Big Win</strong>: The <a href=\"https://wp-helphub.com/\">first phase of HelpHub</a> creation is complete, which means content updates (current info, more readable, easier discovery), internal search, design improvements, and REST API endpoints.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/hosting/\">Hosting</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/mikeschroder/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>mikeschroder</a>, <a href=\'https://profiles.wordpress.org/jadonn/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jadonn</a></li>\n	<li><strong>Priority</strong>: Preparing hosts for supporting Gutenberg, especially support questions they&#8217;re likely to see when the &#8220;Try Gutenberg&#8221; callout is released. ETA July 31st, then before WordPress 5.0<br /><strong></strong></li>\n	<li><strong>Struggle</strong>: Most contributions are still made a by a small team of volunteers. Seeing a few more people join, but progress is slow.<br /><strong></strong></li>\n	<li><strong>﻿Big Win</strong>: New team members and hosting companies have joined the #hosting-community team and have started contributing.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/marketing/\">Marketing</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/bridgetwillard/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>bridgetwillard</a></li>\n	<li><strong>Priority</strong>: Continuing to write and publish case studies from the community. ETA is ongoing.</li>\n	<li><strong>Struggle</strong>: No current team struggles.</li>\n	<li><strong>Big Win</strong>: Wrote and designed a short <a href=\"https://make.wordpress.org/marketing/2018/04/24/contributor-day-onboarding-pdf/\">Contributor Day onboarding card</a>. It was used at Contributor Day at WCEU and onboarding time went down to 1 hour instead of 3 hours.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/meta/\">Meta</a> (WordPress.org Site)</h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/tellyworth/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>tellyworth</a>, <a href=\'https://profiles.wordpress.org/coffee2code/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>coffee2code</a></li>\n	<li><strong>Priority</strong>: Reducing manual work around the contributor space (theme review, GDPR/privacy, plugin review). ETA for small wins is end of quarter, larger efforts after that.</li>\n	<li><strong>Struggle</strong>: Maintaining momentum on tickets. <em>There are also some discussions about updating the ticket management process across teams that use the Meta trac system.</em></li>\n	<li><strong>Big Win</strong>: The new About page launched and has been translated across most locale sites.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/mobile/\">Mobile</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/elibud/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>elibud</a></li>\n	<li><strong>Priority</strong>: Getting Gutenberg in the mobile applications. ETA is late December.</li>\n	<li><strong>Struggle</strong>: Consuming the Gutenberg source in the ReactNative app directly. <em>More info can be found here: https://make.wordpress.org/mobile/2018/07/09/next-steps-for-gutenberg-mobile/</em></li>\n	<li><strong>Big Win</strong>: The WordPress mobile applications now fully support right-to-left languages and are compliant with the latest standards for accessibility.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/plugins/\">Plugins</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/ipstenu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ipstenu</a></li>\n	<li><strong>Priority</strong>: Clearing ~8,000 unused plugins from the queues. Likely ETA is September.<br /></li>\n	<li><strong>Struggles</strong>: Had to triage a lot of false claims around plugins offering GDPR compliance.</li>\n	<li><strong>Big Win</strong>: Released 4.9.6 and <a href=\"https://make.wordpress.org/plugins/2018/05/17/wp-4-9-6-privacy-hooks-and-you/\">updated expectations</a> with plugin authors. Huge thanks to the Core Privacy team for their hard work on this.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/polyglots/\">Polyglots</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/petya/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>petya</a>, <a href=\'https://profiles.wordpress.org/ocean90/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>ocean90</a>, <a href=\'https://profiles.wordpress.org/nao/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>nao</a>, <a href=\'https://profiles.wordpress.org/chantalc/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chantalc</a>, <a href=\'https://profiles.wordpress.org/deconf/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>deconf</a>, <a href=\'https://profiles.wordpress.org/casiepa/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>casiepa</a></li>\n	<li><strong>Priority</strong>: Keep WordPress releases translated to 100{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8} and then concentrate on the top 100 plugins and themes. ETA is ongoing.<br /><strong></strong></li>\n	<li><strong>﻿Struggle</strong>: Getting new PTEs fast enough, and complex tools/systems. Overall, the volume of strings awaiting approval.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/support/\">Support</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/clorith/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>clorith</a></li>\n	<li><strong>Priority:</strong> Getting ready for the Gutenberg callout (it got pushed last quarter). Needing a better presence on the official support forums, and outreach for that is underway, ETA end of July. <br /></li>\n	<li><strong>Struggle</strong>: Keeping contributors participating post-contributor days/drives. <em>﻿Considering the creation of a dedicated post-contributor day survey to get some insight here.</em></li>\n	<li><strong>Big Win</strong>: The increase in international liaisons joining for weekly meetings, helping bring the wider support community together.</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/themes/\">Theme Review</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/acosmin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>acosmin</a>, <a href=\'https://profiles.wordpress.org/rabmalin/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rabmalin</a>, <a href=\'https://profiles.wordpress.org/thinkupthemes/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>thinkupthemes</a>, <a href=\'https://profiles.wordpress.org/williampatton/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>williampatton</a></li>\n	<li><strong>Priority</strong>: Building a better Theme Check/Sniffer in order to automate most of the checks done right now by reviewers. ETA late 2018, early 2019.</li>\n	<li><strong>Struggle</strong>: Bringing in new contributors to the team.</li>\n	<li><strong>Big Win</strong>: <a href=\"https://make.wordpress.org/themes/2018/04/30/trusted-authors-program/\">Trusted Authors program﻿</a></li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/tide/\">Tide</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/valendesigns/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>valendesigns</a> (but usually <a href=\'https://profiles.wordpress.org/jeffpaul/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jeffpaul</a>)</li>\n	<li><strong>Priority</strong>: Storing PHPCompatibilty results inside the WordPress.org API and building a UI to display those results, an endpoint to request an audit is required for this work to continue.</li>\n	<li><strong>Struggle</strong>: Development has dramatically slowed down while team members are on leave or pulled into internal client work.</li>\n	<li><strong>Big Win</strong>: Migration to Google Cloud Platform (GCP) from Amazon Web Services (AWS) is complete and the audit servers have all been rewritten in Go. (This allows us to be faster with greater capacity and less cost.)</li>\n</ul>\n\n<h2><a href=\"https://make.wordpress.org/training/\">Training</a></h2>\n\n<ul>\n	<li><strong>Contacted</strong>: <a href=\'https://profiles.wordpress.org/bethsoderberg/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>bethsoderberg</a>, <a href=\'https://profiles.wordpress.org/juliek/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>juliek</a></li>\n	<li><strong>Priority:</strong> Lesson plan production. ETA is ongoing.</li>\n	<li><strong>Struggle:</strong> The workflow is a little complex, so recruiting and training enough contributors to keep the process moving is a struggle.</li>\n	<li><strong>Big Win</strong>: WordCamp Europe&#8217;s Contributor Day was very productive. New tools/workflow are in place and two team representatives were there to lead and help.</li>\n</ul>\n\n<p><em>Interested in updates from the first quarter of this year? You can find those here: <a href=\"https://make.wordpress.org/updates/2018/04/24/quarterly-updates-q1-2018/\"><em>https://make.wordpress.org/updates/2018/04/24/quarterly-updates-q1-2018/</em></a>\n	</em>\n</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6140\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:51:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Update on Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/news/2018/07/update-on-gutenberg/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 06 Jul 2018 19:23:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:5:\"Focus\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:9:\"Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6118\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:328:\"Progress on the Gutenberg project, the new content creating experience coming to WordPress, has come a long way. Since the start of the project, there have been 30 releases and 12 of those happened after WordCamp US 2017. In total since then, there have been 1,764 issues opened and 1,115 closed as of WordCamp Europe. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Tammie Lister\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2261:\"<p>Progress on the Gutenberg project, the new content creating experience coming to WordPress, has come a long way. Since the start of the project, there have been 30 releases and 12 of those happened after WordCamp US 2017. In total since then, there have been 1,764 issues opened and 1,115 closed as of WordCamp Europe. As the work on phase one moves into its final stretch, here is what you can expect.<br /></p>\n\n<h4>In Progress</h4>\n\n<ul>\n	<li>Freeze new features in Gutenberg (the feature list can be found <a href=\"https://github.com/WordPress/gutenberg/issues/4894\">here</a>).</li>\n	<li>Hosts, agencies, teachers invited to opt-in sites they have influence over.</li>\n	<li>WordPress.com has opt-in for wp-admin users. The number of sites and posts will be tracked.</li>\n	<li>Mobile app support for Gutenberg will be across iOS and Android.</li>\n</ul>\n\n<h4>July</h4>\n\n<ul>\n	<li>4.9.x release with an invitation to install either Gutenberg or Classic Editor plugin.</li>\n	<li>WordPress.com will move to opt-out. There will be tracking to see who opts out and why.</li>\n	<li>Triage increases and bug gardening escalates to get blockers in Gutenberg down to zero.</li>\n	<li>Gutenberg phase two, Customization exploration begins by moving beyond the post.</li>\n</ul>\n\n<h4>August and beyond</h4>\n\n<ul>\n	<li>All critical issues within Gutenberg are resolved.</li>\n	<li>There is full integration with Calypso and there is opt-in for users there.</li>\n	<li>A goal will be 100k+ sites having made 250k+ posts using Gutenberg.</li>\n	<li>Core merge of Gutenberg begins the 5.0 release cycle.</li>\n	<li>5.0 moves into beta releases and translations are completed.</li>\n	<li>There will be a mobile version of Gutenberg by the end of the year.</li>\n</ul>\n\n<p>WordPress 5.0 could be as soon as August with hundreds of thousands of sites using Gutenberg before release. Learn more about Gutenberg <a href=\"https://wordpress.org/gutenberg/\">here</a>, take it for a <a href=\"https://testgutenberg.com/\">test drive</a>, <a href=\"https://wordpress.org/plugins/gutenberg/\">install</a> on your site, follow along on <a href=\"https://github.com/WordPress/gutenberg\">GitHub</a> and give your <a href=\"https://wordpressdotorg.polldaddy.com/s/gutenberg-support\">feedback</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6118\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:51:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.9.7 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2018/07/wordpress-4-9-7-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 05 Jul 2018 17:00:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6091\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:360:\"WordPress 4.9.7 is now available. This is a security and maintenance release for all versions since WordPress 3.7. We strongly encourage you to update your sites immediately. WordPress versions 4.9.6 and earlier are affected by a media issue that could potentially allow a user with certain capabilities to attempt to delete files outside the uploads [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Aaron D. Campbell\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3984:\"<p>WordPress 4.9.7 is now available. This is a <strong>security and maintenance release</strong> for all versions since WordPress 3.7. We strongly encourage you to update your sites immediately.</p>\n\n<p>WordPress versions 4.9.6 and earlier are affected by a media issue that could potentially allow a user with certain capabilities to attempt to delete files outside the uploads directory.</p>\n\n<p>Thank you to <a href=\"https://hackerone.com/slavco\">Slavco</a> for reporting the original issue and <a href=\"https://www.wordfence.com/\">Matt Barry</a> for reporting related issues.</p>\n\n<p>Seventeen other bugs were fixed in WordPress 4.9.7. Particularly of note were:</p>\n\n<ul>\n	<li>Taxonomy: Improve cache handling for term queries.</li>\n	<li>Posts, Post Types: Clear post password cookie when logging out.</li>\n	<li>Widgets: Allow basic HTML tags in sidebar descriptions on Widgets admin screen.</li>\n	<li>Community Events Dashboard: Always show the nearest WordCamp if one is coming up, even if there are multiple Meetups happening first.</li>\n	<li>Privacy: Make sure default privacy policy content does not cause a fatal error when flushing rewrite rules outside of the admin context.</li>\n</ul>\n\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.9.7</a> or venture over to Dashboard → Updates and click &#8220;Update Now.&#8221; Sites that support automatic background updates are already beginning to update automatically.</p>\n\n<p>The previously scheduled 4.9.7 is now referred to as 4.9.8, and will follow the <a href=\"https://make.wordpress.org/core/2018/07/04/dev-chat-summary-july-4th-4-9-7-week-7/\">release schedule posted yesterday</a>.</p>\n\n<p>Thank you to everyone who contributed to WordPress 4.9.7:</p>\n\n<p><a href=\"https://profiles.wordpress.org/1naveengiri/\">1naveengiri</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/abdullahramzan/\">abdullahramzan</a>, <a href=\"https://profiles.wordpress.org/alejandroxlopez/\">alejandroxlopez</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/aryamaaru/\">Arun</a>, <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bjornw/\">BjornW</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/chetan200891/\">Chetan Prajapati</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/garetharnold/\">Gareth</a>, <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ianbelanger/\">ibelanger</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a>, <a href=\"https://profiles.wordpress.org/khaihong/\">khaihong</a>, <a href=\"https://profiles.wordpress.org/lbenicio/\">lbenicio</a>, <a href=\"https://profiles.wordpress.org/leanderiversen/\">Leander Iversen</a>, <a href=\"https://profiles.wordpress.org/mermel/\">mermel</a>, <a href=\"https://profiles.wordpress.org/metalandcoffee/\">metalandcoffee</a>, <a href=\"https://profiles.wordpress.org/jbpaul17/\">Migrated to @jeffpaul</a>, <a href=\"https://profiles.wordpress.org/palmiak/\">palmiak</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/skoldin/\">skoldin</a>, <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a>, <a href=\"https://profiles.wordpress.org/itowhid06/\">Towhidul Islam</a>, <a href=\"https://profiles.wordpress.org/warmlaundry/\">warmlaundry</a>, and <a href=\"https://profiles.wordpress.org/yuriv/\">YuriV</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6091\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"The Month in WordPress: June 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2018/07/the-month-in-wordpress-june-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 02 Jul 2018 09:28:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6087\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:366:\"With one of the two flagship WordCamp events taking place this month, as well as some important WordPress project announcements, there’s no shortage of news. Learn more about what happened in the WordPress community in June. Another Successful WordCamp Europe On June 14th, WordCamp Europe kicked off three days of learning and contributions in Belgrade. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4627:\"<p>With one of the two flagship WordCamp events taking place this month, as well as some important WordPress project announcements, there’s no shortage of news. Learn more about what happened in the WordPress community in June.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Another Successful WordCamp Europe</h2>\n\n<p>On June 14th, WordCamp Europe kicked off three days of learning and contributions in Belgrade. Over 2,000 people attended in person, with hundreds more watching live streams of the sessions.</p>\n\n<p>The WordCamp was a great success with plenty of first-time attendees and new WordPress contributors getting involved in the project and community. Recorded sessions from the 65 speakers at the event will be available on WordPress.tv in the coming weeks. In the meantime, check out the <a href=\"https://www.flickr.com/photos/wceu/albums\">photos from the event</a>.</p>\n\n<p><a href=\"https://2018.europe.wordcamp.org/2018/06/16/wordcamp-europe-2019/\">The next WordCamp Europe</a> takes place on June 20-22 2019 in Berlin, Germany. If you’re based in Europe and would like to serve on the organizing team, <a href=\"https://2019.europe.wordcamp.org/2018/06/16/call-wordcamp-europe-2019-organizers/\">fill in the application form</a>.</p>\n\n<h2>Updated Roadmap for the New WordPress Content Editor</h2>\n\n<p>During his keynote session at WordCamp Europe, Matt Mullenweg presented <a href=\"https://gutenbergtimes.com/mullenweg-on-gutenberg-roll-out-plan/\">an updated roadmap</a> for <a href=\"https://wordpress.org/gutenberg/\">Gutenberg</a>, the new content editor coming in WordPress 5.0.</p>\n\n<p>While the editor is in rapid development, <a href=\"https://make.wordpress.org/core/2018/06/21/whats-new-in-gutenberg-21st-june/\">with v3.1 being released this past month</a>, the team is aiming to ship Gutenberg with WordPress Core in August, 2018. This is not set in stone — the release date may shift as development progresses — but this gives the first realistic idea of when we can expect the editor to be released.</p>\n\n<p>If you would like to contribute to Gutenberg, read <a href=\"https://wordpress.org/gutenberg/handbook/\">the handbook</a>, follow the <a href=\"https://make.wordpress.org/core/\">Core team blog</a>, and join the #core-editor channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>WordCamp Incubator Cities Announced</h2>\n\n<p>The WordCamp Incubator program helps spread WordPress to underserved communities by providing organizing support for their first WordCamp. The first iteration of this program ran successfully in 2016 and empowered three cities to start their own WordPress communities.</p>\n\n<p>This year, the Community Team is running the Incubator program again. After receiving applications from 104 communities, <a href=\"https://make.wordpress.org/community/2018/06/26/wordcamp-incubator-program-2018-locations-announcement/\">they have selected</a> Montevideo, Uruguay and Kota Kinabalu, Malaysia to participate in the program. Both cities will receive direct help from experienced WordCamp organizers to run their first-ever WordCamp as a way to help their WordPress community get started.</p>\n\n<p>To find out more about the Incubator program follow the <a href=\"https://make.wordpress.org/community/\">Community team blog</a>, and join the #community-events channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Further Reading:</h2>\n\n<ul>\n	<li>The WordPress community of Spain recently <a href=\"https://twitter.com/wp_es/status/1004681694660603904\">received an award</a> for being the best open-source community in the country.</li>\n	<li>This month, WordPress reached <a href=\"https://w3techs.com/technologies/details/cm-wordpress/all/all\">the milestone of powering 31{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8} of websites</a>.</li>\n	<li><a href=\"https://wprig.io/introducing-wprig-wordpress/\">WP Rig</a> is a brand new tool to help WordPress developers build better themes.</li>\n	<li><a href=\"https://richtabor.com/gutenberg-block-unit-test/\">Block Unit Test</a> is a new plugin to help theme developers prepare for Gutenberg.</li>\n	<li>Near the end of the month, Zac Gordon hosted <a href=\"https://javascriptforwp.com/conference/\">an online conference</a> focused on JavaScript development in WordPress &#8211; the session videos will be available on YouTube soon.</li>\n</ul>\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please <a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\">submit it here</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6087\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"The Month in WordPress: May 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2018/06/the-month-in-wordpress-may-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 01 Jun 2018 09:09:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6065\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:360:\"This month saw two significant milestones in the WordPress community — the 15th anniversary of the project, and GDPR-related privacy tools coming to WordPress Core. Read on to find out more about this and everything else that happened in the WordPress community in May. Local Communities Celebrate the 15th Anniversary of WordPress Last Sunday, May [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4537:\"<p>This month saw two significant milestones in the WordPress community — the 15th anniversary of the project, and GDPR-related privacy tools coming to WordPress Core. Read on to find out more about this and everything else that happened in the WordPress community in May.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Local Communities Celebrate the 15th Anniversary of WordPress</h2>\n\n<p>Last Sunday, May 27, WordPress turned 15 years old. This is a noteworthy occasion for an open-source project like WordPress and one well worth celebrating. To mark the occasion, <a href=\"https://wp15.wordpress.net/\">WordPress communities across the world gathered</a> for parties and meetups in honor of the milestone.</p>\n\n<p>Altogether, there were 224 events globally, with <a href=\"https://wp15.wordpress.net/about/\">a few more of those still scheduled</a> to take place in some communities — attend one in your area if you can.</p>\n\n<p>If your city doesn’t have a WordPress meetup group, this is a great opportunity to start one! Learn how with <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/welcome/\">the Meetup Organizer Handbook</a>, and join the #community-events channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>Privacy Tools added to WordPress core</h2>\n\n<p>In light of recent changes to data privacy regulations in the EU, WordPress Core shipped important updates <a href=\"https://wordpress.org/news/2018/05/wordpress-4-9-6-privacy-and-maintenance-release/\">in the v4.9.6 release</a>, giving site owners tools to help them comply with the new General Data Protection Regulation (GDPR). It is worth noting, however, that WordPress cannot ensure you are compliant — this is still a site owner’s responsibility.</p>\n\n<p>The new privacy tools include a number of features focused on providing privacy and personal data management to all site users — asking commenters for explicit consent to store their details in a cookie, providing site owners with an easy way to publish a Privacy Policy, and providing data export and erasure tools to all site users that can be extended by plugins to allow the handling of data that they introduce.</p>\n\n<p>To find out more about these features and the other updates, read the <a href=\"https://make.wordpress.org/core/2018/05/17/4-9-6-update-guide/\">4.9.6 update guide</a>. You can also get involved in contributing to this part of WordPress Core by jumping into the #core-privacy channel in the<a href=\"https://make.wordpress.org/chat/\"> Making WordPress Slack group</a>, and following<a href=\"https://make.wordpress.org/core/\"> the Core team blog</a>.</p>\n\n<h2>Updates to the WordPress.org Privacy Policy</h2>\n\n<p>In a similar vein, WordPress.org itself has received <a href=\"https://wordpress.org/about/privacy/\">an updated Privacy Policy</a> to make clear what is being tracked and how your data is handled. Along with that, a <a href=\"https://wordpress.org/about/privacy/cookies/\">Cookie Policy</a> has also been added to explain just what is collected and stored in your browser when using the site.</p>\n\n<p>These policies cover all sites on the WordPress.org network — including WordPress.org, WordPress.net, WordCamp.org, BuddyPress.org, bbPress.org, and other related domains and subdomains. It’s important to note that this does not mean that anything has changed in terms of data storage; rather that these documents clarify what data is stored and how it is handled.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Further Reading:</h2>\n\n<ul>\n	<li>WordCamp US 2018 has <a href=\"https://2018.us.wordcamp.org/2018/05/29/speak-at-wordcamp-us/\">opened up speaker submissions</a> for the December event.</li>\n	<li><a href=\"https://2018.europe.wordcamp.org/2018/05/15/wceu-live-stream-tickets/\">Live stream tickets are now available for WordCamp Europe</a>, happening on June 14-16.</li>\n	<li>Gutenberg, the new editor for WordPress Core, is getting ever closer to the final stages with <a href=\"https://make.wordpress.org/core/2018/05/18/whats-new-in-gutenberg-18th-may/\">a major update</a> this month.</li>\n	<li>In preparation for Gutenberg, <a href=\"https://core.trac.wordpress.org/changeset/43309\">significant work has been done</a> to improve WordPress Core’s build process.</li>\n</ul>\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please <a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\">submit it here</a>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6065\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:51:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"WordPress.org Privacy Policy Updates\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wordpress.org/news/2018/05/wordpress-org-privacy-policy-updates/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 25 May 2018 08:06:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:7:\"privacy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6047\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:325:\"The WordPress.org privacy policy has been updated, hurray! While we weren&#8217;t able to remove all the long sentences, we hope you find the revisions make it easier to understand: how we collect and use data, how long the data we collect is retained, and how you can request a copy of the data you&#8217;ve shared [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Andrea Middleton\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:657:\"<p>The <a href=\"https://wordpress.org/about/privacy/\">WordPress.org privacy policy</a> has been updated, hurray! While we weren&#8217;t able to remove <strong>all</strong> the long sentences, we hope you find the revisions make it easier to understand:</p>\n<ul>\n<li>how we collect and use data,</li>\n<li>how long the data we collect is retained, and</li>\n<li>how you can request a copy of the data you&#8217;ve shared with us.</li>\n</ul>\n<p>There hasn&#8217;t been any change to the data that WordPress.org collects or how that data is used; the privacy policy just provides more detail now. Happy reading, and thanks for using WordPress!</p>\n<p>&nbsp;</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6047\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress 4.9.6 Privacy and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://wordpress.org/news/2018/05/wordpress-4-9-6-privacy-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 May 2018 19:21:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=5920\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:358:\"WordPress 4.9.6 is now available. This is a privacy and maintenance release. We encourage you to update your sites to take advantage of the new privacy features. Privacy The European Union&#8217;s General Data Protection Regulation (GDPR) takes effect on May 25. The GDPR requires companies and site owners to be transparent about how they collect, [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Allen Snook\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:13399:\"<p>WordPress 4.9.6 is now available. This is a <strong>privacy and maintenance release</strong>. We encourage you to update your sites to take advantage of the new privacy features.</p>\n\n<figure class=\"wp-block-image\"><img src=\"https://i0.wp.com/wordpress.org/news/files/2018/05/GDPR-Banner.png?w=632&#038;ssl=1\" alt=\"A decorative header featuring the text &quot;GDPR&quot; and a lock inside of a blue shield, on multicolor green background.\" class=\"wp-image-5988\" srcset=\"https://i0.wp.com/wordpress.org/news/files/2018/05/GDPR-Banner.png?w=1264&amp;ssl=1 1264w, https://i0.wp.com/wordpress.org/news/files/2018/05/GDPR-Banner.png?resize=300{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2C150&amp;ssl=1 300w, https://i0.wp.com/wordpress.org/news/files/2018/05/GDPR-Banner.png?resize=768{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2C384&amp;ssl=1 768w, https://i0.wp.com/wordpress.org/news/files/2018/05/GDPR-Banner.png?resize=1024{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2C512&amp;ssl=1 1024w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n<h2 style=\"text-align:left\">Privacy</h2>\n\n<p>The European Union&#8217;s General Data Protection Regulation (<strong>GDPR</strong>) takes effect on May 25. The GDPR requires companies and site owners to be transparent about how they collect, use, and share personal data. It also gives individuals more access and choice when it comes to how their own personal data is collected, used, and shared.<br /></p>\n\n<p>It’s important to understand that while the GDPR is a European regulation, its requirements apply to all sites and online businesses that collect, store, and process personal data about EU residents no matter where the business is located.<br /></p>\n\n<p>You can learn more about the GDPR from the European Commission&#8217;s <a href=\"http://ec.europa.eu/justice/smedataprotect/index_en.htm\">Data Protection page</a>.<br /></p>\n\n<p>We&#8217;re committed to supporting site owners around the world in their work to comply with this important law. As part of that effort, we’ve added a number of new privacy features in this release.</p>\n\n<h2 style=\"text-align:left\">Comments</h2>\n\n<figure class=\"wp-block-image\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/05/comments-border.png?w=632&#038;ssl=1\" alt=\"A screenshot of a comment form, where the new &quot;Save my name, email, and website in this browser for the next time I comment&quot; checkbox is featured.\" class=\"wp-image-5986\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2018/05/comments-border.png?w=1264&amp;ssl=1 1264w, https://i1.wp.com/wordpress.org/news/files/2018/05/comments-border.png?resize=300{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2C291&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2018/05/comments-border.png?resize=768{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2C744&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2018/05/comments-border.png?resize=1024{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2C992&amp;ssl=1 1024w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n<p>Logged-out commenters will be given a choice on whether their name, email address, and website are saved in a cookie on their browser.</p>\n\n<h2 style=\"text-align:left\">Privacy Policy Page</h2>\n\n<figure class=\"wp-block-image\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/05/privacy-policy-collapsed.png?w=632&#038;ssl=1\" alt=\"A screenshot of the new Privacy Settings page.\" class=\"wp-image-5995\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2018/05/privacy-policy-collapsed.png?w=1898&amp;ssl=1 1898w, https://i1.wp.com/wordpress.org/news/files/2018/05/privacy-policy-collapsed.png?resize=300{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2C177&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2018/05/privacy-policy-collapsed.png?resize=768{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2C453&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2018/05/privacy-policy-collapsed.png?resize=1024{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2C604&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2018/05/privacy-policy-collapsed.png?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n<p>Site owners can now designate a privacy policy page. This page will be shown on your login and registration pages. You should manually add a link to your policy to every page on your website. If you have a footer menu, that’s a great place to include your privacy policy.<br /></p>\n\n<p>In addition, we’ve created a guide that includes insights from WordPress and participating plugins on how they handle personal data. These insights can be copied and pasted into your site&#8217;s privacy policy to help you get started.<br /></p>\n\n<p>If you maintain a plugin that collects data, we recommend including that information in WordPress’ privacy policy guide. <a href=\"https://developer.wordpress.org/plugins/privacy/\">Learn more in our Privacy section of the Plugin Handbook</a>.</p>\n\n<h2 style=\"text-align:left\">Data Handling</h2>\n\n<figure class=\"wp-block-image\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?w=632&#038;ssl=1\" alt=\"A screenshot of the new Export Personal Data tools page. Several export requests are listed on the page, to demonstrate how the new feature will work.\" class=\"wp-image-5999\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?w=2372&amp;ssl=1 2372w, https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?resize=300{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2C221&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?resize=768{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2C565&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?resize=1024{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2C753&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?w=1264&amp;ssl=1 1264w, https://i1.wp.com/wordpress.org/news/files/2018/05/export-data.png?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n<div class=\"wp-block-columns has-2-columns\">\n		<h3 class=\"layout-column-1\">Data Export</h3>\n	\n		<p class=\"layout-column-1\">Site owners can export a ZIP file containing a user&#8217;s personal data, using data gathered by WordPress and participating plugins.</p>\n	\n		<h3 class=\"layout-column-2\">Data Erasure</h3>\n	\n		<p class=\"layout-column-2\">Site owners can erase a user&#8217;s personal data, including data collected by participating plugins.</p>\n	</div>\n\n<blockquote class=\"wp-block-quote\">\n	<p>Howdy,</p>\n	<p>A request has been made to perform the following action on your account:<br /> </p>\n	<p><strong>Export Personal Data</strong><br /> </p>\n	<p>To confirm this, please click on the following link:<br /><a href=\"#\">http://.wordpress.org/wp-login.php?action=confirmaction&#8230;</a><br /> </p>\n	<p>You can safely ignore and delete this email if you do not want to<br /> take this action.<br /> </p>\n	<p>This email has been sent to <a href=\"#\">you@example.com</a>.<br /> </p>\n	<p>Regards,<br /><em>Your friends at WordPress</em><br /><a href=\"http://wordpress.org\"><em> http://wordpress.org</em></a></p>\n</blockquote>\n\n<p>Site owners have a new email-based method that they can use to confirm personal data requests. This request confirmation tool works for both export and erasure requests, and for both registered users and commenters.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2 style=\"text-align:left\">Maintenance</h2>\n\n<p>95 updates were made in WordPress 4.9.6. In addition to the above, particularly of note were:<br /></p>\n\n<ul>\n	<li>&#8220;Mine&#8221; has been added as a filter in the media library.</li>\n	<li>When viewing a plugin in the admin, it will now tell you the minimum PHP version required.</li>\n	<li>We&#8217;ve added new PHP polyfills for forwards-compatibility and proper variable validation.</li>\n	<li>TinyMCE was updated to the latest version (4.7.11).<br /></li>\n</ul>\n\n<p><a href=\"https://make.wordpress.org/core/2018/05/17/4-9-6-update-guide/\">This post has more information about all of the issues fixed in 4.9.6 if you&#8217;d like to learn more</a>.</p>\n\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.9.6</a> or venture over to Dashboard → Updates and click &#8220;Update Now.&#8221; Sites that support automatic background updates will start updating soon.<br /></p>\n\n<p class=\"has-background has-very-light-gray-background-color\">Please note that if you’re currently on WordPress 4.9.3, you should manually update your site immediately.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<p>Thank you to everyone who contributed to WordPress 4.9.6:<br /><a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/abdullahramzan/\">abdullahramzan</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a>, <a href=\"https://profiles.wordpress.org/allendav/\">allendav</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andreamiddleton/\">Andrea Middleton</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a>, <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/bridgetwillard/\">bridgetwillard</a>, <a href=\"https://profiles.wordpress.org/burlingtonbytes/\">Burlington Bytes</a>, <a href=\"https://profiles.wordpress.org/chetan200891/\">Chetan Prajapati</a>, <a href=\"https://profiles.wordpress.org/claudiu/\">claudiu</a>, <a href=\"https://profiles.wordpress.org/coreymckrill/\">Corey McKrill</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/iseulde/\">Ella Van Dorpe</a>, <a href=\"https://profiles.wordpress.org/ericdaams/\">Eric Daams</a>, <a href=\"https://profiles.wordpress.org/fclaussen/\">Fernando Claussen</a>, <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/idea15/\">Heather Burns</a>, <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a>, <a href=\"https://profiles.wordpress.org/herregroen/\">herregroen</a>, <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ianbelanger/\">ibelanger</a>, <a href=\"https://profiles.wordpress.org/imath/\">imath</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jesperher/\">Jesper V Nielsen</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">JJJ</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a>, <a href=\"https://profiles.wordpress.org/jrf/\">jrf</a>, <a href=\"https://profiles.wordpress.org/dejliglama/\">Kåre Mulvad Steffensen</a>, <a href=\"https://profiles.wordpress.org/lakenh/\">Laken Hafner</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>, <a href=\"https://profiles.wordpress.org/lbenicio/\">lbenicio</a>, <a href=\"https://profiles.wordpress.org/macbookandrew/\">macbookandrew</a>, <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/mnelson4/\">Michael Nelson</a>, <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley</a>, <a href=\"https://profiles.wordpress.org/casiepa/\">Pascal Casier</a>, <a href=\"https://profiles.wordpress.org/pbarthmaier/\">pbrocks</a>, <a href=\"https://profiles.wordpress.org/postphotos/\">postphotos</a>, <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a>, <a href=\"https://profiles.wordpress.org/presstigers/\">PressTigers</a>, <a href=\"https://profiles.wordpress.org/programmin/\">programmin</a>, <a href=\"https://profiles.wordpress.org/littlerchicken/\">Robin Cornett</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/satollo/\">Stefano Lissa</a>, <a href=\"https://profiles.wordpress.org/stephdau/\">Stephane Daury (stephdau)</a>, <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a>, <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/teddytime/\">teddytime</a>, <a href=\"https://profiles.wordpress.org/thomasplevy/\">thomasplevy</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/tz-media/\">Tobias Zimpel</a>, <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a>, <a href=\"https://profiles.wordpress.org/tobifjellner/\">Tor-Bjorn Fjellner</a>, <a href=\"https://profiles.wordpress.org/itowhid06/\">Towhidul Islam</a>, <a href=\"https://profiles.wordpress.org/voneff/\">voneff</a>, <a href=\"https://profiles.wordpress.org/earnjam/\">William Earnhardt</a>, and <a href=\"https://profiles.wordpress.org/xkon/\">Xenos (xkon) Konstantinos</a>.<br /></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"5920\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 25 Sep 2018 16:43:07 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Mon, 03 Sep 2018 11:00:43 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";s:14:\"20130911133210\";}","no");
INSERT INTO wpjs_options VALUES("212","_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca","1537936987","no");
INSERT INTO wpjs_options VALUES("213","_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca","1537893787","no");
INSERT INTO wpjs_options VALUES("214","_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9","1537936987","no");
INSERT INTO wpjs_options VALUES("215","_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WPTavern: Gutenberg 3.9 Introduces Reusable, Exportable Templates for Multiple Blocks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84179\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://wptavern.com/gutenberg-3-9-introduces-reusable-exportable-templates-for-multiple-blocks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3107:\"<p><a href=\"https://make.wordpress.org/core/2018/09/21/whats-new-in-gutenberg/\" rel=\"noopener noreferrer\" target=\"_blank\">Gutenberg 3.9</a> was released last week with a new feature that allows users to group multiple blocks into reusable templates. The templates can also be exported and imported as a JSON file.</p>\n<p>The idea of reusable templates is an expansion of the concept of <a href=\"https://github.com/WordPress/gutenberg/issues/1516\" rel=\"noopener noreferrer\" target=\"_blank\">dynamic reusable blocks</a> that Gutenberg technical lead Matias Ventura proposed in June 2017. Reusability is even more powerful when applied to multiple blocks. The import/export capabilities make it possible for templates to be easily shared across WordPress sites.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/09/Screen-Shot-2018-09-24-at-1.04.36-PM.png?ssl=1\"><img /></a></p>\n<p>If you want to test it, you can select multiple blocks by selecting the content inside a block and dragging outside the boundaries of the block to extend the selection to multiple blocks. The <a href=\"https://github.com/WordPress/gutenberg/issues/62\" rel=\"noopener noreferrer\" target=\"_blank\">multi-select feature</a> was originally added for the purpose of deleting or moving multiple blocks but it has now become indispensable for creating reusable templates.</p>\n<p>This feature lays the ground work for a full-fledged layout builder in the next phase of Gutenberg development. Reusable templates should make it a breeze to build WordPress sites with pre-defined layouts that users and developers can share. They are much more intuitive to implement than page templates.</p>\n<p>&#8220;Holy wow, imagine this: wp-blueprints.com, where people can group blocks together and share their JSON strings with nice little copy buttons,&#8221; Gutenberg designer Joen Asmussen commented on the PR. &#8220;Categories for top rated, most downloaded, search, etc? This is going to happen because of this magic.&#8221;</p>\n<p>Matias Ventura&#8217;s demo video shows the reusable templates in action. It also highlights a new tool for <a href=\"https://github.com/WordPress/gutenberg/pull/7995\" rel=\"noopener noreferrer\" target=\"_blank\">visually comparing possible ways to convert an invalid block</a>. The editor now includes a diff UI for blocks, which Ventura said could possibly scale in the future to provide an improved UX for revisions as a whole.</p>\n<p></p>\n<p>A few other notable additions in the 3.9 release include improvements to the drag and drop handle, collapsible groups for the block toolbar, and the ability to convert a cover image block to an image and back. <a href=\"https://github.com/WordPress/gutenberg/pull/9683\" rel=\"noopener noreferrer\" target=\"_blank\">Dark editor style support</a> is now available for theme developers, making Gutenberg more friendly for use with dark WordPress themes. Check out the <a href=\"https://make.wordpress.org/core/2018/09/21/whats-new-in-gutenberg/\" rel=\"noopener noreferrer\" target=\"_blank\">3.9 changelog</a> to see a full list of enhancements and bug fixes.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 24 Sep 2018 23:32:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: New commonWP Plugin Enables WordPress Sites to Use the Free jsDelivr CDN\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84046\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wptavern.com/new-commonwp-plugin-enables-wordpress-sites-to-use-the-free-jsdelivr-cdn\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5414:\"<p>Milan Dinić, a WordPress developer based in Serbia, has released his <a href=\"https://wordpress.org/plugins/commonwp/\" rel=\"noopener noreferrer\" target=\"_blank\">commonWP</a> plugin that enables WordPress sites to use the free, public <a href=\"https://www.jsdelivr.com/\" rel=\"noopener noreferrer\" target=\"_blank\">jsDelivr</a> CDN. Last year <a href=\"https://www.jsdelivr.com/blog/jsdelivr-reloaded-2017/\" rel=\"noopener noreferrer\" target=\"_blank\">jsDelivr was revamped</a> to allow any file from GitHub and npm to be served by the CDN. WordPress&#8217; mirror on GitHub made it possible for Dinić to create a plugin that works with the CDN.</p>\n<p>commonWP aims to speed up performance by offloading JavaScript and CSS files to jsDelivr, including the following:</p>\n<ul>\n<li>All files from WordPress core (unless development version of WordPress is in use)</li>\n<li>All files from plugins hosted by WordPress.org Plugins Repository (unless author of specific plugin doesn’t use SVN tags for releasing)</li>\n<li>All files from themes hosted by WordPress.org Themes Repository</li>\n<li>All files from plugins and themes hosted on GitHub that support GitHub Updater</li>\n<li>All files marked as available on npm in any type of theme, plugin, or MU plugin</li>\n</ul>\n<p>Dinić said he designed commonWP with a emphasis on keeping it lightweight, easy-to-use, and secure. He claims the approach he used in the plugin is safer than any other plugin that employs a CDN for WordPress files:</p>\n<blockquote><p>First, commonWP will only rewrite file to point to one on jsDelivr if that remote file is identical to local one. Second, during comparison, it generates <a href=\"https://developer.mozilla.org/en-US/docs/Web/Security/Subresource_Integrity\" rel=\"noopener noreferrer\" target=\"_blank\">subresource identity hash</a> of remote jsDelivr file and includes that hash in page’s source code so browser won’t load remote file if it doesn’t have exactly the same hash.</p></blockquote>\n<p>Dinić recommends the plugin for users who are not already using a CDN, have limited budgets, or live in less developed countries.</p>\n<p>&#8220;Using a CDN is generally recommended, and with this one they might get even more speed because some files might be already cached by their visitors,&#8221; he said. &#8220;Imagine if jquery.js, jquery-migrate.min.js (most common files) are always served from one place. You wouldn&#8217;t need to get them from each WordPress site you visit. You would get them once and they would be in your browser&#8217;s cache, and initial page load would be faster.&#8221;</p>\n<p>Dinić referenced a Trac <a href=\"https://core.trac.wordpress.org/ticket/44229\" rel=\"noopener noreferrer\" target=\"_blank\">ticket</a> where using a CDN is proposed for serving assets like jQuery, but no action has been taken on the proposal yet. One benefit he cites for WordPress&#8217; global user base is that a CDN like jsDelivr allows visitors to get files from their own content, country, or even the same city. jsDelivr has a large multi-CDN network with infrastructure built on top of other networks, including StackPath, Cloudflare, Fastly, and Quantil. It also has custom servers in locations like China where other public CDNs have little or no presence.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/09/Screen-Shot-2018-09-21-at-2.39.40-PM.png?ssl=1\"><img /></a></p>\n<p>commonWP doesn&#8217;t have any settings for users to configure. The plugin fills up its cache in the background after it is activated. Developers can fine tune it for their needs and Dinić has published some <a href=\"https://github.com/dimadin/commonWP#marking-files-that-exist-in-npm\" rel=\"noopener noreferrer\" target=\"_blank\">code examples</a> to GitHub.</p>\n<p>In his release <a href=\"https://milandinic.com/2018/09/18/introducing-commonwp/\" rel=\"noopener noreferrer\" target=\"_blank\">post</a>, Dinić referenced a Serbian site getting a 1-second loading improvement and has done other tests but said he&#8217;s still looking for a good way to present the data. The plugin&#8217;s FAQ outlines which factors influence whether or not commonWP can bring performance improvements:</p>\n<ul>\n<li>How many of your files are available on jsDelivr and can be rewritten &#8211; the more files on jsDelivr, the more speed; the more files used by the page are rewritten to jsDelivr, the more speed.</li>\n<li>The further your site&#8217;s visitors are from the server your site is hosted on, the more speed you can get.</li>\n<li>The slower your server is, the more speed it can get.</li>\n<li>If your visitors already visited WordPress site(s) with commonWP activated, there is more chance that some of the files you use on your site are already cached by them so they can get more speed.</li>\n</ul>\n<p>Not every site will see drastic improvements for site owners testing performance, but visitors from other parts of the world may be able to load certain files faster. Dinić recommends users test their sites using webpagetest.org and select a higher number of tests to get an average. He also recommends testing with different locations and different connection speeds. Test with the plugin activated and deactivated and when the site has a full cache. In general, the further the location is from the server and the larger number of files sent to jsDelivr, the bigger the performance improvement will be.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 21 Sep 2018 20:19:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"WPTavern: Gutenstats Blog Is Live, Tracking Gutenberg Beta Testing Data\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84153\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://wptavern.com/gutenstats-blog-is-live-tracking-gutenberg-beta-testing-data\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1455:\"<p>Matt Mullenweg <a href=\"https://twitter.com/photomatt/status/1042901193679241216\" rel=\"noopener noreferrer\" target=\"_blank\">tweeted</a> out a link to <a href=\"https://gutenstats.blog/\" rel=\"noopener noreferrer\" target=\"_blank\">Gutenstats.blog</a> this evening, a new site dedicated to tracking Gutenberg beta testing data. The site shows there are currently more than 420,000 active installations of Gutenberg, a slightly more precise number than reported on the WordPress.org plugin page (400K+).</p>\n<p>Gutenstats also tracked 213,000 posts written with the new editor and 8,142 posts written yesterday. These numbers were collected from posts made on WordPress.com and Jetpack sites since late August 2018 and a note on the site says the actual number is higher.</p>\n<p>In June, Mullenweg unveiled a <a href=\"https://wptavern.com/matt-mullenweg-unveils-gutenberg-roadmap-at-wceu-wordpress-agencies-and-product-developers-sprint-to-prepare\" rel=\"noopener noreferrer\" target=\"_blank\">roadmap for Gutenberg to land in WordPress 5.0</a>. At that time the plugin was active on just 14,000 sites. He proposed 100K+ sites having made 250K+ posts using Gutenberg as a threshold for adequate pre-5.0 testing.</p>\n<p>Gutenstats tracking shows testing has far exceeded the original goal for active installations and should reach the posts written goal in just a few days. Mullenweg said they plan to add some block stats to the tracking page in the future.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 21 Sep 2018 04:21:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"WPTavern: ACF 5.0 Released with Updated UI and Gutenberg Compatibility\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84105\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://wptavern.com/acf-5-0-released-with-updated-ui-and-gutenberg-compatibility\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2771:\"<p><a href=\"https://www.advancedcustomfields.com/blog/acf-5-0-release/\" rel=\"noopener noreferrer\" target=\"_blank\">ACF version 5.0</a> landed on WordPress.org this week with Gutenberg compatibility now available for more than one million sites where the plugin is active. The release is a welcome update for developers who were concerned about what would happen in real world usage of Gutenberg on sites with ACF-powered customizations. ACF&#8217;s Gutenberg compatibility is arriving well ahead of WordPress 5.0&#8217;s TBD schedule for merging the new editor, giving developers time to get their clients&#8217; sites ready.</p>\n<p>&#8220;You can expect to see lots of Gutenberg related items in our changelogs over the coming months as we edge nearer to WordPress version 5.0,&#8221; the ACF announcement stated. &#8220;You’ll also want to take note that ACF 5 is the only version that will provide Gutenberg support. Previous versions will not be compatible.&#8221;</p>\n<p>The version numbers across ACF Pro and the free version on WordPress.org are somewhat confusing. This particular release is significant in that it brings several years of development from the Pro version into the plugin hosted on WordPress.org. Now both products are technically on v5.7.6.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Hi guys. This version 5 release is for our “free plugin” on <a href=\"https://t.co/V7oUQSI5Ei\">https://t.co/V7oUQSI5Ei</a> and does not affect ACF PRO. Now both ACF and ACF PRO are v5.7.6!</p>\n<p>&mdash; Advanced Custom Fields (@wp_acf) <a href=\"https://twitter.com/wp_acf/status/1041590825505849344?ref_src=twsrc{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}5Etfw\">September 17, 2018</a></p></blockquote>\n<p></p>\n<p>ACF 5.0 introduces a redesigned UI, performance improvements, and the plugin&#8217;s new <a href=\"https://www.advancedcustomfields.com/resources/local-json/\" rel=\"noopener noreferrer\" target=\"_blank\">Local JSON</a> feature, which saves field group and field settings as .json files within the user&#8217;s theme. This reduces database calls and allows for version control of field settings.</p>\n<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/09/acf-5-0-fresh-ui.jpg?ssl=1\"><img /></a>image credit: <a href=\"https://www.advancedcustomfields.com/blog/acf-5-0-release/\">ACF</a>\n<p>Version 5.0 adds six new fields, including a link, group, accordion, oEmbed, date time picker, and clone fields (an ACF pro feature). It also introduce a new Tools page where users can export and import field groups as JSON.</p>\n<p>For more information on items related to upgrading ACF and add-on compatibility, check out the official <a href=\"https://www.advancedcustomfields.com/blog/acf-5-0-release/\" rel=\"noopener noreferrer\" target=\"_blank\">5.0 release post</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Sep 2018 17:54:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"WPTavern: WPForms Acquires Pirate Forms, Plugin to be Retired\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84108\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wptavern.com/wpforms-acquires-pirate-forms-plugin-to-be-retired\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3737:\"<a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/09/pirates.jpg?ssl=1\"><img /></a>photo credit: Reiterlied <a href=\"http://www.flickr.com/photos/126661502@N05/37773453702\">Plundering San Francisco Bay</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nc-sa/2.0/\">(license)</a>\n<p><a href=\"https://wpforms.com/wpforms-has-acquired-pirate-forms/\" rel=\"noopener noreferrer\" target=\"_blank\">WPForms has acquired Pirate Forms</a>, a popular WordPress contact form and SMTP plugin originally created by ThemeIsle in 2015. The announcement coincides with International Talk Like a Pirate Day but the pirate branding of the plugin is set to be retired and its users will be given the option to migrate to WPForms.</p>\n<p><a href=\"https://wordpress.org/plugins/pirate-forms/\" rel=\"noopener noreferrer\" target=\"_blank\">Pirate Forms</a> was purchased in what WPForms co-founder and CEO Syed Balkhi describes as &#8220;an all-cash deal.&#8221; Although the plugin currently has more than 300,000 users on WordPress.org, its features and capabilities are inferior to the more modern WPForms and its creators lacked the resources to bring it up to speed.</p>\n<p>Pirate Forms had gained popularity in its earlier days by providing a simple forms plugin (without all the builder functions) for sites that required just one contact form.</p>\n<p>&#8220;Where most of the other plugins aim at &#8216;mega functionality&#8217; with tons of customizations, add-ons and whatnots, Pirate Forms has made a bet on simplicity,&#8221; ThemeIsle representative Karol K said in the plugin&#8217;s <a href=\"https://themeisle.com/blog/pirate-forms-is-now-wpforms/\" rel=\"noopener noreferrer\" target=\"_blank\">farewell post</a>.</p>\n<p>&#8220;In other words, it just works(ed) right after the installation, with no particular setup required (other than adding your form to a contact page). This was a nice refreshment compared to the usual &#8216;get through tons of onboarding wizard screens before you can use the plugin&#8217; -approach.&#8221;</p>\n<p>Pirate Forms could no longer deliver what users expect from a forms plugin in 2018 and ThemeIsle opted to find a buyer in order to free up resources to focus on releasing the <a href=\"https://themeisle.com/blog/hestia-2-0/\" rel=\"noopener noreferrer\" target=\"_blank\">Hestia 2.0</a> theme.</p>\n<p>&#8220;This acquisition further strengthens WPForms&#8217; position in the WordPress ecosystem,&#8221; Balkhi said. The expectation is that a large number of users will migrate their forms to WPForms as the result of Pirate Forms discontinuing active development.</p>\n<p><a href=\"https://wpforms.com/docs/how-to-move-from-pirate-forms-to-wpforms/\" rel=\"noopener noreferrer\" target=\"_blank\">A migration path to WPForms</a> is built into the latest version of Pirate Forms and Balkhi describes the process as a seamless transition. Users are also free to select another forms plugin but they will not have the benefit of the migration tool, which also imports the notification email and confirmation settings from users&#8217; existing forms. Those who have purchased Pirate Forms Pro will receive a free one-year license to WPForms Pro.</p>\n<p><a href=\"https://wordpress.org/plugins/wpforms-lite/\" rel=\"noopener noreferrer\" target=\"_blank\">WPForms</a> has more than 1 million active installs and currently maintains a 4.9 out of 5 star average rating on WordPress.org. The drag-and-drop WordPress form builder is much more advanced than Pirate Forms and the free version allows users to create contact forms, subscription forms, payment forms, offline forms, multi-page forms, and many other types of customized feedback mechanisms. It is also compatible with all of ThemeIsle&#8217;s themes.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Sep 2018 02:50:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"WPTavern: Big Bite Creative to Launch New Amnesty International Website based on Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84074\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"https://wptavern.com/big-bite-creative-launches-new-amnesty-international-website-based-on-gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4776:\"<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/09/Screen-Shot-2018-09-19-at-10.39.11-AM.png?ssl=1\"><img /></a></p>\n<p>The team at <a href=\"http://bigbitecreative.com\" rel=\"noopener noreferrer\" target=\"_blank\">Big Bite Creative</a> has developed a new website for Amnesty International using Gutenberg, soon to be launched at <a href=\"http://amnesty.eu\" rel=\"noopener noreferrer\" target=\"_blank\">amnesty.eu</a>. The agency worked in partnership with <a href=\"https://vip.wordpress.com\" rel=\"noopener noreferrer\" target=\"_blank\">WordPress.com VIP</a> to provide the London-based human rights organization with the tools to create multiple sites that could be uniquely customized for their editorial needs.</p>\n<p>After successfully using Gutenberg to launch a site for an international bank, Big Bite CTO Jason Agnew said his team gained confidence to use the new editor for the Amnesty site. The client approached Bite Bite around the time of WordCamp Europe when Matt Mullenweg unveiled a roadmap for getting a stable Gutenberg release before the end of the year.</p>\n<p>&#8220;On top of this the Amnesty project suited Gutenberg,&#8221; Agnew said. &#8220;Their brief mentioned 14 components which could be used to build out multiple sites. I honestly think it would have been difficult to build something that required this level of flexibility with a field manager like Fieldmanager, CMB2 or ACF. Perhaps it would have been possible with page builders like Visual Composer, but these platforms are still figuring out how they will work with the WordPress 5.0.&#8221;</p>\n<p>Through the use of a combination of prompts, custom blocks, nested blocks, and predefined styles, Big Bite made it possible for even non-technical editorial staff to create and arrange content to build out websites for various outreach locations.</p>\n<p>&#8220;It&#8217;s been fascinating to give the client full control over the site structure compared to the more traditional development of templates,&#8221; Agnew said. &#8220;We are still in the early stages of launching sites with the new platform, but the client has built up the EU site on their own without much support, which should be going live early October. Now they are in the process building out websites for Mali and Iran, with the goal to launch around 20 sites initially. We&#8217;ve had the editorial team describe the experience as fun &#8211; that&#8217;s from a team who have used WordPress with ACF in the past, which does offer an intuitive UI but still requires a level of training of what fields relate to what pieces of content on the front-end.&#8221;</p>\n<p>As many others have reported, one of the most challenging things Big Bite encountered in extending Gutenberg was the project&#8217;s incomplete documentation.</p>\n<p>&#8220;We&#8217;ve had our challenges, and particularly the Gutenberg documentation is not up to standard, which leads to a lot of time being wasted,&#8221; Agnew said. &#8220;But I have to say once our team get over the first block or two it wasn&#8217;t an issue. It&#8217;s important to say that the Gutenberg team Slack have been a great help when we did run into problems. We did discover IE11 support is still a work in progress, for example, copy &amp; paste didn&#8217;t work, meta boxes wouldn&#8217;t render causing saving issues with posts.&#8221;</p>\n<p>Agnew said for most issues there isn&#8217;t a lot one can do to resolve them apart from waiting for each update as the plugin improves, but it&#8217;s something agencies need to account for when working with clients. The Big Bite team also found that Gutenberg compatibility is still an issue for many of the plugins that they looked at using for the project.</p>\n<p>&#8220;Apart from using Yoast we&#8217;ve mainly custom built the theme due to many plugins still requiring UI changes to work well with Gutenberg,&#8221; Agnew said. &#8220;Probably the most significant feature we wrote was language syndication system.&#8221;</p>\n<p>Big Bite plans to open source Amnesty International&#8217;s full theme, which includes all of the custom blocks. Prior to that they are going to remove all the branding to avoid lots of new sites popping looking like the Amnesty brand. The agency is aiming for publishing the code the same day as WordPress 5.0 is released or earlier if the release is delayed beyond January.</p>\n<p>For a closer look at the Amnesty International project, check out Big Bite&#8217;s announcement <a href=\"https://bigbitecreative.com/investing-gutenberg-amnesty-international/\" rel=\"noopener noreferrer\" target=\"_blank\">post</a>. The video below was created in partnership with WordPress.com VIP and offers a tour of some of the custom Gutenberg blocks they created for Amnesty.</p>\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 19 Sep 2018 19:12:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"HeroPress: The “India is cheap” Stereotype\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://heropress.com/?p=2627\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"https://heropress.com/the-india-is-cheap-stereotype/#utm_source=rss&utm_medium=rss&utm_campaign=the-india-is-cheap-stereotype\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3284:\"<img width=\"960\" height=\"480\" src=\"https://s20094.pcdn.co/wp-content/uploads/2015/10/MeasureSuccess-HeroPress-2-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull quote: Measure success in terms of the impact your work is making.\" /><p>In the early days of HeroPress there were quite a few Indian contributors, for a variety of reasons. India has long been a technology powerhouse, but the WordPress community was just beginning to get traction. I got to meet many Indians and even traveled there for <a href=\"https://heropress.com/going-to-wordcamp-pune/\">WordCamp Pune</a>. The stereotype that &#8220;India is cheap&#8221; is a difficult one for Indians to deal with. What does it mean? How should it be responded to?</p>\n<p>In October of 2015 Rahul Bansal, the owner of a world class WordPress agency named rtCamp, did a HeroPress essay where he talks about what it means to run an agency in India, charge properly, and turn our work that rivals any from anywhere else in the world.  Check out Rahul&#8217;s thoughts:</p>\n<blockquote class=\"wp-embedded-content\"><p><a href=\"https://heropress.com/essays/wordpress-continues-inspire/\">WordPress Continues to Inspire</a></p></blockquote>\n<p></p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: The “India is cheap” Stereotype\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=The{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}20{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}E2{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}80{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}9CIndia{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}20is{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}20cheap{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}E2{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}80{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}9D{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}20Stereotype&via=heropress&url=https{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}3A{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2F{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fheropress.com{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fthe-india-is-cheap-stereotype{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: The “India is cheap” Stereotype\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}3A{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2F{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fheropress.com{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fthe-india-is-cheap-stereotype{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}3A{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2F{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fheropress.com{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fthe-india-is-cheap-stereotype{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2F&title=The+{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}E2{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}80{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}9CIndia+is+cheap{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}E2{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}80{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}9D+Stereotype\" rel=\"nofollow\" target=\"_blank\" title=\"Share: The “India is cheap” Stereotype\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/the-india-is-cheap-stereotype/&media=https://heropress.com/wp-content/uploads/2015/10/MeasureSuccess-HeroPress-2-150x150.jpg&description=The “India is cheap” Stereotype\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: The “India is cheap” Stereotype\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/the-india-is-cheap-stereotype/\" title=\"The “India is cheap” Stereotype\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/the-india-is-cheap-stereotype/\">The “India is cheap” Stereotype</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 19 Sep 2018 14:59:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"WPTavern: Gutenberg Cloud: A Cross-Platform Community Library for Custom Gutenberg Blocks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=84045\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://wptavern.com/gutenberg-cloud-a-cross-platform-community-library-for-custom-gutenberg-blocks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8949:\"<p>During their <a href=\"https://wptavern.com/drupal-gutenberg-project-receives-enthusiastic-reception-at-drupal-europe\" rel=\"noopener noreferrer\" target=\"_blank\">presentation at Drupal Europe</a>, the <a href=\"https://www.frontkom.no/\" rel=\"noopener noreferrer\" target=\"_blank\">Frontkom</a> team behind the Drupal Gutenberg project announced that they are working on a block management system called <a href=\"https://gutenbergcloud.org/\" rel=\"noopener noreferrer\" target=\"_blank\">Gutenberg Cloud</a>, a collective library of blocks online.</p>\n<p>The library will offer a content repository for custom Gutenberg blocks, such as forms, a call-to-action section, product grid, or even a web component. Since the blocks are JavaScript-only, they would work across both Drupal and WordPress alike, so developers can build for both platforms simultaneously. The Gutenberg Cloud creators are aiming to facilitate a new level of cross-platform sharing that few envisioned when the Gutenberg project began.</p>\n<p>&#8220;Gutenberg to us is much more than just another module,&#8221; Frontkom CIO Per André Rønsen said during their presentation at Drupal Europe. &#8220;We think of it as a platform for brand new features. We are very excited about the sharing/community aspect and the possibilities here. We want to make it easy to share and reuse custom blocks across pages, across projects, across companies, and even across publishing platforms. Drupal has always been great at sharing backend style of code. Now let&#8217;s make it great at sharing frontend code as well. This is why we&#8217;re working on a block managing system.&#8221;</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/09/gutenberg-cloud.png?ssl=1\"><img /></a></p>\n<p>Gutenberg Cloud would provide a plugin for WordPress and a module for Drupal (and eventually other applications) that would enable users to browse, filter, and discover blocks within the admin and download the ones they select. Early mockups I previewed show an interface similar to the theme and plugin browsers inside the WordPress admin.</p>\n<p>A cloud-based block service solves a few problems that Gutenberg early adopters are already experiencing when hunting for blocks. WordPress theme and plugin shops have have been releasing their own block collections bundled into a plugin, but it&#8217;s not easy to discover or browse the individual blocks. Having blocks available on Gutenberg Cloud would prevent developers from having to create a new module or plugin for each individual block. It also prevents users from having to download an entire collection of blocks in a plugin when they really only need one or two of them.</p>\n<h3>Gutenberg Cloud Will Launch as a Community Project, Developers Contribute by Publishing Packages to NPM</h3>\n<p>Rønsen said they plan to launch Gutenberg Cloud as a community project. Any developer can contribute blocks by creating an NPM package and tagging it with &#8220;gutenberg-cloud.&#8221; The description on the cloud service outlines their intentions: &#8220;Code once, use everywhere: As Gutenberg blocks are CMS-agnostic, we want to provide an ecosystem all systems can connect to.&#8221;</p>\n<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/09/Screen-Shot-2018-09-18-at-3.39.54-PM.png?ssl=1\"><img /></a>An example Hero section block published to NPM\n<p>&#8220;We imagine everything from freelancers to big agencies and even community minded non-profits to contribute,&#8221; Rønsen said. &#8220;When people benefit from a better user experience, they tend to want to pay it forward. We have already talked to people in both communities wanting to contribute with code, so that is a great start for the platform.&#8221;</p>\n<p>I asked if his team envisions block creators being able to sell access to their blocks in the future. He said his team is open to finding a payment solution for commercial blocks but only if the community demands it.</p>\n<p>&#8220;Personally, I would be skeptical about committing to a community project that had a very commercial edge,&#8221; Rønsen said. &#8220;I think it&#8217;s important that the project stays focused on open source contributions, with a sharing-is-caring attitude. It&#8217;s the only language we know in Drupal. However, there is nothing wrong in providing high quality content and getting paid to do it. That&#8217;s why it&#8217;s on our roadmap to facilitate a payment solution for premium blocks – if the community wants it. It&#8217;s not central to the success of the platform, but I imagine it could be a great way to make some money for a skilled designer.&#8221;</p>\n<p>Rønsen said his team plans to launch Gutenberg Cloud sometime later this year after completing internal testing and an invitation-only closed beta with a different companies. One of the most challenging aspect of the project is creating a system that can handle updates.</p>\n<p>&#8220;By default users will get the latest stable release for the block from the author,&#8221; Rønsen said. &#8220;There will be a way to lock into a specific version and to version control that in Git, however. The plugin update system is a good analogy, but the infrastructure is completely outside of WordPress core. There are also some issues we haven’t solved yet regarding updates; it’s hard to make a system that doesn’t require a high maintenance effort for block developers.&#8221;</p>\n<p>The Gutenberg Cloud project is contingent upon Gutenberg development continuing on a path towards being a library that is decoupled from WordPress. Last week Rønsen <a href=\"https://wptavern.com/drupal-gutenberg-project-receives-enthusiastic-reception-at-drupal-europe\" rel=\"noopener noreferrer\" target=\"_blank\">told</a> the Tavern that his team hopes &#8220;that Gutenberg core devs will catch onto the vision of Gutenberg as the ‘editor for the open web’ — not just for WordPress.&#8221;</p>\n<p>Gutenberg team member Gary Pendergast indirectly acknowledged this in a recent blog <a href=\"https://pento.net/2018/09/16/the-mission-democratise-publishing/\" rel=\"noopener noreferrer\" target=\"_blank\">post</a> that affirmed the Drupal Gutenberg project and reiterated WordPress&#8217; mission to democratize publishing.</p>\n<p>&#8220;One of the primary philosophies of Gutenberg’s technical architecture is platform agnosticism, and we can see the practical effects of this practice coming to fruition across a variety of projects,&#8221; Pendergast said.</p>\n<p>&#8220;From early experiments in running the block editor as a standalone application, to being able to compile it into a native mobile component, and now seeing it running on Drupal, Gutenberg’s technical goals have always included a radical level of platform agnosticism.&#8221;</p>\n<p>If the Drupal community ends up adopting Gutenberg for its core editor, the shared library presents an unprecedented opportunity for deeper collaboration across the two publishing platforms. As an agency that has done client work for publishers on both CMSs, Frontkom saw the potential before many others and took it upon themselves to fork Gutenberg for Drupal. This is the beauty of open source software in action.</p>\n<p>&#8220;WordPress has many advantages that make it so popular, but hoarding those to ourselves doesn’t help the open web, it just creates more silos,&#8221; Pendergast said. &#8220;The open web is the only platform on which publishing can be democratized, so it makes sense for Gutenberg to work anywhere on the open web, not just inside WordPress. Drupal isn’t a competitor here, we’re all working towards the same goal, the different paths we’ve taken have made the open web stronger as a whole.&#8221;</p>\n<p>Rønsen said he could see other applications and e-commerce platforms like Magento benefitting from better page-building tools. His company has a special interest in publishers and plans to release a set of open source tools for building news front pages later in 2018. Rønsen said he is hopeful the Drupal Gutenberg project can evolve alongside WordPress as it enters into the site building and customization phase of the project.</p>\n<p>&#8220;I&#8217;m hopeful that the Gutenberg project will stay decoupled from WP one way or another,&#8221; Rønsen said. &#8220;This will leave room for Drupal to innovate on top of it. It could even be the case that the page building tools and customizer integration in WP will play nicely into the current architecture. In any case, I believe the basics of the editor and block concept will continue to be a good fit for Drupal. There is already some consensus out there on how to use Gutenberg for page building. A great example, is <a href=\"https://www.youtube.com/watch?v=OgF5ImDlCTw\" rel=\"noopener noreferrer\" target=\"_blank\">Big Bite&#8217;s work with Amnesty</a>. If the continued experience is anything like that, I think we have a perfect match.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Sep 2018 22:38:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Matt: CEOs and the Real World\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=48345\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://ma.tt/2018/09/ceos-and-the-real-world/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4867:\"<blockquote class=\"wp-block-quote\"><p>The downside of Zuckerberg’s exalted status within his company is that it is difficult for him to get genuine, unexpurgated feedback. He has tried, at times, to puncture his own bubble. In 2013, as a New Year’s resolution, he pledged to meet someone new, outside Facebook, every day. In 2017, he travelled to more than thirty states on a “listening tour” that he hoped would better acquaint him with the outside world. David Plouffe, President Obama’s former campaign manager, who is now the head of policy and advocacy at the Chan Zuckerberg Initiative, the family’s philanthropic investment company, attended some events on the tour. He told me, “When a politician goes to one of those, it’s an hour, and they’re talking for fifty of those minutes. He would talk for, like, five, and just ask questions.”</p><p>But the exercise came off as stilted and tone-deaf. Zuckerberg travelled with a professional photographer, who documented him feeding a calf in Wisconsin, ordering barbecue, and working on an assembly line at a Ford plant in Michigan. Online, people joked that the photos made him look like an extraterrestrial exploring the human race for the first time. A former Facebook executive who was involved in the tour told a friend, “No one wanted to tell Mark, and no one did tell Mark, that this really looks just dumb.”</p></blockquote>\n\n<p>There seem to be three communication gaps outlined here in Evan Osnos&#8217;s <a href=\"https://www.newyorker.com/magazine/2018/09/17/can-mark-zuckerberg-fix-facebook-before-it-breaks-democracy\">revealing profile of Mark Zuckerberg</a>: one is getting unvarnished feedback from your employees. Speaking as a fellow CEO and founder, it&#8217;s certainly hard to pop that bubble &#8212; see <a href=\"https://www.youtube.com/watch?v=uAxAVusStCg\">&#8220;the bear is sticky with honey.&#8221;</a> There are a few techniques like skip-level 1:1 meetings, anonymous feedback forms, interviewing new hires, and 360 reviews you can do to try to counter this, but there&#8217;s no panacea and this one requires constant work as you scale.</p>\n\n<p>The second gap is getting the unvarnished truth from your users &#8212; much easier, as they&#8217;re quite happy to tell you what&#8217;s what. I&#8217;ve recently started cold-calling (yes, on the phone!) some of our Jetpack customers just to understand what they love and don&#8217;t love about the experience and about how we can help them solve their business challenges. There&#8217;s a casual intimacy to phone conversations that just can&#8217;t be replicated in other user feedback forums. Pair this with good instrumentation throughout your product so you see what people do and not just what they say and you&#8217;re golden.</p>\n\n<p>The third and last communication gap is the connection to the world as most people experience it. If your status, wealth, or celebrity reach a point that they are shutting you out from &#8220;real&#8221; experiences, take some risks and get outside of your comfort zone. As it turns out, <a href=\"https://www.gq.com/story/the-untold-stories-of-paul-mccartney\">this new GQ profile of Paul McCartney offered a tip on that: </a></p>\n\n<blockquote class=\"wp-block-quote\"><p>McCartney tells me a further such story of a time he took the Hampton Jitney, the slightly upmarket bus service that runs from the Hamptons into Manhattan, because he was deep into Charles Dickens&#8217;s Nicholas Nickleby and he wanted to finish it, and how he then took a local bus uptown, and when a woman blurted from across the bus, &#8220;Hey! Are you Paul McCartney?&#8221; he invited her to sit next to him and chatted all the way uptown. &#8220;It&#8217;s a way of not worrying about your fame,&#8221; he says. &#8220;It&#8217;s a way of not turning into the reclusive rock star. I often say to Nancy: I get in their faces before they get a chance to get in mine.&#8221;</p></blockquote>\n\n<p>Makes me wonder if <a href=\"https://techcrunch.com/2012/09/12/jack-dorsey-bus-bubble/\">Jack Dorsey still rides the bus to work every day</a>. I think this is what Zuckerberg was attempting with his 30-state tour, and hopefully it was helpful even if the optics didn&#8217;t appeal to everyone — the daily habit of his 2013 resolution to meet someone new every day feels more powerful than the touristic 30-state one. But for an entity as large as Facebook maybe it&#8217;s moot, as Casey Newton pointed out <a href=\"https://www.getrevue.co/profile/caseynewton/issues/the-trouble-with-mark-zuckerberg-profiles-133299\">in his newsletter last week</a> it can be quite hard to pin the answers to Facebook&#8217;s real problems, and our democracy&#8217;s real challenges <a href=\"https://ma.tt/2018/09/responsibility-of-technology/\">in the face of targeted online propaganda</a>, to just one person.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Sep 2018 21:35:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"WPTavern: Hybrid Core 5.0 Offers a More Modern, Modular Approach to WordPress Theme Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83987\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://wptavern.com/hybrid-core-5-0-offers-a-more-modern-modular-approach-to-wordpress-development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3877:\"<a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/09/coffee-computer.jpg?ssl=1\"><img /></a>image credit: <a href=\"https://stocksnap.io/photo/JFPYO9HEZR\">Shopify</a>\n<p><a href=\"https://themehybrid.com/weblog/hybrid-core-version-5-0\" rel=\"noopener noreferrer\" target=\"_blank\">Version 5.0</a> of Hybrid Core, one of the longest-running WordPress theme frameworks, is now available. Justin Tadlock celebrated 10 years with his Theme Hybrid community last month and <a href=\"https://wptavern.com/mythic-a-wordpress-starter-theme-by-justin-tadlock-now-in-open-beta\" rel=\"noopener noreferrer\" target=\"_blank\">released his new Mythic starter theme into beta</a>. Mythic was built on top of Hybrid Core and developed in tandem with version 5.0.</p>\n<p>The framework has been rewritten almost entirely from scratch to be a leaner, more modern starting place for theme development. Tadlock describes it as &#8220;a fundamentally different framework, rewritten from the ground up, that supports more modern PHP practices.&#8221;</p>\n<p>&#8220;I started 5.0 with a goal of bringing the framework up to date with more modern PHP practices and code,&#8221; he said. &#8220;The first iteration of the framework was built in 2008, so it was time to get us ready for the next era of theme building.&#8221;</p>\n<p>In nearly a decade of supporting the framework, Tadlock found that users didn&#8217;t always know how to get started building something from scratch. Many copied one of his existing themes and would add and remove things from it based on their own needs.</p>\n<p>Version 5.0 doesn&#8217;t necessarily make it easier to build on top of Hybrid Core with its new, more complicated method of bootstrapping, new <a href=\"https://themehybrid.com/weblog/working-with-the-view-class\" rel=\"noopener noreferrer\" target=\"_blank\">view system for templating</a>, and requirement for using <a href=\"https://getcomposer.org/\" rel=\"noopener noreferrer\" target=\"_blank\">Composer</a>. This is why Tadlock is officially recommending <a href=\"https://themehybrid.com/themes/mythic\" rel=\"noopener noreferrer\" target=\"_blank\">Mythic</a> as the path for building a theme with Hybrid Core in the future. Most of the documentation and tutorials he plans to create in the future will be centered around the Mythic starter theme, which is nearing a 1.0 release.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">We just closed all tickets on the 1.0.0 milestone for the Mythic starter theme! It feels pretty good.</p>\n<p>Barring any OMGBBQ issues between now and tomorrow, you should see an announcement post from me.<a href=\"https://t.co/J4CGLKa1y5\">https://t.co/J4CGLKa1y5</a></p>\n<p>&mdash; Justin Tadlock (@justintadlock) <a href=\"https://twitter.com/justintadlock/status/1041808697813598208?ref_src=twsrc{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}5Etfw\">September 17, 2018</a></p></blockquote>\n<p></p>\n<p>For many theme developers, Mythic&#8217;s use of the BEM (Block-Element-Modifier) CSS class-naming system is their first introduction to a system of non-hierarchal, component-based CSS. Because BEM doesn&#8217;t rely on nested selectors, it&#8217;s easier for users to overwrite CSS that they want to change. Tadlock explains the benefit for child themes in a recent post about <a href=\"https://themehybrid.com/weblog/why-mythic-uses-bem\" rel=\"noopener noreferrer\" target=\"_blank\">why Mythic uses BEM</a>.</p>\n<p>A handful of the Hybrid add-ons are now available as Composer packages, including one for breadcrumbs, customizer controls and settings, Google fonts, and a featured image script. Tadlock plans to split more parts of the framework off into packages in the future for an increasingly modular core.</p>\n<p>Hybrid Core 5.0 requires PHP 5.6+ (with 7.0+ recommended) and WordPress 4.9.6+. Tadlock will support Hybrid Core&#8217;s 4.x series for at least another year to give theme authors time to adapt.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Sep 2018 04:07:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"WPTavern: Yoast SEO 8.2 Adds How-To and FAQ Gutenberg Blocks with Structured Data\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83822\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://wptavern.com/yoast-seo-8-2-adds-how-to-and-faq-gutenberg-blocks-with-structured-data\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2422:\"<p><a href=\"https://yoast.com/yoast-seo-8-2/\" rel=\"noopener noreferrer\" target=\"_blank\">Yoast SEO 8.2</a> was released last week with the plugin&#8217;s first tools designed specifically for Gutenberg. It includes two new How-To and FAQ structured data content blocks for early adopters of the new editor.</p>\n<p>Structured data is content that can be marked up with a shared vocabulary, such as the one provided by <a href=\"http://Schema.org\" rel=\"noopener noreferrer\" target=\"_blank\">Schema.org</a>. Content like products, books, reviews, podcasts, events, and recipes lend themselves well to this specific type of organization. Structured data helps search engines index the site more effectively and communicate results in more compelling ways, such as rich snippets, rich cards, or voice search.</p>\n<p>Structured data is not easy for most WordPress users to implement without the help of a plugin. Now that more content is being created in Gutenberg, users who want their content to display as enhanced search results will need to seek out plugins that make that an automatic part of the content creation process.</p>\n<p>The plugin outlines all the necessary data the users needs to add in order for the How-To and FAQ content blocks to appear as valid pieces of structured data.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/09/faq-structured-data-yoast-seo.png?ssl=1\"><img /></a></p>\n<p>Alongside this release, Yoast&#8217;s <a href=\"https://yoast.com/wordpress/plugins/local-seo/\" rel=\"noopener noreferrer\" target=\"_blank\">Local SEO</a> and the <a href=\"https://yoast.com/wordpress/plugins/local-seo-for-woocommerce/\" rel=\"noopener noreferrer\" target=\"_blank\">WooCommerce SEO</a> plugins have also added two new structured data Gutenberg blocks: an address block and a Google Maps block.</p>\n<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/09/local_seo_content_blocks.jpg?ssl=1\"><img /></a>image credit: <a href=\"https://yoast.com/yoast-seo-8-2/\">Yoast.com</a>\n<p>In the future the Yoast team plans to create many more structured data blocks.</p>\n<p>&#8220;We’ll work first on blocks which we can dogfood on Yoast.com, like Job posting and Event,&#8221; Yoast CTO Omar Reiss <a href=\"https://yoast.com/content-blocks-future-benefit-seo/\" rel=\"noopener noreferrer\" target=\"_blank\">said</a>. &#8220;After that, we’ll just go for the popular ones, like Recipe.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 17 Sep 2018 17:43:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"Gary: The Mission: Democratise Publishing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"https://pento.net/?p=1909\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://pento.net/2018/09/16/the-mission-democratise-publishing/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5406:\"<p>It&#8217;s exciting to see the <a href=\"https://drupalgutenberg.org/\">Drupal Gutenberg</a> project getting under way, it makes me proud of the work we&#8217;ve done ensuring the flexibility of the underlying Gutenberg architecture. One of the primary philosophies of Gutenberg&#8217;s technical architecture is platform agnosticism, and we can see the practical effects of this practice coming to fruition across a variety of projects.</p>\n\n<p>Yoast are <a href=\"https://yoast.com/yoast-seo-8-2/\">creating new features for the block editor</a>, as well as <a href=\"https://yoast.com/yoast-seo-8-0-introducing-the-yoast-seo-gutenberg-sidebar-a-revamped-meta-box/\">porting existing features</a>, which they&#8217;re able to <a href=\"https://twitter.com/aaronjorbin/status/1040988210682318848\">reuse in the classic editor</a>.</p>\n\n<p>Outside of WordPress Core, the Automattic teams who work on <a href=\"https://github.com/Automattic/wp-calypso\">Calypso</a> have been <a href=\"https://github.com/Automattic/wp-calypso/search?q=gutenberg\">busy</a> adding Gutenberg support, in order to make the block editor interface available on WordPress.com. Gutenberg and Calypso are large JavaScript applications, built with strong opinions on design direction and technical architecture, and having <a href=\"https://github.com/Automattic/wp-calypso/issues/27034\">significant component overlap</a>. That these two projects can function together at all is something of an obscure engineering feat that&#8217;s both difficult and overwhelming to appreciate.</p>\n\n<p>If we reached the limit of Gutenberg&#8217;s platform agnosticism here, it would still be a successful project.</p>\n\n<p>But that&#8217;s not where the ultimate goals of the Gutenberg project stand. From <a href=\"https://github.com/youknowriad/standalone-gutenberg\">early experiments</a> in running the block editor as a <a href=\"https://gutenberg-standalone.surge.sh/\">standalone application</a>, to being able to compile it into a <a href=\"https://github.com/wordpress-mobile/gutenberg-mobile\">native mobile component</a>, and now seeing it <a href=\"https://www.drupal.org/project/gutenberg\">running on Drupal</a>, Gutenberg&#8217;s technical goals have always included a radical level of platform agnosticism.</p>\n\n<h2>Better Together</h2>\n\n<p>Inside the WordPress world, significant effort and focus has been on ensuring backwards compatibility with existing WordPress sites, plugins, and practices. Given that WordPress is such a hugely popular platform, it&#8217;s exceedingly important to ensure this is done right. With Gutenberg expanding outside of the WordPress world, however, we&#8217;re seeing different focuses and priorities arise.</p>\n\n<p>The <a href=\"https://gutenbergcloud.org/\">Gutenberg Cloud</a> service is a fascinating extension being built as part of the Drupal Gutenberg project, for example. It provides a method for new blocks to be shared and discovered, the <a href=\"https://www.npmjs.com/package/@frontkom/g-hero-section\">sample hero block</a> sets a clear tone of providing practical components that can be rapidly put together into a full site. While we&#8217;ve certainly seen similar services appear for the various site builder plugins, this is the first one (that I&#8217;m aware of, at least) build specifically for Gutenberg.</p>\n\n<p>By making the Gutenberg experience available for everyone, regardless of their technical proficiency, experience, or even <em>preferred platform</em>, we pave the way for a better future for all.</p>\n\n<h2>Democratising Publishing</h2>\n\n<p>You might be able to guess where this is going. <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f609.png\" alt=\"😉\" class=\"wp-smiley\" /></p>\n\n<p>WordPress&#8217; mission is to &#8220;democratise publishing&#8221;. It isn&#8217;t to &#8220;be the most popular CMS&#8221;, or to &#8220;run on old versions of PHP&#8221;, though it&#8217;s easy to think that might be the case on the surface. That these statements are true is simply a side effect of the broader principle: All people, regardless of who they are or where they come from, should be able to publish their content as part of a free and open web.</p>\n\n<p>The WordPress mission is not to &#8220;democratise publishing with WordPress&#8221;.</p>\n\n<p>WordPress has many advantages that make it so popular, but hoarding those to ourselves doesn&#8217;t help the open web, it just creates more silos. The open web is the only platform on which publishing can be democratised, so it makes sense for Gutenberg to work anywhere on the open web, not just inside WordPress. Drupal isn&#8217;t a competitor here, we&#8217;re all working towards the same goal, the different paths we&#8217;ve taken have made the open web stronger as a whole.</p>\n\n<p>Much as the block editor has been the first practical implementation of the Gutenberg architecture, WordPress is simply the first practical integration of the block editor into a CMS. The Gutenberg project will expand into site customisation and theming next, and while there&#8217;s no requirement that Drupal make use of these, I&#8217;d be very interested to see what they came up with if they did. Bringing together our many years of experience in tackling these complex problems can only make the end result better.</p>\n\n<p>I know I&#8217;m looking forward to all of us working together for the betterment of the open web.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 16 Sep 2018 04:48:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Gary\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"WPTavern: Gutenberg 3.8 Released, Adds Full Screen Mode\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83861\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wptavern.com/gutenberg-3-8-released-adds-full-screen-mode\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2254:\"<p>Gutenberg 3.8 is <a href=\"https://wordpress.org/plugins/gutenberg/\">available for download</a>. This release features a full screen mode that hides both the admin bar and the menu. Unlike previous versions of Distraction-Free-Writing mode where things would fade in and out of view, these two items stay hidden until full-screen mode is disabled.</p>\n\n<p>User Interface elements have been added to manage reusable blocks in bulk. Theme authors are now able to <a href=\"https://github.com/WordPress/gutenberg/pull/9008\">register editor styles</a> for blocks by targeting the blocks themselves. This avoids combating CSS specificity and doesn&#8217;t require knowledge of the internal DOM structure for the editor. </p>\n\n<p>The block settings icon has been moved from the right side of blocks to the toolbar. This change sets the foundation for refactoring the toolbar and it reduces clutter by keeping the icons together.<br /></p>\n\n<img />Block Settings Moved to The Right Side of The Toolbar\n\n<p>Gutenberg 3.8 also contains a significant increase in performance thanks to a new <a href=\"https://github.com/WordPress/gutenberg/pull/8083\">hand-coded default</a> block parser. </p>\n\n<blockquote class=\"wp-block-quote\"><p>Having a formal specification of the Gutenberg block grammar has allowed us both to maintain a stable core during the almost 40 releases of the plugin and lately to allow competing parser implementation to evolve and be compared in terms of performance and correctness. </p><p>In concrete terms, we are shipping <a href=\"https://github.com/WordPress/gutenberg/pull/8083\">a new default implementation</a> that is hundreds of times faster than the spec and has been stress tested with really long posts (including Moby Dick). These tests are also available for anyone to run against. Memory consumption has also gone down dramatically for server side operations. I’d like to specially thank Dennis Snell and Ivan Enderlin for their great work improving this area.</p><cite>Matias Ventura </cite></blockquote>\n\n<p>To see a complete list of changes along with links to their corresponding pull requests, check out <a href=\"https://make.wordpress.org/core/2018/09/12/whats-new-in-gutenberg-12th-september/\">the release post.</a> </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 15 Sep 2018 00:08:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"WPTavern: Gutenberg is Slowly Rolling Out to WordPress.com Users\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83331\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wptavern.com/gutenberg-is-slowly-rolling-out-to-wordpress-com-users\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1483:\"<p>As part of <a href=\"https://wptavern.com/matt-mullenweg-unveils-gutenberg-roadmap-at-wceu-wordpress-agencies-and-product-developers-sprint-to-prepare\">the roadmap</a> unveiled at WordCamp EU earlier this year, WordPress.com has started rolling out Gutenberg to a subset of users. </p>\n\n<div class=\"wp-block-image\"><img />Try Gutenberg Call-out on WordPress.com</div>\n\n<p>According to a <a href=\"https://en.forums.wordpress.com/topic/information-on-gutenberg-implementation/#post-3173840\">WordPress.com Happiness Engineer</a>, the team is testing the implementation to determine the best way and time to enable it. Users will not be able to use Gutenberg unless their theme is updated to support blocks and the various alignment options. </p>\n\n<p>Theme Wranglers are already in the process of adding support to WordPress.com&#8217;s nearly 100 free themes.</p>\n\n<p>A <a href=\"https://en.forums.wordpress.com/search/gutenberg/\">quick search</a> of the WordPress.com support forums for Gutenberg provides some insight into what users think about the new editor. For example, <a href=\"https://en.forums.wordpress.com/topic/new-gutenberg-editing/\">this user provided feedback</a> on the use of so many icons without displaying their textual equivalent. </p>\n\n<p>For now, Gutenberg is opt-in but eventually will be opt-out. Once Gutenberg is made available to a wider audience, support documents and official blog posts will be published to inform users about the new editor. <br /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Sep 2018 23:24:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"WPTavern: Drupal Gutenberg Project Receives Enthusiastic Reception at Drupal Europe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83854\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://wptavern.com/drupal-gutenberg-project-receives-enthusiastic-reception-at-drupal-europe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6188:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/09/Screen-Shot-2018-09-14-at-2.59.59-PM.png?ssl=1\"><img /></a></p>\n<p>The <a href=\"https://wptavern.com/first-look-at-live-demo-of-the-gutenberg-content-editor-for-drupal-8\" rel=\"noopener noreferrer\" target=\"_blank\">Drupal Gutenberg</a> project is gaining momentum after Per André Rønsen and Marco Fernandes gave a presentation at Drupal Europe this week titled &#8220;Introducing the Gutenberg content editor for Drupal 8.&#8221; Rønsen and Fernandes are representatives of Frontkom, a digital services agency based in Norway that has ported WordPress&#8217; Gutenberg editor over to Drupal for use with client projects. They also created the <a href=\"https://drupalgutenberg.org/\" rel=\"noopener noreferrer\" target=\"_blank\">Drupal Gutenberg</a> project, which aims to bring this new publishing experience to Drupal core.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Building landing pages in <a href=\"https://twitter.com/hashtag/Drupal?src=hash&ref_src=twsrc{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}5Etfw\">#Drupal</a> has never been easier. Coming soon to a Drupal site near you! <a href=\"https://twitter.com/hashtag/drupaleurope?src=hash&ref_src=twsrc{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}5Etfw\">#drupaleurope</a> <a href=\"https://t.co/LLpH91AY9n\">pic.twitter.com/LLpH91AY9n</a></p>\n<p>&mdash; drupalgutenberg (@drupalgutenberg) <a href=\"https://twitter.com/drupalgutenberg/status/1040203765452820480?ref_src=twsrc{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}5Etfw\">September 13, 2018</a></p></blockquote>\n<p></p>\n<p>The Frontkom team gave a live demo of the Gutenberg module added to the page content type and showed how a few of the core blocks work. They concluded the presentation by hailing Gutenberg as an exciting new tool that will bring companies new business, make happier clients, and inspire more code reuse and sharing among developers.</p>\n<p>&#8220;The reception has been amazing,&#8221; Rønsen said. &#8220;A lot of different speakers have referred to Gutenberg both before and after the session. Bigger organizations and companies have expressed interest in implementation and contributing. I was told the session was one of the most well visited (after the keynotes) in the whole conference.&#8221;</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Gutenberg for Drupal looks good <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f4a5.png\" alt=\"💥\" class=\"wp-smiley\" /><img src=\"https://s.w.org/images/core/emoji/11/72x72/1f4a5.png\" alt=\"💥\" class=\"wp-smiley\" /> GoGo <a href=\"https://twitter.com/frontkom?ref_src=twsrc{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}5Etfw\">@frontkom</a> <a href=\"https://twitter.com/hashtag/DrupalEurope?src=hash&ref_src=twsrc{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}5Etfw\">#DrupalEurope</a> <a href=\"https://t.co/rV6dRT76Rk\">pic.twitter.com/rV6dRT76Rk</a></p>\n<p>&mdash; Daniel Andersson (@moppedanne) <a href=\"https://twitter.com/moppedanne/status/1039852251173543936?ref_src=twsrc{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}5Etfw\">September 12, 2018</a></p></blockquote>\n<p></p>\n<p>Overall, the Drupal community gave the Gutenberg editor a positive reception. However, Rønsen said he received feedback from some who are concerned about how it stores data. He said the general consensus was that &#8220;the UI is awesome,&#8221; but that the Drupal Gutenberg project would need to make sure data is stored in way that is as structured and portable as possible.</p>\n<p>&#8220;Some developers are skeptical about storing too much data unstructured like Gutenberg does,&#8221; Rønsen said. &#8220;This also means we might integrate Gutenberg closer to some key Drupal modules used for structured page building today. Gutenberg can serve as a UI for embedding existing structured content, and that is something we are looking into.&#8221;</p>\n<p>Rønsen said the next steps are centered around getting a stable release that will handle the core Gutenberg blocks and the core D8 blocks in a way that is future proof. In order to do this, they are waiting for the project to be merged into WordPress core.</p>\n<p>&#8220;We will delay a stable release until Gutenberg is in WP core,&#8221; Rønsen said. &#8220;Things are moving very fast still with Gutenberg – and that’s a good thing. As soon as we have a stable release, we will introduce tools we have built in top of Gutenberg for publishers. These will be available to WordPress, too.&#8221;</p>\n<h3>Gutenberg as the “editor for the open web” — not just for WordPress</h3>\n<p>One of the most exciting aspects of the Frontkom team&#8217;s presentation was the idea of sharing a project across publishing platforms.</p>\n<p>&#8220;It is key for us that Gutenberg stays decoupled from both CMSs as a library, and our hope is that Gutenberg core devs will catch onto the vision of Gutenberg as the &#8216;editor for the open web&#8217; — not just for WordPress,&#8221; Rønsen said.</p>\n<p>&#8220;Drupal core developers are however planning a React-based revamp of the Drupal admin UI, too. It will take at least two years to release it, and even then, I’m of the opinion that the content edit UI and page building features should be done last, and rather leave room for third party solutions like Gutenberg. This is an open question, but at least the key decisions makers for the new UI will consider how Gutenberg works and learn from it.&#8221;</p>\n<p>Drupal decision makers are also taking interest in Gutenberg and seem open to considering it as viable option for improving the CMS&#8217;s editing experience.</p>\n<p>&#8220;When the Drupal project owner was asked directly in a Q&amp;A what he thought about solutions like Gutenberg coming into Drupal, he said he liked it, and that it’s a good thing for Drupal,&#8221; Rønsen said. &#8220;Dries is very open minded and not afraid of the concept of &#8216;Proudly built elsewhere.\'&#8221;</p>\n<p>Rønsen and Fernandes have <a href=\"https://docs.google.com/presentation/d/1Rm1tiXR9sAVqasT8L8SZCg1LBVuTTuG3otNj_3Sj2r8/edit#slide=id.g321e3b1fbe_0_57\" rel=\"noopener noreferrer\" target=\"_blank\">published the slides</a> for those who want to view them, although most of the session was devoted to the live demo. The official recording has not yet been posted but should be available shortly.</p>\n<p>Update: The official recording has been published:</p>\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Sep 2018 22:31:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"BuddyPress: BuddyPress 3.2.0 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=276415\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://buddypress.org/2018/09/buddypress-3-2-0-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:463:\"<p>BuddyPress 3.2.0 is now available. This is a maintenance release that fixes 25 bugs and is a recommended upgrade for all BuddyPress installations.</p>\n<p>Update to BuddyPress 3.2.0 today in your WordPress Dashboard, or by <a href=\"https://wordpress.org/plugins/buddypress/\">downloading from the wordpress.org plugin repository</a>. For details on the changes, read the <a href=\"https://codex.buddypress.org/releases/version-3-2-0/\">3.2.0 release notes</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Sep 2018 15:14:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Paul Gibbs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: WPWeekly Episode 330 – WPShout, Community, and Burnout\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=83932&preview=true&preview_id=83932\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wptavern.com/wpweekly-episode-330-wpshout-community-and-burnout\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2001:\"<p>In this episode, <a href=\"http://jjj.me\">John James Jacoby</a> and I are joined by Fred Meyer, David Hayes, and Alex Denning of <a href=\"https://wpshout.com/\">WPShout</a> to learn about <a href=\"https://wpshout.com/announcing-pro-community/\">WPShout&#8217;s Pro Community</a>. This community aims to bring people together to learn from each other and provide one-to-one mentorship opportunities with David and Fred.</p>\n<p>Later in the show, John and I discuss why it&#8217;s a matter of when and not if, Dark Mode will be added to WordPress. We round out the show by discussing burnout and some other personal things.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"https://wptavern.com/dark-mode-is-possibly-coming-to-a-wordpress-dashboard-near-you\">Dark Mode is Possibly Coming to a WordPress Dashboard Near You</a></p>\n<p><a href=\"https://wptavern.com/wordpress-coding-standards-1-1-0-released\">WordPress Coding Standards 1.1.0 Released</a></p>\n<p><a href=\"https://wptavern.com/meetup-group-organizers-can-now-earn-a-wordpress-org-user-profile-badge\">Meetup Group Organizers Can Now Earn A WordPress.org User Profile Badge</a></p>\n<p><a href=\"https://wptavern.com/marcel-bootsman-is-walking-700km-to-wordcamp-europe-to-raise-funds-for-donatewc\">Marcel Bootsman is Walking 700km to WordCamp Europe to Raise Funds for DonateWC</a></p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, September 26th 3:00 P.M. Eastern</p>\n<p>Subscribe to <a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\">WordPress Weekly via Itunes</a></p>\n<p>Subscribe to <a href=\"https://www.wptavern.com/feed/podcast\">WordPress Weekly via RSS</a></p>\n<p>Subscribe to <a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\">WordPress Weekly via Stitcher Radio</a></p>\n<p>Subscribe to <a href=\"https://play.google.com/music/listen?u=0#/ps/Ir3keivkvwwh24xy7qiymurwpbe\">WordPress Weekly via Google Play</a></p>\n<p><strong>Listen To Episode #330:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Sep 2018 22:24:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"WPTavern: WordPress 4.9.9 Release Focus Items Include Site Health Project and Gutenberg Preparation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83892\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"https://wptavern.com/wordpress-4-9-9-release-focus-items-include-site-health-project-and-gutenberg-preparation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2819:\"<p>The WordPress 4.9.9 release leads published a <a href=\"https://make.wordpress.org/core/2018/09/12/wordpress-4-9-9-minor-release-roadmap/\" rel=\"noopener noreferrer\" target=\"_blank\">roadmap for the release</a> this week. The minor release will be led by Anthony Burchell and Alain Schlesser. It is targeted for November 5 with the first beta arriving near the end of October.</p>\n<p>The leads identified four key focus areas for the upcoming release: accessibility, internationalization, the Site Health Project, and Gutenberg preparation. The internationalization focus is aimed at improving translations and RTL support, as well as ensuring that date/time values work. The roadmap doesn&#8217;t identify any specific accessibility items but Burchell said the leads see lots of ways they can &#8220;drastically improve the experience for a lot of people with minimal effort.&#8221;</p>\n<p>Contributors to the Site Health Project, previously known by the &#8220;Servehappy&#8221; code name, will be working on resolving issues that will allow users to stay on WordPress 4.9.9 while they prepare for 5.0 and still have access to the important information about how to update their PHP versions.</p>\n<p>&#8220;It will be crucial to get the Servehappy components included: WSOD protection, update dashboard notice, plugin version requirements,&#8221; Burchell said. &#8220;The reason for this focus is because, when 5.0 ships, users who decide not to upgrade will be on 4.9.9 for a potentially extended time period. If we don’t have these Servehappy components included in 4.9.9, getting rid of old PHP versions will only happen after 5.0.&#8221;</p>\n<p>Another major part of WordPress 4.9.9 will be landing items that lay the groundwork for anything necessary for Gutenberg&#8217;s merge into 5.0. Two items identified include <a href=\"https://core.trac.wordpress.org/ticket/44758\" rel=\"noopener noreferrer\" target=\"_blank\">user locale support in REST API endpoints</a> and <a href=\"https://core.trac.wordpress.org/ticket/44862\" rel=\"noopener noreferrer\" target=\"_blank\">endpoints to lock/unlock and release posts</a>.</p>\n<p>With an unusually quick turnaround, WordPress 5.0 could arrive before the end of 2018. Development will kick off in mid-November, one week ahead of the U.S. Thanksgiving holiday.</p>\n<p><strong>UPDATE 9/13/2018 &#8211; 8:13PM:</strong> The wording on the roadmap document has been updated to more accurately reflect the intentions of contributors regarding the work outlined for the Site Health Project. The roadmap now reads:</p>\n<p><em>&#8220;We will investigate the work remaining for the Servehappy project and determine how to get it in people’s hands as soon as possible. WSOD protection, update dashboard notice, plugin version requirements are the hot items pending.&#8221;</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Sep 2018 17:58:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"HeroPress: Diversity of Thought\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://heropress.com/?p=2623\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"https://heropress.com/diversity-of-thought/#utm_source=rss&utm_medium=rss&utm_campaign=diversity-of-thought\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3237:\"<img width=\"960\" height=\"480\" src=\"https://s20094.pcdn.co/wp-content/uploads/2018/09/092017-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: I became completely inspired by the mission of WordPress. I had become a part of something bigger than myself.\" /><p>About a year ago, Christie Chirinos wrote the essay &#8220;<a href=\"https://heropress.com/essays/what-i-do-does-not-define-who-i-am/\">What I Do Does Not Define Who I Am</a>&#8220;. It felt like a big deal at the time, and it was, but like most big deals, it slowly faded from memory. That&#8217;s one of the reasons I do these replays, for the benefit of my own memory as much as anything else.</p>\n<p>As I&#8217;ve mentioned, part of the goal of HeroPress is to speak to those with less privilege and show how WordPress can help overcome that. That message shouldn&#8217;t come from me, a white American male. I simply don&#8217;t have the experience. I can read about it, but I&#8217;ll never actually have the experiences.</p>\n<p>The story really needs to come from someone with experience. Christie has some of that experience, and she does a wonderful job talking about how WordPress helped a little bit. I hope her story helps.</p>\n<blockquote class=\"wp-embedded-content\"><p><a href=\"https://heropress.com/essays/what-i-do-does-not-define-who-i-am/\">What I Do Does Not Define Who I Am</a></p></blockquote>\n<p></p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: Diversity of Thought\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=Diversity{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}20of{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}20Thought&via=heropress&url=https{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}3A{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2F{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fheropress.com{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fdiversity-of-thought{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: Diversity of Thought\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}3A{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2F{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fheropress.com{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fdiversity-of-thought{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}3A{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2F{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fheropress.com{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fdiversity-of-thought{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2F&title=Diversity+of+Thought\" rel=\"nofollow\" target=\"_blank\" title=\"Share: Diversity of Thought\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/diversity-of-thought/&media=https://heropress.com/wp-content/uploads/2018/09/092017-150x150.jpg&description=Diversity of Thought\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: Diversity of Thought\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/diversity-of-thought/\" title=\"Diversity of Thought\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/diversity-of-thought/\">Diversity of Thought</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Sep 2018 16:21:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"WPTavern: Official WooCommerce Android App Now in Beta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83859\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wptavern.com/official-woocommerce-android-app-now-in-beta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3827:\"<p>The first official <a href=\"https://woocommerce.com/mobile/\" rel=\"noopener noreferrer\" target=\"_blank\">WooCommerce Android app</a> is now in open beta. The companion mobile app allows users to manage their WooCommerce stores on the go. Store owners who want to test the unreleased version of the mobile app can <a href=\"https://play.google.com/apps/testing/com.woocommerce.android\" rel=\"noopener noreferrer\" target=\"_blank\">sign up with the Google Play Store</a>. The WooCommerce app <a href=\"https://woocommercehalo.wordpress.com/faq/\" rel=\"noopener noreferrer\" target=\"_blank\">requires Jetpack</a> to connect stores to the app.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/09/Manage-Orders@2x.jpg?ssl=1\"><img /></a></p>\n<p>The beta introduces a basic set of features for managing orders, viewing store stats, and receiving sales notifications, including the following:</p>\n<ul>\n<li>Check basic orders and revenue statistics with time period selection.</li>\n<li>View orders list in chronological order, with status and total value.</li>\n<li>Review individual orders with all the standard details, and contact customers.</li>\n<li>Perform basic order fulfillment.</li>\n<li>Get notifications about orders and reviews, and the ability to moderate them.</li>\n<li>View a list of the top-selling products on your store.</li>\n</ul>\n<p>The app&#8217;s real-time order alerts even include an optional &#8220;cha-ching&#8221; sounds for new orders.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/09/Push-Notifications@2x.jpg?ssl=1\"><img /></a></p>\n<p>Over the past few years, the WooCommerce community has demonstrated a demand for mobile apps on both platforms. A <a href=\"http://ideas.woocommerce.com/forums/133476-woocommerce/suggestions/6172593-android-equivalent-of-woocommerce-ios-app\" rel=\"noopener noreferrer\" target=\"_blank\">suggestion for an Android app</a> received 533 upvotes on the WooCommerce ideas board. There is also a motley assortment of unofficial WooCommerce store management apps available on the Google Play Store. Some of the more popular ones include <a href=\"https://play.google.com/store/apps/details?id=com.woostore.wooforce\" rel=\"noopener noreferrer\" target=\"_blank\">StorePep WooCommerce App</a>, <a href=\"https://play.google.com/store/apps/details?id=com.pinta.woocommerce.woocommercemobileadmin\" rel=\"noopener noreferrer\" target=\"_blank\">WooCommerce Mobile Admin</a>, <a href=\"https://play.google.com/store/apps/details?id=com.mstoreapp.wooadmin03\" rel=\"noopener noreferrer\" target=\"_blank\">Admin app for WooCommerce</a>, and <a href=\"https://play.google.com/store/apps/details?id=com.lxrmarketplace.woocommerce\" rel=\"noopener noreferrer\" target=\"_blank\">Dashly &#8211; WooCommerce Dashboard</a>.</p>\n<p>None of the third-party mobile apps seem to be very highly rated, nor are they consistent with the WooCommerce branding. A cursory glance at the reviews for these apps shows that most of them are slow, buggy, and not very well supported. However, they have temporarily fulfilled a need in the absence of an official app from WooCommerce.</p>\n<p>Considering the options currently available, an official WooCommerce app will be a welcome addition to the tools available for store owners. An iOS app is also in the works. At the end of July, the WooCommerce development team put out a <a href=\"https://woocommercehalo.wordpress.com/2018/07/31/call-for-testing-first-ios-beta/\" rel=\"noopener noreferrer\" target=\"_blank\">call for testing the first iOS Beta</a>. Anyone interested to test the apps can check out the <a href=\"https://woocommercehalo.wordpress.com\" rel=\"noopener noreferrer\" target=\"_blank\">Woo Halo</a> site and <a href=\"http://eepurl.com/dv-oo1\" rel=\"noopener noreferrer\" target=\"_blank\">register</a> to be part of the testing group.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 13 Sep 2018 16:19:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"Post Status: WordPress and Blockchain\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=47409\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://poststatus.com/wordpress-and-blockchain/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5235:\"<p>WordPress is one of the driving forces and great success stories of the open web to date. As an open source platform, it&#8217;s become a dominant CMS used by 30{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8} of the web to publish content — on websites large and small.</p>\n<p>WordPress has grown up in an era of evolving challenges: ushering in web standards, adapting for publishing and viewing on all device sizes; building for accessibility by all; establishing its place in the era of expansive and centralized social media platforms; and more.</p>\n<p>Today, we’re faced with a new generation of technologies coming down the pipe, ready to disrupt the current ecosystem. These technologies include blockchain, artificial intelligence, augmented reality, the internet of things, and more I&#8217;m sure. It’s the first of these that is the focus of this post and the following conversation.</p>\n<p>I was approached by David Lockie of <a href=\"https://pragmatic.agency/\">Pragmatic</a> to discuss how WordPress and blockchain technology may fit together, and how they may not. David and I have both been interested in the cryptocurrency and blockchain space over the past couple of years, and have over time encountered a lot of projects that aim to disrupt or enhance various elements of the web: from DNS to CMS.</p>\n<p>David gathered a group of people for an initial online, open, honest conversation about how WordPress could be impacted, disrupted or take advantage of distributed ledger and blockchain technologies.</p>\n<p>Examples include:</p>\n<ul>\n<li>Blockchain platforms impacting people’s choice to use WordPress e.g. <a href=\"https://steemit.com/\">Steemit</a></li>\n<li>Blockchain projects impacting people already using WordPress e.g. <a href=\"https://www.basicattentiontoken.org/\">Basic Attention Token</a> or <a href=\"https://www.po.et/\">Po.et</a>, <a href=\"https://vip.wordpress.com/2018/07/11/client-spotlight-civil/\">Civil</a></li>\n<li>Cryptocurrencies’ impact on eCommerce and the wider ecosystem, e.g. the Coinbase Commerce merchant gateway</li>\n<li>What we can learn from blockchain projects’ governance systems and lessons learned</li>\n<li>Ideas for improving security, integrations, etc</li>\n<li>Various identity-based projects</li>\n<li>New environments which may be used to run WordPress, such as decentralized web technologies e.g. <a href=\"https://substratum.net/\">Substratum </a> or <a href=\"https://www.maidsafe.net/\">MaidSafe</a>.</li>\n<li>Impact on the talent pool for WordPress professionals</li>\n<li>General <a href=\"https://speakerdeck.com/dcent/wordpress-and-blockchain-threats-and-opportunities\">threats and opportunities</a></li>\n<li>Discussion of anything new, interesting and relevant in the blockchain/cryptocurrency space</li>\n<li>All of the above as it relates to open source and the web generally, outside of WordPress</li>\n</ul>\n<p>Our aim for the initial conversation, as well as future conversations, <strong>is not</strong> to advocate specifically for any existing project or to necessarily endorse blockchain as appropriate for WordPress to somehow integrate in any way. It&#8217;s to explore what&#8217;s out there now, how it could impact WordPress today and in the future, and down the road perhaps how WordPress may take advantage of potential opportunities. We are approaching this like a discovery phase — not to get overly excited, but to be informed. And we welcome participants in this conversation.</p>\n<p>This first conversation included the following participants:</p>\n<ul>\n<li>David Lockie, <a href=\"https://pragmatic.agency/\">Pragmatic</a></li>\n<li>Brian Krogsgard, Post Status</li>\n<li>Bradford Campeau-Laurion, <a href=\"https://alley.co/\">Alley Interactive</a></li>\n<li>Zac Gordon, <a href=\"https://zacgordon.com/\">Deeply</a></li>\n<li>Christie Chirinos, <a href=\"https://calderalabs.org/\">Caldera Labs</a></li>\n<li>Josh Pollock, <a href=\"https://calderalabs.org/\">Caldera Labs</a></li>\n<li>Brad Williams, <a href=\"https://webdevstudios.com/\">WebDevStudios</a></li>\n</ul>\n<p>I attempted to reiterate it in the call, but I believe it&#8217;s important to address this topic with a skeptic&#8217;s hat on. By no means do any of us think that it&#8217;s a great idea to just go head first in trying to integrate blockchain technology to WordPress. The jury is still very much out in terms of where, how, and even if blockchain brings significant advantages to web applications.</p>\n<p></p>\n<p>If you are interested in future discussions, we welcome you! There is currently a channel (#blockchain) in Post Status Slack where people can discuss, and we&#8217;ll also announce future video-conference discussions. We may make a more independent place to discuss, blog, etc, in the future depending on how these early conversations go.</p>\n<p>We don&#8217;t know exactly where this conversation will go. It may fizzle out, or it could evolve into a much broader community effort. The first thing to do, if you are interested to continue this conversation, is just follow along with future conversations, which will be posted here. If you would like to be on the next video call, please <a href=\"https://pragmatic.agency/contact/\">contact David</a> or <a href=\"https://poststatus.com/contact\">me</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Sep 2018 22:58:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"WPTavern: WordCamp Wilmington Cancelled Due to Hurricane Florence\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83851\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://wptavern.com/wordcamp-wilmington-cancelled-due-to-hurricane-florence\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2572:\"<p>Hurricane Florence <a href=\"https://www.nhc.noaa.gov/graphics_at1.shtml?cone#contents\">is forecast</a> to make landfall as a major hurricane near Wilmington, North Carolina bringing potentially catastrophic flooding and strong winds to the region. </p>\n\n<img />Hurricane Florence Forecast Track From the National Hurricane Center\n\n<p>Because of the hurricane, <a href=\"https://2018.wilmington.wordcamp.org\">WordCamp Wilmington</a> which was scheduled to take place September 22nd and 23rd <a href=\"https://2018.wilmington.wordcamp.org/2018/09/11/canceled-2018-wordcamp-wilmington/\">has been cancelled</a>. </p>\n\n<p>&#8220;We wish all of our WordCamp Wilmington enthusiasts a minimum of impact from Hurricane Florence,&#8221; Helen Rittersporn, one of the event&#8217;s organizers said. <br /></p>\n\n<p>&#8220;On behalf of my fellow Organizers for 2018 WordCamp Wilmington, we are looking forward to seeing everyone in 2019!&#8221;</p>\n\n<h2>Safety of Attendees, Speakers, and Sponsors Takes Priority<br /></h2>\n\n<p>Peter La Fond, one of the event&#8217;s lead organizers, says the decision to cancel the event has been mentally taxing to him and the team.</p>\n\n<p>&#8220;From the beginning, the decision making was really hard,&#8221; he said. &#8220;How we made the decision about this was very fluid. The entire team has been texting back and forth every several hours on various decisions over many days.</p>\n\n<p>&#8220;We ended up having to set thresholds in advance for canceling.  Then on Monday morning, we started to get inquiries and cancellations of attendees, vendors and speakers so we had to make a call.&#8221; </p>\n\n<p>Although a lot hours were spent by volunteers to organize the event, speaker, attendee, and sponsor safety took priority. <br /></p>\n\n<p>&#8220;The organizing team is totally bummed about canceling the event considering the amount of effort we put into organizing it,&#8221; La Fond said. &#8220;However, we’re more concerned about the safety and security of our family and friends. Especially those who chose to stay.&#8221;</p>\n\n<p>Those who purchased tickets are eligible for a refund. But due to evacuations and the length of time the storm is expected wreak havoc in the area, organizers will not be able to fulfill refund requests until after the storm has passed. <br /></p>\n\n<p>This is the second time a tropical weather system has postponed or cancelled a WordCamp in the US. In 2016, <a href=\"https://wptavern.com/wordcamp-orlando-cancelled-due-to-hurricane\">WordCamp Orlando was postponed</a> due to Hurricane Matthew. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Sep 2018 22:05:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"WPTavern: MetaSlider Plugin Adds Gutenberg Block for Inserting Sliders\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83865\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://wptavern.com/metaslider-plugin-adds-gutenberg-block-for-inserting-sliders\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4203:\"<p>If you <a href=\"https://wordpress.org/plugins/search/slider/\" rel=\"noopener noreferrer\" target=\"_blank\">search for &#8220;slider&#8221;</a> in the WordPress plugins directory, <a href=\"https://wordpress.org/plugins/ml-slider/\" rel=\"noopener noreferrer\" target=\"_blank\">MetaSlider</a> is the first result that comes up. The plugin, created by the team at <a href=\"https://updraftplus.com\" rel=\"noopener noreferrer\" target=\"_blank\">UpdraftPlus</a>, is active on more than 900,000 sites, more than any other free slider plugin, and averages a 4.7-star review. It includes four different types of sliders: Flex 2, Nivo Slider, Responsive Slides, and Coin Slider.</p>\n<p>An update released today introduces Gutenberg support with a block for inserting sliders. Users can access their sliders via the block insertion tool.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/09/metaslider-gutenberg-block.png?ssl=1\"><img /></a></p>\n<p>Clicking on the MetaSlider block allows users to select from among the sliders that they have already created in the admin.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/09/Screen-Shot-2018-09-12-at-12.46.10-PM.png?ssl=1\"><img /></a></p>\n<p>After the user selects a slider, a preview will appear instantly in the Gutenberg editor.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/09/metaslider-in-gutenberg.jpg?ssl=1\"><img /></a></p>\n<p>Previously, the process of inserting a slider into content involved copying and pasting a shortcode. Joe Miles, director of Business Strategy at UpdraftPlus, said the team sees the Gutenberg editor as a major improvement especially for those who are new to WordPress.</p>\n<p>&#8220;I think Gutenberg makes it much easier for novices to web design to make changes and insert sliders,&#8221; Miles said. &#8220;I know people who&#8217;d be comfortable using a Gutenberg block but not comfortable using a shortcode as it looks scary.&#8221;</p>\n<p>Miles said the company is currently working on adding the ability for users to create and edit sliders within Gutenberg and hope to include it in the plugin before WordPress 5.0 lands. The UpdraftPlus team includes 13 developers who are devoted to the company&#8217;s WP-Optimize and MetaSlider products. Miles said adapting to Gutenberg was fairly simple relative to some of the other projects the team is working on.</p>\n<p>UpdraftPlus plans to continue to maintain and improve the shortcode-based slider insertion method, as demonstrated in the changelog. Users who opt to stick with the Classic Editor will still be able to keep their same workflow. Meanwhile, the product&#8217;s development team will be working on integrating all of the pro version&#8217;s front-end features with Gutenberg.</p>\n<p>In addition to Gutenberg support, the team is also going to be <a href=\"https://updraftplus.com/metasliders-bringing-out-new-slider-themes-and-theyre-completely-free/\" rel=\"noopener noreferrer\" target=\"_blank\">adding the concept of themes to sliders</a> so users can build a slider and change its theme in a couple of clicks. They plan to release free and commercial themes and all will be built to be compatible with Gutenberg.</p>\n<p><a href=\"https://wordpress.org/plugins/smart-slider-3/\" rel=\"noopener noreferrer\" target=\"_blank\">Smart Slider 3</a>, MetaSlider&#8217;s next closest competitor with 300,000 installs, is <a href=\"https://smartslider3.com/blog/gutenberg-and-smart-slider-3-how-to-add-sliders-to-wordpress/\" rel=\"noopener noreferrer\" target=\"_blank\">also compatible with Gutenberg</a> with a similar workflow for inserting sliders. Both slider plugins are not yet capable of providing the slider creation and editing process inside the Gutenberg interface but the capabilities should evolve as WordPress gets closer to the 5.0 release.</p>\n<p>&#8220;I personally love the idea of Gutenberg since Matt Mullenweg announced it at WordCamp EU 2017,&#8221; Miles said. &#8220;I understand why experienced developers don&#8217;t want the change, but too many people are going for inferior website solutions like WIX because they&#8217;re used to WYSIWYG. So adapting MetaSlider was a no-brainer.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Sep 2018 20:59:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"WPTavern: Marcel Bootsman is Walking 700km to WordCamp Europe to Raise Funds for DonateWC\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83797\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"https://wptavern.com/marcel-bootsman-is-walking-700km-to-wordcamp-europe-to-raise-funds-for-donatewc\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3272:\"<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/09/Screen-Shot-2018-09-11-at-3.37.12-PM.png?ssl=1\"><img /></a></p>\n<p>In May 2019, <a href=\"https://twitter.com/mbootsman\" rel=\"noopener noreferrer\" target=\"_blank\">Marcel Bootsman</a> will be lacing up a pair of hiking boots and walking 700km (435 miles) from his home in Rotterdam to WordCamp Europe in Berlin. Bootsman, a WordPress consultant and WordCamp organizer, is walking to raise funds and awareness for the <a href=\"https://donatewc.org/\" rel=\"noopener noreferrer\" target=\"_blank\">DonateWC</a> organization.</p>\n<p>The DonateWC initiative provides a global fund for helping people in need of financial assistance to attend a big WordCamp. Donations go towards individually-tailored sponsorships that help selected attendees purchase a WordCamp ticket, door-to-door transportation, food and drink, and internet access.</p>\n<p>&#8220;Imagine for a moment that you are not backed by a company that will pay for you to go to a community event,&#8221; DonateWC founder Ines van Essen said. &#8220;You work hard at being a valuable community member but are never able to actually meet the others in your team. This means you are less likely to get a job, less likely to get recognized as a worthwhile member, you’re unlikely to be at the front-end of changes that impact your work significantly.&#8221;</p>\n<p>DonateWC aims to keep the larger WordCamps from being unintentionally exclusive of those with lesser financial means. Bootsman said he believes in the organization because it is community-driven and enables the greater WordPress community to do something for their fellow community members.</p>\n<p>So far, Bootsman&#8217;s walking journey has raised €116.57. He set up a <a href=\"https://walktowc.eu\" rel=\"noopener noreferrer\" target=\"_blank\">walktowc.eu</a> website to track his progress and the <a href=\"https://walktowc.eu/donate/\" rel=\"noopener noreferrer\" target=\"_blank\">donation page</a> displays a live update of donated funds. Contributors have the option to designate their donations for DonateWC or for Bootsman&#8217;s personal needs on the trek. He plans to deliver all of the funds raised for the organization when he arrives in Berlin. In the coming weeks he will also open up sponsor packages to better motivate companies to donate.</p>\n<p>Bootsman does not plan to work during his trek. He will be on the road for approximately 30 days and plans to walk 30km per day. He is traveling light with just a backpack and is looking for places where he can sleep along the way. Bootsman will update the <a href=\"https://walktowc.eu/route/\" rel=\"noopener noreferrer\" target=\"_blank\">Route page</a> on his website with the places where people volunteer a bed for him to spend the night.</p>\n<p>If you want to keep track of his progress, follow the hashtag <a href=\"https://twitter.com/hashtag/walktowceu?src=hash\" rel=\"noopener noreferrer\" target=\"_blank\">#walktwceu</a> on Twitter. Bootsman has published his first vlog about his training sessions (see video below) where you can hear in his own words why his making the long journey on foot. When I asked him if he&#8217;ll be walking home after WordCamp Europe, he said, &#8220;You&#8217;re kidding, right?&#8221;</p>\n<p></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Sep 2018 22:25:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Matt: WP Dev on Chromebook\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=48342\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://ma.tt/2018/09/wp-dev-on-chromebook/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:256:\"<p>Dan Walmsley has an interesting <a href=\"https://developer.wordpress.com/2018/09/11/developing-wordpress-jetpack-and-calypso-on-chromeos/\">walkthrough on getting set up for WordPress and Calypso development on the new Linux mode on a Chromebook</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Sep 2018 18:29:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WPTavern: Hemingway Theme Adds Gutenberg Support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83790\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wptavern.com/hemingway-theme-adds-gutenberg-support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4178:\"<p>Anders Norén has <a href=\"http://www.andersnoren.se/hemingway-meet-gutenberg/\" rel=\"noopener noreferrer\" target=\"_blank\">added Gutenberg support</a> to his popular <a href=\"https://wordpress.org/themes/hemingway/\" rel=\"noopener noreferrer\" target=\"_blank\">Hemingway</a> theme in the latest update, version 1.66. The theme has a simple, timeless design that appeals to both bloggers and business owners alike. It is active on more than 30,000 websites and some of those site administrators are using Gutenberg.</p>\n<p>What does Gutenberg support look like for Hemingway? Norén styled the editor to match the front-end design, with the same colors and fonts. He also added support for specific Gutenberg blocks, such as cover images, full-width elements, and pull quotes.</p>\n<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/09/hemingway-gutenberg-e1536683158337.jpg?ssl=1\"><img /></a>image credit: Anders Norén\n<p>Norén said he knew since Gutenberg was announced that he would need to add support to all 17 of his themes in a substantial update at some point but had put it off because developing for the new editor felt &#8220;like aiming for a moving target.&#8221;</p>\n<p>&#8220;I don’t think it was any single thing that made me realize that I needed to get going with Gutenberg, but rather that the Gutenberg volume knob in the community has been turned up at a steady pace,&#8221; Norén said. &#8220;After the &#8216;Try Gutenberg&#8217; prompt in 4.9.8, I also started to receive a lot more support requests regarding Gutenberg. When regular WordPress users – not developers – started to ask when they can expect Gutenberg support in my themes, I knew that I couldn’t push it ahead of me much further.&#8221;</p>\n<p>Hemingway is the first of his themes to support the new editor and Norén is aiming to have his entire collection Gutenberg-ready by the time WordPress 5.0 is released. (This does not include the <a href=\"https://wordpress.com/theme/hemingway-rewritten\" rel=\"noopener noreferrer\" target=\"_blank\">Hemingway Rewritten</a> version, which was created by Automattic and is available on WordPress.com.)</p>\n<p>Norén sees the new editor as a significant improvement over the current editor and said he thinks it is the right way forward for WordPress.</p>\n<p>&#8220;It’s always easy to speculate about the road not travelled, but the Visual Editor needs replacement, and Gutenberg will be a good replacement for it,&#8221; he said. &#8220;It’s better at everything the old editor can do (except editing raw HTML, perhaps), and it also brings with it new possibilities for WordPress developers and users. There are a lot of issues in Gutenberg still to be worked out, but when they are, I think Gutenberg will be a big step forward for the WordPress community.&#8221;</p>\n<p>Norén said his chief concern is not about the editor itself but about how WordPress will handle the transition period for users, especially for those who would benefit from continuing on with the Classic Editor.</p>\n<p>&#8220;I hope that the upgrade notice for 5.0 will be accompanied by clear messaging around the changes included in 5.0, along with the option to install the Classic Editor in Gutenberg&#8217;s stead,&#8221; Norén said. &#8220;Similar to the &#8216;Try Gutenberg&#8217; prompt, but presented more clearly as an either-or option before the user actually updates to 5.0. It was encouraging to see Matt Mullenweg say that the Classic Editor will be maintained for many years to come.&#8221;</p>\n<p>Norén&#8217;s 17 free WordPress.org-hosted themes have an estimated 100,000 active installs. Those using his products can be confident that the author behind the themes has Gutenberg-support among his immediate priorities for updates. Users who opt to move forward using the Classic Editor should not notice a difference in how the themes work.</p>\n<p>&#8220;I hope that Gutenberg is received with excitement and widespread support when 5.0 is finally released,&#8221; Noren said. &#8220;I also hope that the WordPress team does whatever it can to make sure that end-users don’t feel ambushed by the new editing experience.&#8221;</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Sep 2018 18:04:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"WPTavern: Meetup Group Organizers Can Now Earn A WordPress.org User Profile Badge\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83806\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://wptavern.com/meetup-group-organizers-can-now-earn-a-wordpress-org-user-profile-badge\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2241:\"<p>The WordPress Community team <a href=\"https://make.wordpress.org/community/2018/09/10/new-tool-for-community-deputies-meetup-tracker/\">has unveiled</a> a new tool called Meetup Tracker. This tool replaces the Meetup Status Document and will enable Global Community Team members to more easily track all Meetup.com groups.</p>\n\n<p>There&#8217;s also a <a href=\"https://central.wordcamp.org/meetup-organizer-application/\">new application form</a> available for organizers looking to join the <a href=\"https://make.wordpress.org/community/handbook/community-deputy/meetup-program-basics/\">WordPress Meetup Chapter Program</a>. Groups that are part of the program have their Meetup.com fees paid for by WordPress Community Support PBC.<br /></p>\n\n<p>Thanks to the new system that is hosted on the backend of <a href=\"https://central.wordcamp.org/\">WordCamp Central</a>, the community team is able to award badges to meetup organizers which will be displayed on their WordPress.org user profiles.</p>\n\n<div class=\"wp-block-image\"><img />Example of Contribution Badges Displayed on WordPress.org User Profiles</div>\n\n<p>In order to receive a badge and to fill the new system with updated information, organizers with meetups that are part of the chapter program are required to add the following information to this <a href=\"https://docs.google.com/spreadsheets/d/1LYnNDDpBQC7przZyufG4W5mdO67BcTTy_yz8eHY24lc/edit#gid=0\">Google Document</a>.</p>\n\n<ul><li> <strong>WordPress.org username for main contact</strong> <br /></li><li><strong>WordPress.org usernames of all organizers</strong> <br /></li><li><strong>Whether or not the contact’s WordPress.org email address is still valid</strong> <br /></li></ul>\n\n<p>Badges were added to WordPress.org <a href=\"https://wptavern.com/wordpress-org-profile-redesign-is-live\">user profiles as part of a redesign in 2014</a> and are a quick way to gauge a person&#8217;s activity and or interests across the WordPress project. </p>\n\n<p>The meetup organizer&#8217;s badge design has yet to be determined. For more information or if you have questions, please leave a comment on the <a href=\"https://make.wordpress.org/community/2018/09/10/calling-all-meetup-group-orgnisers/\">announcement post</a>. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Sep 2018 02:52:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"WPTavern: WordPress Coding Standards 1.1.0 Released\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83804\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wptavern.com/wordpress-coding-standards-1-1-0-released\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:688:\"<p>The WordPress Coding Standards version 1.1.0 has <a href=\"https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/releases/tag/1.1.0\">been released</a> on GitHub. This release includes more stringent function call formatting checks which are <a href=\"https://make.wordpress.org/core/handbook/best-practices/coding-standards/php/#multiline-function-calls\">explained</a> in the handbook. There&#8217;s also stricter checks for overrides of WordPress global variables. </p>\n\n<p>To see a full list of what was changed, fixed, and added, check out the <a href=\"https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/releases/tag/1.1.0\">changelog</a>. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Sep 2018 01:16:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"Matt: Seth Godin on Customer Service\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=48340\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://ma.tt/2018/09/seth-godin-on-customer-service/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:236:\"<p>This morning <a href=\"https://seths.blog/2015/03/what-is-customer-service-for/\">I&#8217;m enjoying Seth Godin&#8217;s classic on Customer Service</a>. <cite>Hat tip: <a href=\"https://andrewspittle.com/\">Andrew Spittle</a>.</cite></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 10 Sep 2018 16:39:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"Matt: Responsibility of Technology\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=48337\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://ma.tt/2018/09/responsibility-of-technology/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:834:\"<p>There&#8217;s <a href=\"https://www.buzzfeednews.com/article/daveyalba/facebook-philippines-dutertes-drug-war\">fascinating and terrifying feature article about Facebook, Duterte, and the drug war in the Philippines</a>, written <a href=\"https://twitter.com/daveyalba/status/1036917302061608960\">by Davey Alba</a>. My first trip there was actually to Davao, and having been to the country several times and met so many bloggers there it&#8217;s hard to imagine what&#8217;s described. There are definitely echoes of <a href=\"https://www.wired.com/story/how-facebooks-rise-fueled-chaos-and-confusion-in-myanmar/\">the Wired feature on Facebook and ethnic cleansing in Myanmar</a>. Both are good reminders that as technologists the tools we create can be used and leveraged in ways we wouldn&#8217;t imagine in our worst nightmares.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 09 Sep 2018 17:46:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: Biratnagar, Nepal to Host Its First WordCamp – December 22, 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83719\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://wptavern.com/biratnagar-nepal-to-host-its-first-wordcamp-december-22-2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2614:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/09/wordcamp-biratnagar.png?ssl=1\"><img /></a></p>\n<p>Biratnagar, one of the oldest cities in Nepal, is gearing up to <a href=\"https://2018.biratnagar.wordcamp.org/\" rel=\"noopener noreferrer\" target=\"_blank\">host its first WordCamp</a> on December 22, 2018. The local community organized its first meetup in 2011 with 40 participants. Since that time the community has grown and recently hosted 250 members for <a href=\"http://wp.tecnepal.com/\" rel=\"noopener noreferrer\" target=\"_blank\">a two-day meetup</a> in January 2018.</p>\n<p>&#8220;WordPress Biratnagar has a remarkably large number of enthusiastic participants in local WordPress meetups, more than any other meetups in Nepal,&#8221; lead organizer Ganga Kafle said. Kafle is a developer and WordPress.org theme reviewer. He said his local community is full of energetic youth who are excited to make the WordCamp happen.</p>\n<p>&#8220;From an 8th grade student in a government school to a 56-year-old passionate retired army soldier, all are members of the WordPress Biratnagar community. This community is diverse, open, and has the ability to have fun together. They help each other out a lot, sharing tips and tricks, and solve problems together.&#8221;</p>\n<p>Kafle said the topics of most interest to the local community include WordPress SEO, blogging, and WordPress theme development, as the majority of community members are students, developers, freelancers, and designers. He expects the WordCamp will attract attendees from different cities inside Nepal and from nearby countries, including India, Bangladesh, Pakistan, and other South Asian countries. Sessions will be conducted in both English and Nepali.</p>\n<p>WordCamp Biratnagar will be the seventh WordCamp held in Nepal, following WordCamp Pokhara which is scheduled one month earlier on November 24. Pokhara is 11 hours away by car so the two WordPress communities are quite a distance away from each other. WordCamp Biratnagar is the last camp on the global WordCamp calendar for 2018.</p>\n<p>Kafle said he hopes the event will bring the Biratnagar WordPress community opportunities that will lead to more entrepreneurship and contribution to the greater tech community in the region. The event has <a href=\"https://2018.biratnagar.wordcamp.org/wordcamp-biratnagar-tickets/\" rel=\"noopener noreferrer\" target=\"_blank\">200 tickets available</a> and the capacity to expand if there is a greater demand. Early Bird Tickets are now on sale at Rs 1000. Once those are sold, Regular Tickets will be available for Rs 1500.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 08 Sep 2018 01:40:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"WPTavern: Dark Mode is Possibly Coming to a WordPress Dashboard Near You\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83660\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://wptavern.com/dark-mode-is-possibly-coming-to-a-wordpress-dashboard-near-you\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4514:\"<p>For the past year, <a href=\"https://profiles.wordpress.org/danieltj\">Daniel James</a> has been developing the <a href=\"https://wordpress.org/plugins/dark-mode/\">Dark Mode</a> plugin for WordPress. The plugin is actively installed on more than 1K sites. Dark Mode replaces the white and grey colors in the backend with darker colors that are easier on the eyes.</p>\n\n<div class=\"wp-block-image\"><img />Dark Mode for WordPress</div>\n\n<p>James has published <a href=\"https://make.wordpress.org/core/2018/08/30/merge-proposal-dark-mode/\">a proposal</a> to merge the plugin into core. There are three things to know about Dark Mode up front. It does not have a high contrast mode to meet accessibility needs, is not a new admin color scheme for the backend, and is not a tool that helps people with vision issues. </p>\n\n<p>By default, WordPress ships with eight admin color schemes. However, color schemes are only applied to the WordPress sidebar and Admin toolbar. Dark Mode is applied to the main content area of the dashboard. This gives users the ability to use Dark Mode and an Admin Color Scheme in tandem. </p>\n\n<img />Admin Color Schemes\n\n<p>Dark Mode is not compatible with Gutenberg but is compatible with TinyMCE. Because of the speed at which Gutenberg is being developed as a plugin, James decided that a merge proposal without Gutenberg support is the best way forward. Compatibility with Gutenberg will likely arrive once it is merged into core.</p>\n\n<p>Because Dark Mode affects the content area of the WordPress Dashboard, if it&#8217;s merged into core, plugins will need to support two different color schemes. </p>\n\n<p>There is no easy way for Dark Mode to support every plugin, especially when many of them use custom user interface elements. <a href=\"https://github.com/danieltj27/Dark-Mode/wiki/Help:-Plugin-Compatibility-Guide\">This guide</a> on the <a href=\"https://github.com/danieltj27/Dark-Mode\">plugin&#8217;s GitHub page</a> explains how developers can add support for Dark Mode.</p>\n\n<h2>Proposal Hits a Snag</h2>\n\n<p>Within the comments on the proposal, members of the core and accessibility teams weighed in. Gary Pendergast, a WordPress core developer, <a href=\"https://make.wordpress.org/core/2018/08/30/merge-proposal-dark-mode/#comment-33913\">outlined</a> a list of requirements from the <a href=\"https://make.wordpress.org/core/handbook/about/release-cycle/features-as-plugins/#feature-plugin-merge-criteria\">Core Handbook</a> that the plugin has yet to achieve. </p>\n\n<p>James <a href=\"https://make.wordpress.org/core/2018/08/30/merge-proposal-dark-mode/#comment-33928\">responded</a> by explaining the process of merging a feature plugin into core as outlined in the Core Handbook does not lend itself to all projects. </p>\n\n<p>&#8220;For example, weekly meetings, or kick-off posts etc,&#8221; James said. &#8220;I understand that Gutenberg is probably a top priority right now but it’d be great if I could have some help on what to do to push this forward. I think an introduction of Gutenberg <strong>and</strong> Dark Mode would be a great addition to shout about in 5.0.&#8221;</p>\n\n<h2>Some of the Benefits of Dark Mode</h2>\n\n<p>One of the obvious benefits is that Dark Mode is aesthetically pleasing, especially after sunset. Depending on the <a href=\"https://www.quora.com/Does-a-white-background-use-more-energy-on-an-LCD-than-if-it-was-set-to-black\">screen technology</a>, darker colors are more energy efficient. It&#8217;s also a mode that&#8217;s gaining in popularity. For example, earlier this year, <a href=\"https://developer.apple.com/videos/play/wwdc2018/210/\">Apple announced</a> Dark Mode will be available in macOS Mojave.<br /></p>\n\n<p>I find myself using Dark Mode on Reddit, the Twitter app on my iPhone, and now WordPress. I like to browse the web on my phone while laying in bed and my partner enjoys not seeing a bright screen shining in her direction.<br /></p>\n\n<p>Based on <a href=\"https://make.wordpress.org/core/2018/08/30/merge-proposal-dark-mode/#comment-33929\">comments made</a> to the proposal and on <a href=\"https://twitter.com/mikelikethebike/status/1035513986836570112\">social media</a>, there is a definitive interest in having a Dark Mode option in WordPress. Is Dark Mode something you&#8217;d like to see be part of core? Also, I&#8217;m curious as to which Admin Color scheme you use. Please vote in the poll below. </p>\n\nNote: There is a poll embedded within this post, please visit the site to participate in this post\'s poll.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 08 Sep 2018 00:14:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"WPTavern: The State of JavaScript 2018 Survey is Now Open\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83749\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wptavern.com/the-state-of-javascript-2018-survey-is-now-open\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3004:\"<p>The annual <a href=\"https://stateofjs.com/\" rel=\"noopener noreferrer\" target=\"_blank\">State of JavaScript 2018 Survey</a> is in its third year running and is now open for participants. <a href=\"http://sachagreif.com/\" rel=\"noopener noreferrer\" target=\"_blank\">Sacha Greif</a>, an Osaka-based web designer and developer, said he created the survey to get more data about recent trends after hearing all the online discussion about “JavaScript fatigue.”</p>\n<p>Last year&#8217;s survey had more than 20,000 participants, a 115{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8} increase over the previous year&#8217;s 9,300 responses. In the popular front-end frameworks category, React won out again as the framework with the greatest number of respondents indicating that they had used it and would use it again.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/09/Screen-Shot-2018-09-07-at-12.35.08-PM.png?ssl=1\"><img /></a></p>\n<p>The 2017 survey participants were asked to rate their happiness with the current state of front-end tools on a scale of 1-5. The results averaged a 3.8, so there is room in the front-end tools category for things to shift quite a bit over a year.</p>\n<p>The salary ranges data is particularly useful for job seekers or those new to JavaScript who are trying to decide what libraries to learn. Backbone and Ember commanded the highest salaries for participants, with Vue and Angular 2 coming in at the lower end.</p>\n<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/09/Screen-Shot-2018-09-07-at-12.53.47-PM.png?ssl=1\"><img /></a></p>\n<p>Check out the full <a href=\"https://2017.stateofjs.com/2017/introduction/\" rel=\"noopener noreferrer\" target=\"_blank\">2017 results</a> for more data on participants&#8217; opinions on state management tools, back-end frameworks, build tools, and more.</p>\n<p>&#8220;The main change this year is that we added some extra logic to the survey: if you mention having used a given library, we’ll ask a follow-up question to find out what you like (or disliked) about it,&#8221; Greif said in announcing the 2018 survey. &#8220;We’re hoping that this helps us get more granular data about why some technologies are popular.&#8221;</p>\n<p>The 2018 survey has also dropped the CSS libraries category this year, in favor of keeping it from getting too long. Greif hinted that CSS may get its own survey one day, but that section will no longer by included in the JavaScript survey.</p>\n<p>Greif is aiming to publish the results by mid-November and will also give a preview at the <a href=\"https://www.dotjs.io/\" rel=\"noopener noreferrer\" target=\"_blank\">Dot JS</a> conference in Paris on November 9th. Your participation in the 2018 survey will help it to more accurately present the trends in the JavaScript ecosystem and help other developers see which tools have the highest satisfaction ratings and best salaries. Visit <a href=\"https://stateofjs.com/\" rel=\"noopener noreferrer\" target=\"_blank\">stateofjs.com</a> to take the survey now.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 07 Sep 2018 19:07:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"WPTavern: Pootlepress Previews Upcoming Storefront Blocks Plugin for WooCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83538\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://wptavern.com/pootlepress-previews-upcoming-storefront-blocks-plugin-for-woocommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6098:\"<p>At the end of 2017, WooCommerce <a href=\"https://wptavern.com/woocommerce-explores-the-possibilities-and-challenges-for-e-commerce-in-the-gutenberg-era\">published some of their &#8220;Wootenberg experiments&#8221;</a>, one of the first previews of what e-commerce might look like in the Gutenberg era. Gutenberg&#8217;s handling of meta boxes has greatly evolved since that time and the <a href=\"https://wordpress.org/plugins/woo-gutenberg-products-block/\" rel=\"noopener noreferrer\" target=\"_blank\">WooCommerce Gutenberg Products Block</a> feature plugin is now active on more than 20,000 sites. The plugin provides a basic custom products area for featuring products.</p>\n<p>Pootlepress has expanded on this idea of offering a configurable product display and is currently previewing its upcoming <a href=\"https://www.pootlepress.com/storefront-blocks/\" rel=\"noopener noreferrer\" target=\"_blank\">Storefront Blocks</a> plugin, created specifically for use with the WooCommerce <a href=\"https://wordpress.org/themes/storefront/\" rel=\"noopener noreferrer\" target=\"_blank\">Storefront theme</a>. The plugin allows users to easily customize more advanced layouts for various product displays that can be used anywhere in their content.</p>\n<div class=\"embed-vimeo\"></div>\n<p>Storefront Blocks includes the following custom blocks:</p>\n<ul>\n<li>Product Masonry Grid block</li>\n<li>Category Masonry block</li>\n<li>Square Product Grid block</li>\n<li>Slider block</li>\n<li>WooCommerce default product</li>\n<li>Carousel block</li>\n</ul>\n<p>Storefront Blocks lets store owners easily customize font, colors, label positioning and alignment, grid gap, product grid rows, and columns. The blocks can be expanded to be full-width. They can also be transformed and reused. One example shown in the video above demonstrates converting a product grid into a slider.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/08/Screen-Shot-2018-09-05-at-4.04.37-PM.png?ssl=1\"><img /></a></p>\n<p>Check out the live frontend demo at <a href=\"https://storefrontblocks.com/\" rel=\"noopener noreferrer\" target=\"_blank\">storefrontblocks.com</a>.</p>\n<p>The team at Pootlepress was aiming to release the plugin in first week of September but have pushed it back to the week of the September 17th, due to issues caused by Gutenberg 3.7.</p>\n<blockquote class=\"twitter-tweet\">\n<p lang=\"en\" dir=\"ltr\">Gutenberg 3.7 dropped today and broke some stuff. Trying to develop in prep for <a href=\"https://twitter.com/hashtag/gutenberg?src=hash&ref_src=twsrc{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}5Etfw\">#gutenberg</a> is like shooting at a fast moving target atm. Makes me agree  more and more with <a href=\"https://twitter.com/mor10?ref_src=twsrc{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}5Etfw\">@mor10</a> that we need a 6 month freeze once the code base is stable to prepare properly.</p>\n<p>&mdash; pootlepress (@pootlepress) <a href=\"https://twitter.com/pootlepress/status/1035574622840938496?ref_src=twsrc{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}5Etfw\">August 31, 2018</a></p></blockquote>\n<p></p>\n<p>Pootlepress founder Jamie Marsland said they plan to sell Storefront Blocks at several price points: $75 (single site license), $125 for 5 sites, $149 for 25 sites, and $199 for an unlimited license. The product is a natural extension of their current offerings, which include a page builder plugin used on more than 10,000 websites and a Storefront Pro plugin used on 5,000+ stores.</p>\n<p>Marsland said he was previously a skeptic about Gutenberg but is convinced that a unified interface is going to be the chief benefit of Gutenberg in the long term.</p>\n<p>&#8220;My skepticism was really based on how it was being rolled out to the WP community, rather than the technical approach of Gutenberg,&#8221; Marsland said. &#8220;I still feel that way actually. But from a end user point of view I’m convinced users are going to love it. 50{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8} of our business is focused on running WordPress training courses for beginners, so we see first hand the issues that WordPress users have with the existing editor. The layout limitations of the current editor is the number complaint that users have with WordPress (from our experience of having trained thousands of end users over the past 7 years).&#8221;</p>\n<p>Marsland&#8217;s team at Pootlepress has gone all-in on developing for Gutenberg. So far their greatest challenge in extending the new editor has been keeping pace with its rapid development.</p>\n<p>&#8220;It feels a bit like developing for a moving target at times,&#8221; Marsland said. &#8220;The Gutenberg documentation is getting better but there are still gaps in it. The Slack channel has been really helpful though and the team have been great and responding to specific questions we have.&#8221;</p>\n<p>Marsland doesn&#8217;t see Gutenberg impacting Pootlepress&#8217; WooCommerce page builder product, at least not until Gutenberg evolves further on its journey into site customization capabilities.</p>\n<p>&#8220;At the moment Gutenberg is quite limited in what’s possible from a layout and design perspective,&#8221; Marsland said. &#8220;For example, our WooCommerce page builder plugin lets users change the design and layout of individual WooCommerce products. This isn’t possible with Gutenberg and may not be for quite some time. It feels like Gutenberg will stay more of a content editor than become a true page builder, especially given the current feedback from the community. That said, the ease of adding blocks within a unified interface like Gutenberg is perfect for a block approach like we are building for Storefront Blocks.&#8221;</p>\n<p>If you&#8217;ve been wondering what Gutenberg will look like in a WooCommerce context, Pootlepress&#8217; upcoming Storefront Blocks plugin gives you an idea of the customization possibilities the new editor will bring. The plugin makes it easy for non-technical store owners to showcase their products in a compelling way and enables them to create and customize product layouts. Storefront Blocks is an impressive example of how Gutenberg-powered products can replace clunky shortcodes with a more user-friendly interface for building store pages.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Sep 2018 21:27:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"HeroPress: The Deaf World May Await, But It’s Not Silent\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=2616\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:160:\"https://heropress.com/essays/the-deaf-world-may-await-but-its-not-silent/#utm_source=rss&utm_medium=rss&utm_campaign=the-deaf-world-may-await-but-its-not-silent\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:15627:\"<img width=\"960\" height=\"480\" src=\"https://s20094.pcdn.co/wp-content/uploads/2019/09/090518-min-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: The handicap of deafness is no in the ear, it is in the mind. -- Marlee Matlin\" /><p>Have you ever wondered what it would be like if the world you lived in completely changed, turning your life upside down?</p>\n<p>And for those who have gone through an experience like this, can you remember how it felt to wake up in a world you were not used to?</p>\n<p>Even though life can throw many curve balls your way, the way you tackle them can redefine you as a person.</p>\n<h3>From One World to Another</h3>\n<p>I was just a toddler when I was diagnosed with a hearing impairment. My parents noticed my speaking skills lagged behind other toddlers of a similar age. I was diagnosed with a hearing loss at the age of 2 or 3.</p>\n<p>Even though it’s something I’ve lived with my entire life, it has been (and still is) a long and confusing journey for me as I try to figure out how best to live with it.</p>\n<p>You see, I’m not profoundly deaf. I can hear relatively well for now (I’ll get to that part in a minute), which means that I was brought up in a mainstream hearing environment.</p>\n<p>This didn’t come without its challenges though as I experience inaccessibility issues regularly. For example, noisy environments such as bars and restaurants, bad audio at conferences and mumbling voices when listening to podcasts.</p>\n<p>As a young child who didn’t know any better and acted naive about life, I just accepted it. But then as I got older and learned more about the world around me, well, that’s when things started to change.</p>\n<p>Because I am part of the hearing world but also have one “ear” in the non-hearing world, it has been a confusing position to be in. I already know what it’s “supposed to” be like if I had normal hearing. But that’s the thing, I don’t have normal hearing and I’m not profoundly deaf either.</p>\n<p>So where do I stand?</p>\n<p>Well there was always the possibility that my hearing would get worse, which was something my audiologist told me as a teenager. I figured maybe that will give me a better idea of where I stand.</p>\n<blockquote><p>But come on, as a teenager, I acted like a teenager – I was in denial about my situation and just wanted to fit in, like we all do as human beings.</p></blockquote>\n<p>Nothing was going to stop me from playing football, playing the guitar, socialising with friends, going to restaurants (plenty of head nodding happens there) and going to the cinema (even if I had to pretend to enjoy the latter and act as if I could hear everything, which was awkward when everyone talks about it afterwards).</p>\n<p>Over time, I learned to develop tricks to help me get by, living in both worlds. For example, when playing the guitar, I’m not able to fine-tune my music without the help of technology or someone else who can assist me. Or when I go to the cinema, I only focus on action movies so I don’t REALLY have to talk about the story line, so I talk about the graphics, car chases and explosions instead.</p>\n<p>On top of that I was learning English, which is my second language (but now my main language), and I was having speech therapy sessions and attended countless audiology appointments.</p>\n<p>But you keep going, right? You don’t let anything stop you. I made it through two universities, a number of jobs and navigated life in general throughout my twenties relatively unscathed.</p>\n<p>Then one day, a few years ago, I realised my hearing had declined even further. Unexpectedly, I found myself in a much quieter world than the one I was used to.</p>\n<p>Remember that warning from the audiologist? Well things got very real, very fast.</p>\n<p>I realised there was no turning back. And so began a whole new unfamiliar journey over what to do next.</p>\n<h3>Silent with a Loud Voice</h3>\n<p>It’s quite common to see online creators documenting their lives using whatever platform is available, such as social media and personal websites. The same applies for those who are going through certain struggles and share them with the world. And I used to find that strange. For something so personal, why would you share this with strangers?</p>\n<p>Many years ago, it’s not something that I would have thought of doing. And there was definitely no intention of writing about being partially deaf. Like I said, I was trying to fit in, so I told myself to keep going to the cinema and pretend that I enjoyed it.</p>\n<p>But there comes a time where you have to stop pretending and start being real, like I did by creating a video to publicly declare my intention to do so (and I’ll talk more about that later).</p>\n<p>I’m lucky to have a job that revolves around the internet. As someone who works in the digital marketing industry, it was natural for me to <a href=\"https://iamahmedkhalifa.com\" target=\"_blank\" rel=\"noopener\">have my own website</a>. I remember there were a lot of experimenting and trying to work out how to start one, as well as trying to figure out what it should be about.</p>\n<p>Having your own website sounds like a cool thing to have, but it wasn’t something I made a lot of use of in the early days. My priority was always on my clients’ or employers’ websites.</p>\n<p>But over the past few years, I’ve grown more and more involved with WordPress and have a deeper appreciation for those who use the platform to find their voice.</p>\n<p>And that made me curious.</p>\n<blockquote><p>It wasn’t until I started my own business in 2016 that I took WordPress more seriously, both for me personally and for my clients.</p></blockquote>\n<p>That is when I started to get more involved with the WordPress community. Because of my continued desire to contribute to the community and also how much I enjoyed helping others to make the most out of their WordPress sites. This inevitably led me to being one of the co-organisers of the WordPress meet-up group in Edinburgh as well as the current lead organiser for WordCamp Edinburgh.</p>\n<p>My main WordPress site is my business site. It’s where I predominantly focus on the subjects of SEO, Google Analytics, WordPress (of course), online business, etc. You know, anything to help others use their WordPress site to grow their online visibility, engagement and conversion.</p>\n<p>There is another side to being part of WordPress, and that is the community – it means you’re involved with a wide variety of people, mixing with different personalities and opening your mind to more experiences. It is where you can share valuable insights that can impact not just your life but the lives of those around you who are using WordPress in some shape or form.</p>\n<p>And that includes the subjects of inclusivity and accessibility, two areas which have a direct effect on me. But with regards to accessibility, I do depend on subtitles/closed captions in certain situations. I’m thankful that TV is getting better at it, but outside the house, it’s not that simple.</p>\n<blockquote><p>Having been to many meet-ups and WordCamps, the code of conduct is clear – it’s about making the environment welcoming and comfortable for everyone.</p></blockquote>\n<p>The subject of online accessibility is becoming more important. Even though we are still behind in terms of understanding accessibility and making it a standard approach on websites, I’m starting to see people taking it more seriously, and rightly so.</p>\n<p>So I should feel comfortable about the online world, right? Well, not exactly. Accessibility is still trying to catch up online and offline for everyone, not just for deaf people. For example, there are still campaigns going on to have subtitled screenings at cinemas as they tend to be limited and are often used during impossible hours like Monday mornings.</p>\n<p>Because apparently, deaf people don’t have day jobs.</p>\n<p>The combined effect of a lack of accessibility and various challenges means there is a nagging feeling that being deaf means my abilities are limited in an online world.</p>\n<p>It’s a stupid thing, right? But imposter syndrome is a powerful thing. If you don’t have a firm hold on it, it can be beat the hell out of you.</p>\n<p>Until one day&#8230;</p>\n<p>“Enough! I’ve had enough.”</p>\n<p>There came a point where I decided to let go of the very thing (my hearing impairment) that I felt was holding me back in life and to use that as the catalyst to move forward. I was reading a book called “Let Go” by Pat Flynn of Smart Passive Income. He is someone I’ve admired from afar and I have learnt a lot from him, even before reading that book.</p>\n<p>But that book was the first “soft” trigger for me in accepting the present and the future. Little did I realise how doing this would pave the way for a whole new world of possibilities and opportunities. And that’s when the second trigger happened. I had the opportunity of spending a day with Pat in San Diego – it was an experience I’ll never forget.</p>\n<p>But just as importantly and for the final trigger, it allowed me remove those chains that shackled me and gave me the freedom to move forward and to take advantage of whatever life had to offer me, even if it meant things were “limited” because of my gradual hearing loss.</p>\n<p>It’s amazing what can happen when you share your vulnerabilities and experiences with others. We can always learn from each other and sharing this experience has ended up helping many others. I have received private messages from strangers thanking me for creating videos that help spread awareness.</p>\n<p>And I’m not stopping there either.</p>\n<h3>The World Got Quieter</h3>\n<p>If I am going deeper into the deaf world, it doesn’t mean it’s going to be silent, at least not in an online sense. I have created a dedicated website called <a href=\"https://hearmeoutcc.com\" target=\"_blank\" rel=\"noopener\">Hear Me Out! [CC]</a> to document my hearing journey. It’s a place to share other people’s stories and to provide advice on managing in the deaf world – whether you are deaf or not.</p>\n<p>See, that’s the great thing about putting websites together. It’s about giving you the platform you never had before. It’s also the ethos of WordPress &#8220;to democratise publishing through Open Source, GPL Software”.</p>\n<p>It’s a funny thing when you start documenting and talking about your life online. Many people use social media as a platform to help with that and to create a voice, but I prefer to use my WordPress site for that voice. And then I use social media to help elevate it.</p>\n<h3>Your Voice Can Influence Others</h3>\n<p>Since I’ve been using WordPress and been involved in digital marketing for almost 10 years, it made sense to use that experience to my advantage. I’m lucky that my business allows me to use my expertise to help other people with their sites.</p>\n<p>But sometimes you have to be a little selfish and think about your own journey too, not just those of your clients or customers (as well as your friends and family).</p>\n<p>Not only are you allowed to do that, but you should do that. Because if you don’t help yourself first, you can’t help anyone else around you.</p>\n<p>Several years ago, I wouldn’t have thought of doing that. I mean, who the hell would want to listen to me? But I truly believe in the motto “your vibe attracts your tribe” – it doesn’t matter who you are, you’ve got something worth sharing online that your tribe, whoever they are, would love.</p>\n<p>And it’s never too late to start.</p>\n<hr />\n<p>There is a quote I really like by American actress, Marlee Matlin:</p>\n<blockquote><p>“The handicap of deafness is not in the ear; it is in the mind.”</p></blockquote>\n<p>That quote applies to me perfectly, but you can also apply it to your own circumstances if deafness doesn’t apply to you.</p>\n<p>It’s like that old saying we all heard as children: “You can do anything if you put your mind to it.”</p>\n<p>It is kind of true in a way, but it has taken me a long time to realise it. Even though I wish I had started earlier, it’s about starting today rather than thinking about yesterday.</p>\n<p>And I think that can apply to any situation.</p>\n<p>I’m not just talking about creating a website. It’s also about finding the right time for you to let go of whatever is holding you back, and for you to understand what your next steps are.</p>\n<p>That was my challenge. I had to redefine myself if I wanted to move forward. I see no reason why you can’t do that too.</p>\n<p>So here is my message to you: if you have something that is holding you back, I urge you to write down what you are going to do about it. You need to stick it somewhere where you can see it all the time.</p>\n<p>And if you are feeling REALLY brave, you can let me know in the comment section below what is holding you back in your life – and what you are doing to let it go.</p>\n<p>My way of doing that was to create another WordPress site to share my stories and document my journey.</p>\n<p>Because take it from me, once you do that, the world awaits you… online and offline.</p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: The Deaf World May Await, But It&#8217;s Not Silent\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=The{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}20Deaf{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}20World{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}20May{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}20Await{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2C{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}20But{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}20It{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}27s{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}20Not{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}20Silent&via=heropress&url=https{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}3A{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2F{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fheropress.com{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fessays{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fthe-deaf-world-may-await-but-its-not-silent{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: The Deaf World May Await, But It&#8217;s Not Silent\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}3A{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2F{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fheropress.com{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fessays{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fthe-deaf-world-may-await-but-its-not-silent{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}3A{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2F{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fheropress.com{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fessays{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fthe-deaf-world-may-await-but-its-not-silent{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2F&title=The+Deaf+World+May+Await{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2C+But+It{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}26{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}238217{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}3Bs+Not+Silent\" rel=\"nofollow\" target=\"_blank\" title=\"Share: The Deaf World May Await, But It&#8217;s Not Silent\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/the-deaf-world-may-await-but-its-not-silent/&media=https://heropress.com/wp-content/uploads/2019/09/090518-min-150x150.jpg&description=The Deaf World May Await, But It\'s Not Silent\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: The Deaf World May Await, But It&#8217;s Not Silent\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/the-deaf-world-may-await-but-its-not-silent/\" title=\"The Deaf World May Await, But It&#8217;s Not Silent\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/the-deaf-world-may-await-but-its-not-silent/\">The Deaf World May Await, But It&#8217;s Not Silent</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Sep 2018 08:00:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Ahmed Khalifa\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:108:\"WPTavern: AMP for WordPress Plugin to Introduce User-Friendly Theme Support Settings in Upcoming 1.0 Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83671\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:119:\"https://wptavern.com/amp-for-wordpress-plugin-to-introduce-user-friendly-theme-support-settings-in-upcoming-1-0-release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14488:\"<p>In October, Google&#8217;s open source <a href=\"https://www.ampproject.org/\" rel=\"noopener noreferrer\" target=\"_blank\">AMP project</a> (Accelerated Mobile Pages) will be heading into its third year. The initiative aims to improve performance on the mobile web and currently boasts usage on 25 million domains across publishing, advertising, e-commerce, and business websites.</p>\n<p>WordPress had a rocky beginning with its <a href=\"https://wordpress.org/plugins/amp/\" rel=\"noopener noreferrer\" target=\"_blank\">official AMP plugin</a>, which was originally developed by Automattic, one of the earliest publishing partners on the project. The first versions of the plugin were not easy to use, especially for heavily customized installations. It required site owners to invest considerable effort into optimizing AMP pages and fine tuning them for their needs. AMP for WordPress <a href=\"https://wptavern.com/amp-project-turns-2-automattic-partners-with-google-to-improve-wordpress-plugin\" rel=\"noopener noreferrer\" target=\"_blank\">went without updates for 10 months in 2017</a>, was fraught with errors, and incompatible with many other plugins.</p>\n<p>XWP began leading development of the plugin last year in partnership with Google, beginning with the 0.6 release. Weston Ruter is the tech lead with several XWP engineers contributing to development, design, and testing. Alberto Medina, Developer Advocate at Google, and his team have been leading the product management and outreach efforts.</p>\n<p>&#8220;Around May last year, my team at Google started a long-term effort with a bigger scope than just AMP, which included significantly investing engineering resources on the development of the plugin,&#8221; Medina said. &#8220;We started investing development resources, and then teamed up with XWP to expand the engineering scope. During this phase of the project Google and XWP have driven all the execution of the project and the development efforts.&#8221;</p>\n<p>Ruter said his team went through six months of the plugin&#8217;s support topics on WordPress.org and categorized them to figure out what issues users were struggling with most. They used that information to guide the focus for their first release and have been keeping a pulse on the support forum ever since.</p>\n<p>The plugin has incorporated many changes since XWP began spearheading its development, putting AMP&#8217;s newer features to use within the context of WordPress. Earlier versions of the plugin only allowed posts to be served as AMP but the 0.6 release added pages to its capabilities. Version 0.7 introduced the ability for all URLS on a site to served as AMP (“Native AMP”) but lacked the ability for users to customize which types of content should be excluded from this format. The upcoming 1.0 release will allow users to have a native AMP site that excludes certain templates, such as a shopping cart or a category archive, from being served as AMP.</p>\n<p>&#8220;AMP initially was limited in functionality,&#8221; Ruter said. &#8220;The AMP plugin was created when AMP was young. In the beginning it was focused on Accelerated <em>Mobile</em> Pages and it wasn&#8217;t able to recreate full responsive experiences that site owners expect. This has changed and AMP is able to do a lot. So that is what we have been focused on with the AMP plugin, is to bring it up to speed with the AMP project itself so that WordPress sites can take advantage of all the features and functionality that are now available.&#8221;</p>\n<p>The team at XWP is aiming to release version 1.0 of AMP for WordPress in mid-September. The <a href=\"https://make.xwp.co/2018/06/09/amp-plugin-release-v1-0-alpha1/\" rel=\"noopener noreferrer\" target=\"_blank\">1.0 alpha release</a> introduced extended AMP theme support with a more user-oriented approach to the settings. Previous versions of the plugin were more developer-centric, requiring edits to a theme or child theme to configure template support. Users can now enable Native AMP or Paired mode on the AMP settings screen and the <a href=\"https://make.xwp.co/2018/07/06/amp-plugin-release-v1-0-beta1/\" rel=\"noopener noreferrer\" target=\"_blank\">beta release</a> adds granular controls for selecting supported templates.</p>\n<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/09/amp-1-0-beta.png?ssl=1\"><img /></a>image credit: <a href=\"https://make.xwp.co/2018/07/06/amp-plugin-release-v1-0-beta1/\">XWP</a>\n<p>Other notable updates in the alpha and beta releases include:</p>\n<ul>\n<li>Enhanced UI for handling AMP validation errors</li>\n<li>Expanded Gutenberg support to surface AMP validation errors at a block level</li>\n<li>Addition of AMP-specific functionality to core blocks</li>\n<li>Redirection to non-AMP URL when unaccepted validation errors present</li>\n<li>Beta brings back WP Admin Bar AMP menu with AMP error highlighting</li>\n</ul>\n<p>AMP for WordPress <a href=\"https://make.xwp.co/2018/08/06/amp-plugin-release-v1-0-beta2/\" rel=\"noopener noreferrer\" target=\"_blank\">v1.0-beta2</a> was released in August and is not yet ready for production use. The good news for those who want to use AMP is that the plugin is becoming more of a plug-and-play solution as development progresses.</p>\n<p>&#8220;There is only one setting that the user needs to change to take advantage of the new theme support: switching from legacy to paired or native,&#8221; Ruter said. &#8220;Everything else is optional and just customizes the behavior. There will be a new admin pointer in 1.0 that will call out this updated admin screen.&#8221;</p>\n<p>Ruter also said his team is considering implementing a wizard-type experience to minimize the number of tweaks users need to make. They are discussing automating the compatibility check of the various templates prior to enabling theme support so users can get a high level view of the areas of the site that would be best-suited for AMP.</p>\n<h3>AMP Remains a Controversial Solution to Web Page Performance</h3>\n<p>Many users encountered insurmountable difficulties in their first attempts at using the AMP plugin with highly customized sites, relegating AMP usage to sites with dedicated engineering teams. Early versions of the AMP project did not have the flexibility that many publishers required.</p>\n<p>Brian Boyer, VP of Product and People at Spirited Media, home of The Incline, Billy Penn, and Denverite publications, gave a presentation at WordCamp for Publishers titled &#8220;<a href=\"https://wordpress.tv/2018/08/22/brian-boyer-why-we-ditched-amp-and-other-ux-choices-we-made-for-launching-membership/\" rel=\"noopener noreferrer\" target=\"_blank\">Why we ditched AMP, and other UX choices we made for launching membership</a>.&#8221;</p>\n<p>&#8220;We need more control over our user experience than AMP allows &#8211; to build an unshitty, persuasive, native feeling, highly effective membership experience, I need a little more JavaScript,&#8221; Boyer said. &#8220;I need a little bit more control over the page and to be fair, we could probably make some of this stuff but we cannot afford to design, build, and most crucially, test multiple versions of our website.&#8221;</p>\n<p>Boyer cited the expense of of building and testing multiple codebases as one of the primary reasons his team ditched AMP. The complication of maintaining a second user experience was &#8220;far too much to ask&#8221; for his development team, who had already produced a fast, lightweight WordPress setup with proper caching.</p>\n<p>&#8220;An AMP page might load a little faster but our other needs far outweigh that minor performance improvement,&#8221; Boyer said. &#8220;We got over our FOMP (Fear of Missing Pageviews). If I can be better at making conversions, I&#8217;ll take the hit with pageviews.&#8221;</p>\n<p>Recent <a href=\"https://xwp.co/an-introduction-to-native-amp/\" rel=\"noopener noreferrer\" target=\"_blank\">Enhancements to the AMP project and the plugin</a>, including the addition of components allowing for the creation of rich interactive experiences, continue to narrow the gap between the custom JavaScript many websites require and AMP&#8217;s limitations. This may be encouraging for those who have chosen to embrace AMP, but ultimately will not make a difference for those who fundamentally oppose the initiative as an affront to the open web.</p>\n<p>Beyond the technical investment in fine-tuning an AMP setup to meet the needs of his publications, Boyer concluded the presentation by outlining his broader objections to the AMP project:</p>\n<blockquote><p>By policing slow websites, Google has turned the big publishers&#8217; problem into my problem, but that fix comes at a high cost to me, a small publisher,&#8221; Boyer said. &#8220;AMP is not the Open Web &#8211; it&#8217;s a short term fix for bad choices. If you build a slow and terrible website that supports a creepy business model, like tracking the shit out of your users, then yes, AMP is one path to a better user experience. It is an escape hatch from your legacy code and the bad choices of your predecessors. I understand why that would be tempting, but it is also a deal with the devil. AMP and its cousin Instant Articles put even more control in the hands of companies that already have too much control, and I for one cannot abide by that. I just ask you, do the work, fix your websites, make them fast, friendly, and respectful.</p></blockquote>\n<p>Other vocal critics are not comfortable with how Google is positioning AMP as a long-term solution, instead of addressing the root issues of web page performance. Jeremy Keith articulated this stance in his article titled &#8220;<a href=\"https://adactio.com/journal/13964\" rel=\"noopener noreferrer\" target=\"_blank\">AMPstinction</a>.&#8221;</p>\n<p>&#8220;If the AMP project existed in order to create a web where AMP was no longer needed, I think I could get behind it,&#8221; Keith said. &#8220;But the more it’s positioned as the only viable solution to solving performance, the more uncomfortable I am with it.</p>\n<p>&#8220;Which, by the way, brings me to one of the most pernicious ideas around Google AMP—positioning anyone opposed to it as not caring about web performance. Nothing could be further from the truth. It’s precisely because performance on the web is so important that it deserves a long-term solution, co-created by all of us: not some commandants delivered to us from on-high by one organization, enforced by preferential treatment by that organization’s monopoly in search.&#8221;</p>\n<p>However, decoupling AMP from Google&#8217;s influence would also mean separating the project from the leadership and resources that have so far driven its adoption across millions of websites. There may be other approaches to addressing performance but Alberto Medina and his team see AMP as serving a practical purpose for users and developers who wouldn&#8217;t otherwise be capable of optimizing their sites to the same degree. What he described is in a sense &#8220;democratizing performance.&#8221;</p>\n<p>&#8220;The root causes of web performance problems are well known and there are tools, techniques, and web APIs, that allow developers to achieve awesome UX close to what AMP provides,&#8221; Medina said. &#8220;However, the reality is that doing so is very hard for most developers. Usually achieving it requires having solid engineering teams and enough financial resources. That is not fair for most developers and organizations that do not have the resources.&#8221;</p>\n<p>Medina sees AMP as an answer to what he describes as the <a href=\"https://medinathoughts.com/2018/05/17/progressive-wordpress/\" rel=\"noopener noreferrer\" target=\"_blank\">Capability/Usage gap</a>: the difference between what can be achieved in the web and what is actually done in the web.</p>\n<p>&#8220;The problem is that as the power and complexity of the web increases, that gap has increased as well,&#8221; Medina said. &#8220;The problem is that as long as that gap exists, achieving the best UX is not possible. So, the goal is to close that gap. There are two options: developers do the right thing all the time, or we provide tooling/libraries that enable them to do the right thing in an easy and effective way. AMP served the latter purpose.&#8221;</p>\n<p>Medina also emphasized that AMP is fully built on open web technologies. &#8220;Basically, it provides what developers could do by themselves but it is hard to do,&#8221; he said.</p>\n<p>In a recent <a href=\"https://art19.com/shows/recode-decode/episodes/3d56208e-a4b9-4c74-861e-8fec105a4ee8\" rel=\"noopener noreferrer\" target=\"_blank\">Recode Decode podcast interview</a> with Kara Swisher, Matt Mullenweg also weighed in on the AMP project.</p>\n<p>&#8220;It gets a bad rap because Google kind of botched the rollout a little bit,&#8221; Mullenweg said. &#8220;The underlying tech is open source and it&#8217;s actually quite good. Because for you as an independent publisher to have a future, we need you to load just as fast as something that&#8217;s embedded in an app. Facebook has done the bait and switch so many times that we need an independent alternative and I think AMP can be that.&#8221;</p>\n<p>Google&#8217;s investment in the AMP plugin through its partnership with Automattic and XWP has made AMP more approachable for the average user, especially with the updates coming in version 1.0. Medina said Google chose to collaborate with WordPress because they share a similar goal of providing a better user experience for the platform.</p>\n<p>&#8220;AMP is not an end goal in itself; the real objective is enabling all WordPress developers and site owners to provide awesome user experiences powered by WordPress,&#8221; Medina said. &#8220;AMP is just a component in that overall story, together with PWA capabilities, coding and performance best practices, Tide, etc.&#8221; In architecting the latest version of the plugin, Medina said the team is aiming to &#8220;enable native AMP experiences in WordPress without compromising content fidelity or surrendering the flexibility of the WordPress platform.&#8221;</p>\n<p>Whatever your opinion of the AMP project, the user-friendly theme support options and better validation error handling are game changing improvements for the WordPress plugin. It is currently active on more than 300,000 sites. Updates coming in the 1.0 release will enable thousands of WordPress users to have a more successful experience with AMP.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Sep 2018 21:28:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"Dev Blog: The Month in WordPress: August 2018\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6191\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/news/2018/09/the-month-in-wordpress-august-2018/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5553:\"<p>Many of the WordPress contribution teams have been working hard on the new WordPress editor, and the tools, services, and documentation surrounding it. Read on to find out more about this ongoing project, as well as everything else that has been happening around the WordPress community in August.</p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>WordPress 4.9.8 is Released</h2>\n\n<p><a href=\"https://wordpress.org/news/2018/08/wordpress-4-9-8-maintenance-release/\">WordPress 4.9.8 was released</a> at the beginning of the month. While this was a maintenance release fixing 46 bugs, it was significant for Core development because it made a point of highlighting Gutenberg — the new WordPress editor that is currently in development (more on that below).<br /></p>\n\n<p>This release also included some important updates to the privacy tools that were added to Core earlier this year.<br /></p>\n\n<p>Want to get involved in building WordPress Core? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a> and join the #core channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>New WordPress Editor Development Continues</h2>\n\n<p>Active development continues on <a href=\"https://wordpress.org/gutenberg/\">Gutenberg</a>, the new editing experience for WordPress Core. <a href=\"https://make.wordpress.org/core/2018/08/31/whats-new-in-gutenberg-31st-august/\">The latest version</a> features a number of important user experience improvements, including a new unified toolbar and support for a more focussed writing mode.<br /></p>\n\n<p>Users can test Gutenberg right now by installing <a href=\"https://wordpress.org/plugins/gutenberg/\">the plugin</a>, which currently has nearly 300,000 active installs. Along with that, <a href=\"https://wordpress.org/gutenberg/handbook/reference/faq/\">the Gutenberg Handbook</a> has some very useful information about how to use and develop for the new editor.<br /></p>\n\n<p>Want to get involved in building Gutenberg? Follow <a href=\"https://make.wordpress.org/core/tag/gutenberg/\">the #gutenberg tag on the Core team blog</a> and join the #core-editor channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.</p>\n\n<h2>Planning Begins for the Next Global WordPress Translation Day</h2>\n\n<p>The Global WordPress Translation Day is a 24-hour event held online and all across the world. It is designed to bring communities together to translate WordPress into their local languages, and to help them connect with other communities doing the same thing.<br /></p>\n\n<p>There have been three Translation Days since April 2016, and <a href=\"https://make.wordpress.org/polyglots/2018/08/29/global-wordpress-translation-day-4-preliminary-planning/\">the fourth edition is in the planning stages now</a>. The Polyglots team, who organizes these events, is currently looking for input on the date, format, and content for the event and would love some feedback from the community.<br /></p>\n\n<p>Want to get involved in translating WordPress into your own language? Follow <a href=\"https://make.wordpress.org/polyglots/\">the Polyglots team blog</a> and join the #polyglots channel in the <a href=\"https://make.wordpress.org/chat/\">Making WordPress Slack group</a>.<br /></p>\n\n<hr class=\"wp-block-separator\" />\n\n<h2>Further Reading:</h2>\n\n<ul><li><a href=\"https://wordpress.org/support/upgrade-php/\">The Update PHP page on WordPress.org</a> has been revised and improved to make the reasons for upgrading more clear.</li><li>The Mobile team is looking for people to help test the latest versions of the <a href=\"https://make.wordpress.org/mobile/2018/08/29/call-for-testing-wordpress-for-android-10-8/\">Android</a> and <a href=\"https://make.wordpress.org/mobile/2018/08/28/call-for-testing-wordpress-for-ios-10-8/\">iOS</a> apps for WordPress.</li><li><a href=\"https://wordbits.io/\">WordBits</a> is a innovative new platform for publishing WordPress-based code snippets with the ability to download each snippet as a working plugin.</li><li>The Community Team <a href=\"https://make.wordpress.org/community/2018/08/27/wordcamp-incubator-2018-update-thread-august-edition/\">has some updates</a> about how things are going with this year’s WordCamp Incubator program.</li><li>The WordPress Support Forums <a href=\"https://make.wordpress.org/support/2018/08/august-16th-support-team-meeting-summary/\">now include a feature</a> allowing forum volunteers to easily report a post to the moderators for a follow-up.</li><li>WordCamp Kochi, India <a href=\"https://2018.kochi.wordcamp.org/wordcamp-kochi-2018-is-postponed-to-november-3rd-2018-saturday/\">has unfortunately had to postpone their event</a> due to floods in the region.</li><li><a href=\"http://www.wpglossary.net/\">WP Glossary</a> is a new site that offers helpful definitions of words that you could encounter when using WordPress.</li><li>A few WordPress community members <a href=\"https://make.wordpress.org/community/2018/08/13/in-the-words-of-the/\">have started a working group</a> to tackle the idea of building diverse WordPress  communities all across the world.</li><li>A new <a href=\"https://editorblockswp.com/library/\">Gutenberg Block Library</a> is available, listing the details of the many blocks available for the new editor.</li></ul>\n\n<p><em>If you have a story we should consider including in the next “Month in WordPress” post, please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 03 Sep 2018 11:00:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"WPTavern: Gutenberg 3.7 Released, Introduces Spotlight Mode\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83662\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wptavern.com/gutenberg-3-7-released-introduces-spotlight-mode\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1786:\"<p>Gutenberg 3.7 <a href=\"https://wordpress.org/plugins/gutenberg/\">is available</a> for download and contains a number of changes. The Fixed Toolbar has been renamed Unified Toolbar. This is an optional mode that fixes all of the toolbar icons to the top of the editor, similar to the Classic editor.</p>\n\n<p>The team discovered that experienced users who don&#8217;t mind the disconnect between blocks and the toolbar preferred this layout. <br /></p>\n\n<div class=\"wp-block-image\"><img />Unified Toolbar</div>\n\n<p>There&#8217;s now an animation and icon specifically tailored for the Block Converter action. Hovering the cursor over a block&#8217;s icon will display two arrows that represent the ability to change block types. <br /></p>\n\n<div class=\"wp-block-image\"><img />Change Bock Types Icon</div>\n\n<p>For those who want to focus on one block of content at a time, there&#8217;s a new mode called Spotlight. When enabled, the blocks that are not being edited partially fade away and the block outlines disappear. This is an experimental attempt at introducing a <a href=\"https://wptavern.com/gutenberg-contributors-considering-a-focus-mode-for-writing\">Distraction Free Writing mode</a>. </p>\n\n<p>The <a href=\"https://github.com/WordPress/gutenberg/pull/9152\">icons have been updated</a> for Paragraph, Heading, and Subheading blocks to add clarity. Previous to 3.7, the Paragraph block icon looked like an alignment option causing confusion. </p>\n\n<div class=\"wp-block-image\"><img />Updated Icons for Paragraph, Heading, and Subheading blocks</div>\n\n<p>You can find a complete list of changes and links to corresponding issues on GitHub by visiting the <a href=\"https://make.wordpress.org/core/2018/08/31/whats-new-in-gutenberg-31st-august/\">Gutenberg 3.7 release post</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 31 Aug 2018 21:34:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WPTavern: WPWeekly Episode 329 – Gutenberg, Forks, and WordPress Development Cycles\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=83650&preview=true&preview_id=83650\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://wptavern.com/wpweekly-episode-329-gutenberg-forks-and-wordpress-development-cycles\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3189:\"<p>In this episode, <a href=\"http://jjj.me\">John James Jacoby</a> and I discuss the news of the week. We have a candid conversation about what it would be like if Gutenberg were merged into WordPress trunk earlier versus developed as a plugin. We also talk about Classic Editor install numbers, praising forks of WordPress, and some new tools that are available to search Gutenberg blocks. This might be the first episode since Jacoby took over as co-host that we ended the show in under an hour.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"https://wptavern.com/gutenberg-block-library-provides-a-searchable-index-of-individual-blocks\">Gutenberg Block Library Provides a Searchable Index of Individual Blocks</a></p>\n<p><a href=\"https://wptavern.com/gutenberg-and-classic-editor-plugins-pass-200000-active-installations-wordpress-4-9-9-planning-underway\">Gutenberg and Classic Editor Plugins Pass 200,000 Active Installations, WordPress 4.9.9 Planning Underway</a></p>\n<p><a href=\"https://wptavern.com/wordpress-to-support-classic-editor-for-many-years-to-come-plugin-and-theme-markets-expected-to-drive-gutenberg-adoption\">WordPress to Support Classic Editor for “Many Years to Come,” Plugin and Theme Markets Expected to Drive Gutenberg Adoption</a></p>\n<p><a href=\"https://wptavern.com/gary-pendergast-praises-classicpress-extends-invitation-for-collaboration\">Gary Pendergast Praises ClassicPress, Extends Invitation for Collaboration</a></p>\n<p><a href=\"https://wptavern.com/wordcamp-for-publishers-2018-videos-now-available-on-wordpress-tv\">WordCamp for Publishers 2018 Videos Now Available on WordPress.tv</a></p>\n<p><a href=\"https://wptavern.com/wpcampus-2018-videos-are-now-available-to-watch\">WPCampus 2018 Videos Are Now Available to Watch</a></p>\n<p><a href=\"https://wptavern.com/new-network-media-library-plugin-creates-a-shared-library-on-a-multisite-network\">New Network Media Library Plugin Creates a Shared Library on a Multisite Network</a></p>\n<p><a href=\"https://wptavern.com/new-wp-glossary-site-translates-wordpress-techspeak-into-plain-english\">New WP Glossary Site Translates WordPress Techspeak into Plain English</a></p>\n<h2>Picks of the Week:</h2>\n<p>Jeff &#8211; <a href=\"https://www.youtube.com/channel/UCuhqf3xFlQcopapi4xHiTfA\">WP Minute</a> by Malcom Peralty over at <a href=\"https://www.presstitan.com/\">PressTitan</a> &#8211; A new video series by a longtime friend and former co-host, David Peralty that provides quick updates on stories making the rounds in the WordPress ecosystem.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday,September 5th 3:00 P.M. Eastern</p>\n<p>Subscribe to <a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\">WordPress Weekly via Itunes</a></p>\n<p>Subscribe to <a href=\"https://www.wptavern.com/feed/podcast\">WordPress Weekly via RSS</a></p>\n<p>Subscribe to <a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\">WordPress Weekly via Stitcher Radio</a></p>\n<p>Subscribe to <a href=\"https://play.google.com/music/listen?u=0#/ps/Ir3keivkvwwh24xy7qiymurwpbe\">WordPress Weekly via Google Play</a></p>\n<p><strong>Listen To Episode #329:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 30 Aug 2018 09:11:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: Distributor Plugin Now Publicly Available, Adds Gutenberg Support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83634\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://wptavern.com/distributor-plugin-now-publicly-available-adds-gutenberg-support\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2468:\"<p>10up&#8217;s Distributor plugin has exited beta and is <a href=\"https://10up.com/blog/2018/distributor-wordpress-syndication-reuse/\" rel=\"noopener noreferrer\" target=\"_blank\">now publicly available</a>. The free plugin syndicates content across WordPress multisite networks and the web. It <a href=\"https://wptavern.com/distributor-plugin-now-in-beta-a-new-wordpress-content-syndication-solution-from-10up\" rel=\"noopener noreferrer\" target=\"_blank\">went into beta</a> last year and 10up reports that more than 100 organizations and developers participated in the beta program.</p>\n<p>&#8220;We’ve already integrated many improvements contributed by beta testers, including 10up clients,&#8221;  10up President Jake Goldman said. &#8220;Distributor has been approved for use on WordPress.com VIP and is ready for enterprise implementations. We have a roadmap of planned enhancements, with ambitious plans including more advanced media distribution and sophisticated &#8216;take down&#8217; features for the forced removal of distributed content.&#8221;</p>\n<p>The public release of Distributor also introduces support for Gutenberg for the settings that are available in the edit screen. Users should be aware that this new feature is still in beta, as Gutenberg is still in active development and not has not yet been merged into WordPress core.</p>\n<a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/08/distributor-gutenberg.png?ssl=1\"><img /></a>image credit: <a href=\"https://10up.com/blog/2018/distributor-wordpress-syndication-reuse/\">10up</a>\n<p>&#8220;We’ve even considered interoperability between the classic editor and Gutenberg, and instances where custom blocks are not registered on remote sites,&#8221; Goldman said. &#8220;All aspects of the user interface have been carried over to ensure a coherent and cohesive experience.&#8221;</p>\n<p>10up has also launched an Enterprise support package that offers faster response for issues, support for custom integrations, and white-labeling. Support packages fund ongoing development and customers have the opportunity to help shape the roadmap of the plugin.</p>\n<p>Distributor is available at <a href=\"http://distributorplugin.com\" rel=\"noopener noreferrer\" target=\"_blank\">distributorplugin.com</a> where users can register to get a free license key. The plugin is also <a href=\"https://github.com/10up/distributor\" rel=\"noopener noreferrer\" target=\"_blank\">available on GitHub</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Aug 2018 21:48:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: Gutenberg Contributors Considering a “Focus Mode” for Writing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83525\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://wptavern.com/gutenberg-contributors-considering-a-focus-mode-for-writing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4462:\"<p>After overwhelming <a href=\"https://wordpress.org/support/plugin/gutenberg/reviews/\" rel=\"noopener noreferrer\" target=\"_blank\">feedback from testers</a> indicating that Gutenberg is not well suited for simply writing posts, the project&#8217;s contributors are considering a few options for improving the writing flow. These proposals are spread across several tickets on GitHub.</p>\n<p>Two weeks ago, Gutenberg technical lead Matias Ventura submitted a PR exploring the possibility of <a href=\"https://github.com/WordPress/gutenberg/pull/8920\" rel=\"noopener noreferrer\" target=\"_blank\">introducing a &#8220;Focus Mode&#8221; to the editor</a>. This mode would highlight the current selected block with all other blocks faded while the &#8220;fix toolbar to header&#8221; option is enabled. The video below shows an example of what that might look like:</p>\n<p></p>\n<p>&#8220;The aim is to provide a writing experience that can satisfy those that would prefer an environment with the least amount of distractions at the expense of tool clarity,&#8221; Ventura said. &#8220;I&#8217;ve been testing this and personally find it a very enjoyable mode to toggle when I just want to write for a bit. Paired with a robust set of keyboard shortcuts it could be quite nice to use. In this sense, it&#8217;d be important to provide an easy keyboard shortcut to toggle the mode on and off.&#8221;</p>\n<p>Automattic designer Kjell Reigstad opened another <a href=\"https://github.com/WordPress/gutenberg/issues/9334\" rel=\"noopener noreferrer\" target=\"_blank\">ticket</a> that proposes transforming the &#8220;Fix Toolbar to Top&#8221; setting into a &#8220;Focus Mode.&#8221;</p>\n<p>&#8220;A key feedback point we hear is that Gutenberg’s interface can be a little overwhelming,&#8221; Reigstad said. &#8220;This often comes from users who more commonly focus on &#8216;writing&#8217; versus &#8216;building&#8217; their posts. They find the contextual block controls and block hover states to be distracting: When they&#8217;re focused on writing, they don&#8217;t necessarily want to think about blocks — they just want to write.&#8221;</p>\n<p>Reigstad said this same subset of users also misses having the formatting toolbar at the top of the page, as it is in other applications like Google Docs, MS Word, and WordPress&#8217; classic editor. He proposed a solution that addresses these concerns by combining the &#8220;Fix Toolbar to Top&#8221; option with the following UI changes that would provide a more complete &#8220;Focus Mode:&#8221;</p>\n<ul>\n<li>The block toolbar would be pinned to the top of the screen.</li>\n<li>The editor would be full screen.</li>\n<li>Block outlines would be removed for both hover and selected states.</li>\n<li>The block label would appear on a delay, and be toned down visually.</li>\n<li>Block mover + block options would also appear on a delay.</li>\n</ul>\n<p>Reigstad also created a video demo of this concept:</p>\n<p></p>\n<p>This new &#8220;focus Mode&#8221; concept is also compatible with Ventura&#8217;s proposal for highlighting the current selected block and fading out the others. It could either be present in both modes or available as an add-on feature.</p>\n<p>A couple of well-written reviews on the Gutenberg plugin <a href=\"https://wordpress.org/support/topic/not-everyone-needs-everything-to-be-blocks-gutenberg-must-focus-on-writers/\" rel=\"noopener noreferrer\" target=\"_blank\">describe how the concept of blocks complicates the writing experience</a> and how Gutenberg&#8217;s current writing environment is <a href=\"https://wordpress.org/support/topic/gutenberg-gets-wordpress-wrong-and-is-a-terrible-writing-environment/\" rel=\"noopener noreferrer\" target=\"_blank\">visually distracting and disruptive</a>. This has been a major concern since the plugin was first released for testing, as there are many users who depend on WordPress for its writing features more than the page building aspects.</p>\n<p>The Gutenberg team&#8217;s new ideas go a long way towards decluttering the interface for writers. This is especially important for those who want to do their long-form writing inside WordPress, instead of beginning their work in an application that is dedicated to providing a distraction-free writing experience. Introducing a &#8220;focus mode&#8221; or &#8220;writing mode&#8221; will solve one of the most critical issues with the new editor and we&#8217;re looking forward to seeing how this develops.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Aug 2018 18:32:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"HeroPress: WordPress Is For You\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://heropress.com/?p=2610\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"https://heropress.com/wordpress-is-for-you/#utm_source=rss&utm_medium=rss&utm_campaign=wordpress-is-for-you\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3215:\"<img width=\"960\" height=\"480\" src=\"https://s20094.pcdn.co/wp-content/uploads/2015/08/OpenUpDoors-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: This one simple attitude adjustment, changing “no” to “let me look into that”, opened up more doors and possibilities than I ever thought possible.\" /><p>When HeroPress started, a stated intention was to be a voice for people on the fringe of the Western WordPress culture. In my head I thought this geographical, and involved places like Africa and Asia. I quickly came to realize that everyone is on the fringe of something.</p>\n<p>This month&#8217;s HeroPress replay is titled &#8220;<a href=\"https://heropress.com/essays/doing-what-i-want/\">Doing What I Want</a>&#8221;  by Becky Davis. Becky&#8217;s an American, but she doesn&#8217;t fit the American IT worker mold of young white male. In fact, her gender and age were regular friction points in her attempts to get jobs. She&#8217;s not old by any means, but she&#8217;s not 19 either.</p>\n<p>WordPress became a place for her where things like age and gender don&#8217;t matter nearly as much as other jobs. Check out Becky&#8217;s essay and perhaps drop her a comment.</p>\n<p>&nbsp;</p>\n<blockquote class=\"wp-embedded-content\"><p><a href=\"https://heropress.com/essays/doing-what-i-want/\">Doing What I Want</a></p></blockquote>\n<p></p>\n<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: WordPress Is For You\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=WordPress{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}20Is{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}20For{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}20You&via=heropress&url=https{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}3A{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2F{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fheropress.com{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fwordpress-is-for-you{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: WordPress Is For You\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}3A{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2F{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fheropress.com{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fwordpress-is-for-you{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}3A{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2F{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fheropress.com{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2Fwordpress-is-for-you{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8}2F&title=WordPress+Is+For+You\" rel=\"nofollow\" target=\"_blank\" title=\"Share: WordPress Is For You\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/wordpress-is-for-you/&media=https://heropress.com/wp-content/uploads/2015/08/OpenUpDoors-150x150.jpg&description=WordPress Is For You\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: WordPress Is For You\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/wordpress-is-for-you/\" title=\"WordPress Is For You\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/wordpress-is-for-you/\">WordPress Is For You</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Aug 2018 12:17:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"WPTavern: Gary Pendergast Praises ClassicPress, Extends Invitation for Collaboration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83608\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"https://wptavern.com/gary-pendergast-praises-classicpress-extends-invitation-for-collaboration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2529:\"<p>Gutenberg and WordPress core contributor Gary Pendergast has <a href=\"https://pento.net/2018/08/26/forking-is-a-feature/\">weighed in</a> with this thoughts on <a href=\"https://wptavern.com/classicpress-gutenberg-not-included\">ClassicPress</a>, a fork of WordPress created by Scott Bowler. Pendergast praises the fork and extended an open invitation to Bowler to collaborate in the future. </p>\n\n<blockquote class=\"wp-block-quote\"><p>As a member of the WordPress core team, I certainly hold no ill-feelings towards them, and I hope they’ll be open to working with us in the future. I hope we’ll be able to learn from their work, to improve WordPress for everyone.</p><p>Ultimately, we all share the same goal: creating a free and open web, \nfor everyone to enjoy. While ClassicPress has styled itself as a protest\n against Gutenberg for now, I hope they’ll find their voice <em>for</em> something, instead of just <em>against</em> something.</p><cite>Gary Pendergast</cite></blockquote>\n\n<p>In the comments of the article, Pendergast <a href=\"https://pento.net/2018/08/26/forking-is-a-feature/#comment-37409\">received harsh criticism</a> for writing blog posts instead of working on Gutenberg&#8217;s 1K plus issues on GitHub. In an example of <a href=\"https://chrislema.com/grace/\">showing grace</a>, Pendergast <a href=\"https://pento.net/2018/08/26/forking-is-a-feature/#comment-37412\">responds</a> to the person&#8217;s question of whether or not Gutenberg&#8217;s development team is correctly prioritizing their time.</p>\n\n<p>&#8220;Personally, I believe we’re doing a reasonable job, though we could probably lean a little <em>more</em> towards blogging than we are now,&#8221; he said. &#8220;There’s been valid criticism that the Gutenberg team has been less communicative than it could be, which we’re working to address.&#8221;</p>\n\n<p>Additionally, Pendergast compared the number of open issues in other projects and dismissed it as a measurement of software quality or readiness. </p>\n\n<p>Personally, I miss reading blog posts about WordPress from core developers. Many of the people on the <a href=\"https://planet.wordpress.org/\">Planet WordPress feed</a> no longer work on the project or write about WordPress. </p>\n\n<p>I always enjoyed when they shared their deep knowledge of the software or explained why they decided to lead the project in a certain direction. Pendergast&#8217;s post is a breath of fresh air and something I&#8217;d like to see more often from other core contributors.<br /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Aug 2018 04:58:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"WPTavern: New WP Glossary Site Translates WordPress Techspeak into Plain English\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83522\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://wptavern.com/new-wp-glossary-site-translates-wordpress-techspeak-into-plain-english\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3701:\"<p><a href=\"http://www.andersnoren.se/\" rel=\"noopener noreferrer\" target=\"_blank\">Anders Norén</a> has launched a new website called <a href=\"https://www.wpglossary.net/\" rel=\"noopener noreferrer\" target=\"_blank\">WP Glossary</a> that contains definitions for terms that people encounter when using WordPress. The resource was born out of a need to provide documentation for client projects.</p>\n<p>&#8220;The last time I updated the glossary for a new client documentation, in the middle of May this year, it hit me that there must be a website for this,&#8221; Norén said. &#8220;A list of WordPress definitions written not for WordPress developers, but for those who manage WordPress websites either as part of their work or in their spare time.&#8221;</p>\n<p>Norén said he found resources written for developers but nothing satisfactory for regular WordPress users. Inspired to fill this gap, he bought a domain name and built the site over the next couple weeks. WP Glossary contains definitions for nearly a hundred WordPress-specific and industry-related terms, with more than 25,000 total words.</p>\n<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/08/wp-glossary.jpg?ssl=1\"><img /></a>image credit: Anders Norén\n<p>Norén, who has recently jumped into client work with a new agency, is better known for his popular minimalist <a href=\"https://wordpress.org/themes/author/anlino/\" rel=\"noopener noreferrer\" target=\"_blank\">themes on WordPress.org</a>. His 17 themes have a cumulative rating of 4.97 out of 5 stars and <a href=\"http://wptally.com/?wpusername=anlino\" rel=\"noopener noreferrer\" target=\"_blank\">more than 2.1 million downloads</a>. He designed the WP Glossary site, wrote all the definitions, and credits <a href=\"https://twitter.com/tdh\" rel=\"noopener noreferrer\" target=\"_blank\">Thord Hedengren</a> for feedback on the design and editorial assistance.</p>\n<p>Each glossary term includes a plain English definition and common use cases with a bit of WordPress history sprinkled in. The terms also link to related documentation and some also have related WordPress.tv links. The <a href=\"https://www.wpglossary.net/word/default-themes/\" rel=\"noopener noreferrer\" target=\"_blank\">Default Themes</a> term is the longest article on the site with 1,744 words. Each term has a &#8220;Send Corrections&#8221; link that visitors can use if they see a term that could be improved.</p>\n<p>WP Glossary was enthusiastically received when Norén <a href=\"https://twitter.com/andersnoren/status/1033636227994533888/photo/1\" rel=\"noopener noreferrer\" target=\"_blank\">announced it on Twitter</a>. Many commented that the site will be useful for meetups with members who are new to WordPress and need a quick way to look up some of the jargon they encounter.</p>\n<p>Norén&#8217;s glossary project overlaps with a glossary the WordPress Marketing team <a href=\"https://make.wordpress.org/marketing/2018/02/28/wordpress-jargon-glossary/\" rel=\"noopener noreferrer\" target=\"_blank\">published</a> earlier this year. WP Glossary is more in-depth and contains less techspeak than the marketing team&#8217;s copy. It is also targeted at people who use WordPress as part of their job or as a hobby.</p>\n<p>The sheer volume of terms on this site reveals how much insider language one encounters while managing a WordPress site. If you&#8217;re working in the WordPress world every day, it&#8217;s easy to forget how unfamiliar these terms are to new users. WP Glossary is released under the Creative Commons Attribution 4.0 International license (CC BY 4.0) so freelancers and agencies that want to duplicate, modify, and share the material have permission to do so with attribution.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Aug 2018 20:25:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"WPTavern: A Proposal for Improving the Change Block Type User Interface in Gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83570\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://wptavern.com/a-proposal-for-improving-the-change-block-type-user-interface-in-gutenberg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3549:\"<p>In Gutenberg 3.6.2, the development team moved the Convert Block option to the left most icon in the toolbar. As long as the toolbar is visible, so is the option to change block types. However, there are a few user experience issues with this approach.<br /></p>\n\n<img />Convert Block Option\n\n<p>The first is obvious. The paragraph block icon looks like an alignment option. The second issue is that the icon represents the current block being edited, sort of like a block label. Unless a user hovers their cursor over the icon, it&#8217;s difficult to realize that it&#8217;s for changing block types. </p>\n\n<p><a href=\"https://twitter.com/kevinwhoffman\" rel=\"noreferrer noopener\" target=\"_blank\">Kevin Hoffman</a>, a WordPress developer and core contributor, <a href=\"https://github.com/WordPress/gutenberg/issues/9127#issuecomment-416058227\">has proposed</a> a new user interface suggestion that aims to solve the issues mentioned above. </p>\n\n<img />Suggested Changes by Kevin Hoffman\n\n<p>Hoffman suggests changing the icon to a drop-down menu, similar to the one in the Classic Editor. The menu would make the ability to change block types more discoverable. It removes confusion associated with icons and is a workflow that&#8217;s already established. </p>\n\n<p>Gutenberg developer Joen Asmussen <a href=\"https://github.com/WordPress/gutenberg/issues/9127#issuecomment-416166190\">thanked Hoffman</a> for the feedback and listed a number of things to consider with his approach. These include the editor&#8217;s <a href=\"https://github.com/WordPress/gutenberg/issues/7479#issuecomment-410988762\">need to be responsive</a>, <a href=\"https://github.com/WordPress/gutenberg/issues/9075\">scale to editors</a> with thin columns, accessibility, and accommodating long block names. </p>\n\n<p>Gutenberg technical lead Matías Ventura <a href=\"https://github.com/WordPress/gutenberg/issues/9127#issuecomment-416206202\">also commented</a> on the proposal.</p>\n\n<blockquote class=\"wp-block-quote\"><p>Just wanted to say thanks for all the constructive voices here and willingness to find better solutions. If there&#8217;s anything that is fairly clear is that the current &#8216;block switching&#8217; interaction is not as obvious as it could be.</p><p>I think using the paragraph icon instead of the one that is easily confused as alignment, <a href=\"https://github.com/jasmussen\">@jasmussen</a>&#8216;s update in <a href=\"https://github.com/WordPress/gutenberg/pull/9310\">#9310</a>, plus the addition of the drop-down arrow are a good baseline to check on the next release and see if we need something more involved. <a href=\"https://github.com/kevinwhoffman\">@kevinwhoffman</a> it&#8217;d be great to expand on your proposal and see how it might look across more blocks and nested contexts.</p><cite>Matías Ventura</cite></blockquote>\n\n<p>Depending on your workflow, changing block types will be a common action. For example, I often press enter at the end of a paragraph block which creates a new paragraph block automatically. Being able to easily identify and use the change block type option will improve my writing experience.<br /></p>\n\n<p>Those with feedback on Hoffman&#8217;s proposal are encouraged to <a href=\"https://github.com/WordPress/gutenberg/issues/9127\">respond to the issue</a> on GitHub. It&#8217;s also worth noting that the team is <a href=\"https://github.com/WordPress/gutenberg/pull/9310#issuecomment-416210915\">experimenting with using an icon</a> that&#8217;s designated specifically for changing block types. <br /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Aug 2018 08:24:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:137:\"WPTavern: WordPress to Support Classic Editor for “Many Years to Come,” Plugin and Theme Markets Expected to Drive Gutenberg Adoption\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83528\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:141:\"https://wptavern.com/wordpress-to-support-classic-editor-for-many-years-to-come-plugin-and-theme-markets-expected-to-drive-gutenberg-adoption\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7283:\"<p>During the <a href=\"https://wordpress.tv/2017/12/04/matt-mullenweg-state-of-the-word-2017/\" rel=\"noopener noreferrer\" target=\"_blank\">2017 State of the Word</a> address, Matt Mullenweg announced the availability of the <a href=\"https://wordpress.org/plugins/classic-editor/\" rel=\"noopener noreferrer\" target=\"_blank\">Classic Editor</a> plugin for site owners who are not ready to adopt Gutenberg when it makes its debut in WordPress 5.0. Since its release, the community has speculated about what the plugin&#8217;s active installation numbers mean and how long it will be supported.</p>\n<p>Matt Mullenweg has confirmed that support for the Classic Editor will be available for &#8220;many years to come,&#8221; which should come as a relief to those who feared that WordPress would drop support for the old editor after a year or two.</p>\n<p>&#8220;I love that people are using the Classic Editor plugin!&#8221; Mullenweg said in <a href=\"https://wptavern.com/gutenberg-and-classic-editor-plugins-pass-200000-active-installations-wordpress-4-9-9-planning-underway#comment-257369\" rel=\"noopener noreferrer\" target=\"_blank\">comment</a> on a recent post. &#8220;There is an infinite number of ways that WP can be used and not all will be ready for Gutenberg when 5.0 is released, Classic allows people to still be able to update core and stay current with releases, and with the click of a button try out Gutenberg again in the future if they want to. It’s also trivial to maintain because Gutenberg also uses TinyMCE, so Classic Editor users will still get improvements and updates to TinyMCE — I won’t say &#8216;forever&#8217; but I don’t see any reason why we can’t maintain classic for the edit screen for many years to come.&#8221;</p>\n<p>These assurances about the continued availability of the classic editor mean that WordPress product developers will need to decide if they want to provide support for both editing experiences or go full steam ahead with Gutenberg, limiting support to WordPress 5.0+. We don&#8217;t yet know how many users will be installing the Classic Editor after WordPress 5.0 is released but that may inform more product decisions in the future.</p>\n<h3>The Market Will Drive Gutenberg Adoption</h3>\n<p>During the Q&amp;A following the State of the Word in 2017, WordPress developer <a href=\"https://twitter.com/kevinwhoffman\" rel=\"noopener noreferrer\" target=\"_blank\">Kevin Hoffman</a> asked a question about the prospect of developers having to support two different editing interfaces:</p>\n<blockquote><p>Hearing you suggest the Classic Editor plugin and different ways to undeclare support for Gutenberg leads me to this idea that we are headed towards a split admin interface with no finality to the transition, meaning that I don&#8217;t see a time in the future where everyone will be on Gutenberg. We will always have these people in classic mode. As plugin and theme developers, we will always have to support two different types of users. How do we reach that point where we are past the transition, however long it might take, where we can not have this box of chocolates effect where you click &#8220;edit post type&#8221; and you never know what you&#8217;re going to get?</p></blockquote>\n<p>Mullenweg said his hope and expectation, based on how this has worked out with new interfaces in the past, is that over time product developers would adopt the latest interface. He cited the Customizer as one example where one is now very hard-pressed to find a theme developer who is rolling their own options panel after the Customizer was introduced as the new standard. It was just three years ago in 2015 when <a href=\"https://wptavern.com/wordpress-org-now-requires-theme-authors-to-use-the-customizer-to-build-theme-options\" rel=\"noopener noreferrer\" target=\"_blank\">WordPress.org began requiring theme options to be built using the Customizer</a> and now it is used everywhere.</p>\n<p>&#8220;The truth is, if you are a plugin or theme developer, people are going to expect things in Gutenberg, so you really need to develop for Gutenberg,&#8221; Mullenweg said. &#8220;And then, at some point, I&#8217;m totally ok if you drop support for the Classic [Editor]. There will be themes and plugins that will say you need to have Gutenberg, [WP] 5.0 or newer if you want to use this.</p>\n<p>&#8220;We already have that existing now. Plugins only support so far back in PHP in WordPress. There will be plugins that don&#8217;t support under WordPress 5.0. It&#8217;s not going to be that much different from supporting different WordPress versions where people choose sometimes to go way way way back, sometimes a year or several years, and support WordPress 3.8 and 3.9. And some don&#8217;t bother anymore. There&#8217;s lots of APIs and other things that changed during that time. At some point you just have to make a cost benefit analysis and do things like maybe Yoast is doing for upgrading PHP, and say, &#8216;Hey, if you really want the best of this, check out this new thing.\'&#8221;</p>\n<p>As Gutenberg blocks become the standard way of extending WordPress&#8217; editing and customization capabilities, the market will drive its adoption. This is already happening with new blocks and block collections being released every day. The new <a href=\"https://wptavern.com/gutenberg-block-library-provides-a-searchable-index-of-individual-blocks\" rel=\"noopener noreferrer\" target=\"_blank\">Gutenberg Block Library</a> offers a glimpse of that and there are many more blocks on GitHub that are not yet commercially marketed.</p>\n<p>During that December 2017 Q&amp;A, developers seemed to be excited about the Gutenberg demos they had just seen but their uneasiness was palpable in their questions. Now, eight months later, the current proliferation of Gutenberg themes and plugins demonstrates that WordPress developers are ready to embrace the new editor and build the creative extensions that Gutenberg&#8217;s creators&#8217; had always anticipated.</p>\n<p>&#8220;I’m really looking forward to seeing what the design and developer community can build with it and where their imaginations can take us from there,&#8221; Gutenberg technical lead Matías Ventura said when I <a href=\"https://wptavern.com/interview-with-matias-ventura-on-building-the-vision-for-gutenberg\" rel=\"noopener noreferrer\" target=\"_blank\">interviewed</a> him in June. &#8220;Core is going to supply the infrastructure and the main building blocks but it’s everything that can be built around it that’s going to be exciting, as always with WordPress.”</p>\n<p>The extension ecosystem that made WordPress a success in the first place is going to be a key influence in driving adoption for the new editor. Major players in the product market are not waiting to see how users react to the new editor before building their Gutenberg-compatible interfaces. Users may not be compelled by the writing experience, but Gutenberg&#8217;s block model will provide a better framework for site customization and a core standard for page builders that interface with WordPress. If the blocks pouring into the ecosystem right now are any indication, the plugin market surrounding Gutenberg is going to offer an exciting variety of tools for site building.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 28 Aug 2018 04:28:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: Gutenberg Block Library Provides a Searchable Index of Individual Blocks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83507\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"https://wptavern.com/gutenberg-block-library-provides-a-searchable-index-of-individual-blocks\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4439:\"<p>An avalanche of blocks is pouring into the WordPress ecosystem ahead of Gutenberg&#8217;s inclusion in core. A few block collections, such as Atomic Blocks, Stackable, and CoBlocks, can be found on <a href=\"https://wordpress.org/plugins/search/gutenberg+block/\" rel=\"noopener noreferrer\" target=\"_blank\">WordPress.org</a>, but it&#8217;s not easy to search the individual blocks they contain. Other collections and standalone blocks are spread across the web. WordPress theme developer <a href=\"https://twitter.com/dannycooper147\" rel=\"noopener noreferrer\" target=\"_blank\">Danny Cooper</a> has built a centralized <a href=\"https://editorblockswp.com/library\" rel=\"noopener noreferrer\" target=\"_blank\">library of Gutenberg blocks</a> that are currently available to extend the new editor.</p>\n<p>The library loads blocks into a grid with infinite scroll. It is searchable, so visitors can easily find individual blocks that are part of a collection. Blocks are also tagged, which makes it possible to compare a group of similar blocks. Individual listings display screenshots of the block in action and its settings panel, as well as a link to the author and a link to download.</p>\n<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2018/08/screely-1535383280324.png?ssl=1\"><img /></a></p>\n<p>The Gutenberg Block Library currently has more than four dozen blocks. Visitors and block creators can <a href=\"https://editorblockswp.com/submit-block/\" rel=\"noopener noreferrer\" target=\"_blank\">submit a block</a> that is missing from the library.</p>\n<p>Cooper is the owner of <a href=\"https://olympusthemes.com/\" rel=\"noopener noreferrer\" target=\"_blank\">Olympus Themes</a>, a small collection of free and commercial niche-focused WordPress themes. He has also created his own blocks collection called <a href=\"https://editorblockswp.com/\" rel=\"noopener noreferrer\" target=\"_blank\">Editor Blocks</a>, which focuses on blocks for business sites. His corresponding <a href=\"https://wordpress.org/themes/editor-blocks/\" rel=\"noopener noreferrer\" target=\"_blank\">Editor Blocks theme</a> is available for free on WordPress.org with support for all the business blocks.</p>\n<p>&#8220;As a theme developer I&#8217;d been waiting for a way to build themes in a way where what you see on the backend matches what you will see on the frontend,&#8221; Cooper said. &#8220;That can be achieved to some extent using the Customizer, but it&#8217;s hard to craft more than one complex page using that method.&#8221;</p>\n<p>Cooper comes from a PHP/jQuery background and said he didn&#8217;t have a strong enough understanding of ES6, Webpack, Babel, React to create Gutenberg blocks right away. The learning curve was a little steep but after getting a handle on the basics he is now able to make small contributions to the Gutenberg project.</p>\n<p>&#8220;It felt like I was hitting a brick wall every five minutes when I started,&#8221; he said. &#8220;<a href=\"https://gutenberg.courses/development/\" rel=\"noopener noreferrer\" target=\"_blank\">Zac Gordon&#8217;s course</a> helped me get past that stage. The #core-editor slack channel was a big help too. Other than that I just studied the code of the core blocks and used Google. As my knowledge increased I&#8217;ve tried to reach out by submitting bug reports to other Block Libraries and making minor contributions to the Gutenberg project on Github.&#8221;</p>\n<p>WordPress.org may be able to benefit from a centralized block library in the future, as people will be frequently searching for blocks after Gutenberg lands in core. Cooper said if WordPress.org had a library like this it might even be possible to find and install blocks from inside Gutenberg.</p>\n<p>&#8220;I could build a block that searches my library but it wouldn&#8217;t be able to install them as most are part of a &#8216;collection,\'&#8221; Cooper said. &#8220;I&#8217;m not sure if in the future the &#8216;collections&#8217; will continue to grow or people will move towards releasing individual blocks.&#8221;</p>\n<p>In the meantime, the Gutenberg Block Library provides a helpful resource for early adopters. Browsing through the listings, it&#8217;s exciting to see the variety of block functionality that the community is creating. Users who fully embrace Gutenberg in WordPress 5.0 will find dozens of blocks (and perhaps hundreds by that time) available for the new editor, if they know where to look.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 27 Aug 2018 16:45:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Gary: Forking is a Feature\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"https://pento.net/?p=1603\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://pento.net/2018/08/26/forking-is-a-feature/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6868:\"<p>There&#8217;s a new WordPress fork called <a href=\"https://www.classicpress.net/\">ClassicPress</a> that&#8217;s been <a href=\"https://wptavern.com/classicpress-gutenberg-not-included\">making some waves</a> recently, with various members of the <a href=\"https://en.oxforddictionaries.com/definition/twitterati\">Twitterati</a> swinging between decrying it as an attempt to fracture the WordPress community, to it being an unnecessary over-reaction, to it being a death knell for WordPress.</p>\n\n<p>Personally, I don&#8217;t think it&#8217;s any of the above.</p>\n\n<p>Some years ago, <a href=\"https://twitter.com/anildash\">Anil Dash</a> wrote an article on this topic (which I totally <span>ripped</span> <em>forked</em> the name from), you should read it for some context.</p>\n\n\n<div class=\" content_cards_card content_cards_domain_anildash-com\">\n			<div class=\"content_cards_image\">\n				<a class=\"content_cards_image_link\" href=\"https://anildash.com/2010/09/10/forking_is_a_feature/\">\n					<img src=\"https://pento.net/wp-content/plugins/content-cards/skins/default/content-cards-placeholder.png\" alt=\"Forking is a Feature\" />				</a>\n		</div>\n	\n	<div class=\"content_cards_title\">\n		<a class=\"content_cards_title_link\" href=\"https://anildash.com/2010/09/10/forking_is_a_feature/\">\n			Forking is a Feature		</a>\n	</div>\n	<div class=\"content_cards_description\">\n		<a class=\"content_cards_description_link\" href=\"https://anildash.com/2010/09/10/forking_is_a_feature/\">\n			<p>While Linus Torvalds is best known as the creator of Linux, it’s one of his more geeky creations, and the social implications of its design, that may well end up being his greatest legacy. Because Linus has, in just a few short years, changed the social dynamic around forking,</p>\n		</a>\n	</div>\n	<div class=\"content_cards_site_name\">\n		<img src=\"https://anildash.com/favicon.png\" alt=\"Anil Dash\" class=\"content_cards_favicon\" />		Anil Dash	</div>\n</div>\n\n\n<p>With that context, I genuinely applaud ClassicPress for exercising their fundamental rights under the GPL. The <a href=\"https://wordpress.org/about/#bill-of-rights\">WordPress Bill of Rights</a> makes it quite clear that forking is not just allowed, it&#8217;s encouraged. You can and should fork WordPress if you choose to. This isn&#8217;t a flaw in the system, this is how it&#8217;s supposed to work.</p>\n\n<h2>Forks should aways be encouraged.</h2>\n\n<p>Forks are a fundamentally healthy aspect of Open Source software. A relatively recent example is the <a href=\"http://anandmanisankar.com/posts/nodejs-iojs-why-the-fork/\">io.js fork of Node.js</a>, which resulted in significant changes to how the Node.js project is governed and developed. WordPress has seen forks in the past, too: <a href=\"https://en.wikipedia.org/wiki/Lyceum_(software)\">Lyceum</a> was a fork that added multi-site support, before it existed in WordPress. WordPress MU was something of a sibling fork which also added multi-site support, and was ultimately merged back into WordPress.</p>\n\n<p>There are examples of forks that went on to become independent projects: WordPress itself is a fork of cafelog/b2. <a href=\"https://en.wikipedia.org/wiki/X.Org_Server#History\">X.org is a fork</a> of XFree86. LibreOffice is a fork of OpenOffice. <a href=\"https://en.wikipedia.org/wiki/Blink_(web_engine)\">Blink</a> is a fork of <a href=\"https://en.wikipedia.org/wiki/WebKit\">WebKit</a>, which in turn is a fork of <a href=\"https://en.wikipedia.org/wiki/KHTML\">KHTML</a>. MariaDB is a fork of MySQL. XBMC has been forked <a href=\"https://en.wikipedia.org/wiki/List_of_software_based_on_Kodi_and_XBMC\">dozens of times</a>. Joomla is a fork of Mambo. (Fun historical coincidence: I very nearly accepted a job offer from Miro, the company behind Mambo, just a couple of months before Joomla came into being!)</p>\n\n<h2>Maintaining a fork is hard, thankless work.</h2>\n\n<p>All of these independent forks have a common thread: they started with a group of people who were highly experienced in building the software they were forking (often comprising of core developers of the original software). That&#8217;s not to say that non-core developers can&#8217;t drive a fork, but it does seem to require fairly fundamental knowledge of the strengths and weaknesses of the software, in order to successfully fork it into an independent product.</p>\n\n<p>From a practical perspective, I can tell you that maintaining a fork of WordPress would require an extraordinary amount of work. For example, WordPress.com effectively maintains a fork (which happens to almost exactly match the Core codebase) of WordPress. The task of maintaining this fork falls to a talented team of devops folks, who review and merge each patch.</p>\n\n<p>Now, WordPress.com is really only an internal fork. To maintain a product fork of WordPress would require so much more effort. You&#8217;d need to maintain the web infrastructure to push out updates. As the fork diverges from WordPress Core, you would need to figure out how to maintain plugin and theme compatibility. You&#8217;d likely need to do your own bug and security fixes, on top of what&#8217;s merged from WordPress.</p>\n\n<p>I&#8217;m not saying this to dissuade anyone from forking WordPress, rather, it&#8217;s important to go into this aware of the challenges that lay ahead. For anyone who uses a fork (whether it be a fork of WordPress, or any other software product), I&#8217;m sure the maintainer would appreciate a word of thanks for the work they&#8217;ve done to make it possible. <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f642.png\" alt=\"🙂\" class=\"wp-smiley\" /></p>\n\n<h2>What&#8217;s next for ClassicPress?</h2>\n\n<p>Well, that&#8217;s ultimately up to the folks building it, and the people who use it. As a member of the WordPress core team, I certainly hold no ill-feelings towards them, and I hope they&#8217;ll be open to working with us in the future. I hope we&#8217;ll be able to learn from their work, to improve WordPress for everyone.</p>\n\n<p>It&#8217;s humbling and inspiring to build something that&#8217;s used by so many millions of sites, but at times it involves accepting that we can&#8217;t build the tool that will work for 100{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8} of people, 100{310e440c19ce892e3a2d19735cedd3d40cfd49ac7e0265dc6afbb4f18e33a9a8} of the time. Regardless of WordPress&#8217; future popularity, there&#8217;ll always be a place for alternatives, whether that be forks like ClassicPress, different CMSes like Drupal or Joomla, or even different publishing concepts, like MediaWiki or Mastodon.</p>\n\n<p>Ultimately, we all share the same goal: creating a free and open web, for everyone to enjoy. While ClassicPress has styled itself as a protest against Gutenberg for now, I hope they&#8217;ll find their voice <em>for</em> something, instead of just <em>against</em> something. <img src=\"https://s.w.org/images/core/emoji/11/72x72/1f496.png\" alt=\"💖\" class=\"wp-smiley\" /></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 26 Aug 2018 04:57:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Gary\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"WPTavern: WPCampus 2018 Videos Are Now Available to Watch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83466\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wptavern.com/wpcampus-2018-videos-are-now-available-to-watch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1710:\"<p>WPCampus 2018 was held July 12-14, 2018, at <a href=\"https://wustl.edu/\">Washington University</a> in St. Louis, Missouri. Educators, staff, and those in higher-education gathered to learn how WordPress can be and is used in higher-education environments. </p>\n\n<p>If you couldn&#8217;t attend in person or watch the live stream, you can now watch all of the sessions for free. Visit the event&#8217;s <a href=\"https://2018.wpcampus.org/schedule/\">schedule page</a> and click the Watch Session button. Alternatively, you can click on a session&#8217;s title to read a brief description and then watch the embedded video.</p>\n\n<p>Videos are hosted on YouTube which makes it easy to share and embed them. There are also links to view the presenter&#8217;s slides.</p>\n\n<p>If you have time, I recommend watching <a href=\"https://2018.wpcampus.org/schedule/gutenready-for-the-gutenpocalypse/\">GutenReady for the Gutenpocalypse</a> by Brian DeConinck and Jennifer McFarland who work at North Carolina State University in the Information and Technology Department. </p>\n\n<p>In this presentation, the duo explain what they&#8217;re doing to get staff, students, and campus sites prepared for Gutenberg. <br /></p>\n\n\n\n\n\n<p>In addition to the presentation above, I also recommend listening to <a href=\"https://wptavern.com/wpweekly-episode-324-getting-nc-state-gutenready\">episode 324</a> of WordPress Weekly where McFarland describes their experience so far in transitioning sites to Gutenberg, building custom blocks, and discussing what the future of themes might be like once the project is merged into WordPress. </p>\n\n<p>WPCampus organizers are in the beginning stages of planning next year&#8217;s event. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 24 Aug 2018 19:10:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:115:\"WPTavern: Gutenberg and Classic Editor Plugins Pass 200,000 Active Installations, WordPress 4.9.9 Planning Underway\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=83475\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"https://wptavern.com/gutenberg-and-classic-editor-plugins-pass-200000-active-installations-wordpress-4-9-9-planning-underway\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6122:\"<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2018/08/printing-letters.jpg?ssl=1\"><img /></a>photo credit: reingestalter <a href=\"http://www.flickr.com/photos/44668468@N00/115805043\">numeral types</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-sa/2.0/\">(license)</a>\n<p>It has been three weeks since the &#8220;Try Gutenberg&#8221; prompt was sent out in WordPress 4.9.8 and the <a href=\"https://wordpress.org/plugins/gutenberg/\" rel=\"noopener noreferrer\" target=\"_blank\">plugin</a> has now passed 200,000 active installations. The callout has increased the visibility of the Gutenberg project and brought necessary feedback to the development and design of the new editor.</p>\n<p>Prior to WordPress 4.9.8, Gutenberg reviews held a 2.7-star average on WordPress.org. Negative reviews continue to pour in and the average rating has slipped to 2.3 stars. Users are reporting that the new editor is too complicated, cumbersome, and that it offers an inferior writing experience. A few positive reviews are sprinkled in between, calling the editor a &#8220;necessary step forward,&#8221; and those reviewers seem hopeful that others will feel the same once they get past the learning curve. The vast majority of reviews, both positive and negative, report that Gutenberg&#8217;s interface is not yet intuitive to use.</p>\n<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2018/08/Screen-Shot-2018-08-24-at-10.32.49-AM.png?ssl=1\"><img /></a></p>\n<p>The Gutenberg team&#8217;s responses to reviews have improved to be less &#8220;canned&#8221; since the <a href=\"https://wptavern.com/gutenberg-plugin-garners-mixed-reactions-from-new-wave-of-testers\" rel=\"noopener noreferrer\" target=\"_blank\">initial reactions</a> a few days after the Gutenprompt went out. However, the team still appears to be combing the feedback for bugs with the existing interface. Overall, the team&#8217;s responses are unified in a general unwillingness to admit that there are critical flaws preventing the interface from being more well-received.</p>\n<p>Active installations of the <a href=\"https://wordpress.org/plugins/classic-editor/\" rel=\"noopener noreferrer\" target=\"_blank\">Classic Editor</a> plugin, the official antidote for those do not wish to adopt Gutenberg when it ships in WordPress 5.0, have climbed to more than 200,000. This number is about equal to the number of sites that have Gutenberg active. The Gutenberg team does not view Classic Editor installs as an important metric for understanding Gutenberg adoption or rejection but rather see these installs as a healthy intermediary step for sites keeping the same workflow while preparing for Gutenberg.</p>\n<p>In response to recent discussion surrounding the <a href=\"https://wptavern.com/classicpress-gutenberg-not-included\" rel=\"noopener noreferrer\" target=\"_blank\">ClassicPress fork of WordPress</a>, Matt Mullenweg <a href=\"https://wptavern.com/classicpress-gutenberg-not-included#comment-256813\" rel=\"noopener noreferrer\" target=\"_blank\">said</a>, &#8220;No plans to ever have direct vote determine strategic direction in WP, but we are having a bit of a referendum in the adoption of the Gutenberg and Classic Editor plugins, people are voting with their usage. The people are deciding.&#8221;</p>\n<p>This is essentially true in that users can decide if they want to adopt Gutenberg or not, for as long as the Classic Editor is supported. The Classic Editor plugin is an option people demanded but now the reality of two different admin experiences is nearer than before. The notion of a fork, though perhaps not a serious threat to the project, makes it painfully clear what some users are willing to do in order to avoid Gutenberg.</p>\n<p>With the number of Classic Editor plugin installations on the rise, WordPress is headed towards a fractured admin experience. For some it may be a healthy transition option, but in the end, the number of Classic Editor installations indicates how many sites will be running an alternative editing experience because site owners are either not ready or not willing to adopt Gutenberg.</p>\n<p>At some point in the future, WordPress will need to unite the editing experience, either by winning these users over to Gutenberg or by discontinuing support for the Classic Editor. In the meantime, WordPress product developers will need to provide support for both editing experiences or go all in on one or the other. It has the potential to erode WordPress&#8217; momentum for a few years, especially if Gutenberg doesn&#8217;t become more intuitive.</p>\n<h3>WordPress 4.9.9 Is Expected to be a 6-8 Week Maintenance Cycle</h3>\n<p>WordPress contributors met this week to <a href=\"https://make.wordpress.org/core/2018/08/24/dev-chat-summary-august-22-2018-4-9-9-weeks-1-2/\" rel=\"noopener noreferrer\" target=\"_blank\">discuss WordPress 4.9.9</a>.</p>\n<p>&#8220;As of now there’s no specific timeline for 4.9.9,&#8221; Jeff Paul said. &#8220;That will get set once release leads are in place. However, I’d like to try and finalize leads in next week’s meeting or shortly thereafter so that we can begin 4.9.9 planning and coordination as we get into September.&#8221; Paul requested contributor submit nominations for release leads, for themselves or others, ahead of next week&#8217;s meeting.</p>\n<p>&#8220;Until we have a confirmed timeline and plan for 5.0, my assumption is that we’ll continue with our minor release cadence of ~6-8 weeks with specific focus on items needed in support of 5.0,&#8221; Paul said.</p>\n<p>During his announcement at WordCamp Europe in Belgrade, Matt Mullenweg said WordPress 5.0 could happen as early as August. It&#8217;s now looking more likely that 5.0 will drop closer to the end of the year. This gives WordPress users and developers more time to prepare their sites to be compatible with Gutenberg and ready to take advantage of the new features it offers. The <a href=\"https://make.wordpress.org/core/5-0/\" rel=\"noopener noreferrer\" target=\"_blank\">schedule for releasing WordPress 5.0</a> is not yet set but the release is expected to happen in 2018.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 24 Aug 2018 18:55:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:8:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 25 Sep 2018 16:43:07 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:13:\"last-modified\";s:29:\"Tue, 25 Sep 2018 16:30:29 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:9:\"HIT ord 2\";s:16:\"content-encoding\";s:2:\"br\";}}s:5:\"build\";s:14:\"20130911133210\";}","no");
INSERT INTO wpjs_options VALUES("137","can_compress_scripts","1","no");
INSERT INTO wpjs_options VALUES("138","_transient_is_multi_author","0","yes");
INSERT INTO wpjs_options VALUES("156","_transient_twentyseventeen_categories","1","yes");
INSERT INTO wpjs_options VALUES("157","category_children","a:0:{}","yes");
INSERT INTO wpjs_options VALUES("216","_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9","1537936987","no");
INSERT INTO wpjs_options VALUES("217","_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9","1537893787","no");
INSERT INTO wpjs_options VALUES("218","_transient_timeout_dash_v2_88ae138922fe95674369b1cb3d215a2b","1537936987","no");
INSERT INTO wpjs_options VALUES("219","_transient_dash_v2_88ae138922fe95674369b1cb3d215a2b","<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wordpress.org/news/2018/09/the-month-in-wordpress-august-2018/\'>The Month in WordPress: August 2018</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://wptavern.com/gutenberg-3-9-introduces-reusable-exportable-templates-for-multiple-blocks\'>WPTavern: Gutenberg 3.9 Introduces Reusable, Exportable Templates for Multiple Blocks</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/new-commonwp-plugin-enables-wordpress-sites-to-use-the-free-jsdelivr-cdn\'>WPTavern: New commonWP Plugin Enables WordPress Sites to Use the Free jsDelivr CDN</a></li><li><a class=\'rsswidget\' href=\'https://wptavern.com/gutenstats-blog-is-live-tracking-gutenberg-beta-testing-data\'>WPTavern: Gutenstats Blog Is Live, Tracking Gutenberg Beta Testing Data</a></li></ul></div>","no");
INSERT INTO wpjs_options VALUES("225","_site_transient_update_themes","O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1537894121;s:7:\"checked\";a:5:{s:13:\"jupiter-child\";s:0:\"\";s:7:\"jupiter\";s:5:\"6.1.5\";s:13:\"twentyfifteen\";s:3:\"2.0\";s:15:\"twentyseventeen\";s:3:\"1.7\";s:13:\"twentysixteen\";s:3:\"1.5\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}","no");
INSERT INTO wpjs_options VALUES("226","current_theme","Jupiter Child Theme","yes");
INSERT INTO wpjs_options VALUES("227","theme_mods_jupiter-child","a:2:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}}","yes");
INSERT INTO wpjs_options VALUES("228","theme_switched","","yes");
INSERT INTO wpjs_options VALUES("229","mk_jupiter_theme_current_version","6.1.5","yes");
INSERT INTO wpjs_options VALUES("230","Jupiter_options_build","5baa66e99f472","yes");
INSERT INTO wpjs_options VALUES("231","mk_tour","a:1:{s:4:\"list\";a:1:{s:5:\"intro\";a:1:{s:5:\"state\";b:0;}}}","yes");
INSERT INTO wpjs_options VALUES("232","artbees_header_builder_db_version","2","yes");
INSERT INTO wpjs_options VALUES("233","widget_contact_form","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("234","widget_contact_info","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("235","widget_gmap","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("236","widget_social","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("237","widget_subnav","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("238","widget_testimonial_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("239","widget_twitter","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("240","widget_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("241","widget_flickr","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("242","widget_instagram","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("243","widget_news_feed_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("244","widget_mini_slidshow_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wpjs_options VALUES("245","_transient_mk_jupiter_theme_version","","yes");
INSERT INTO wpjs_options VALUES("246","artbees_api_key","e6028853ed12f97b406a44e685b75e000192485ee0fb94a98f3d0645386bdf66","yes");



CREATE TABLE `wpjs_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wpjs_postmeta VALUES("1","2","_wp_page_template","default");
INSERT INTO wpjs_postmeta VALUES("2","3","_wp_page_template","default");



CREATE TABLE `wpjs_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wpjs_posts VALUES("1","1","2018-09-21 18:06:32","2018-09-21 18:06:32","Welcome to WordPress. This is your first post. Edit or delete it, then start writing!","Hello world!","","publish","open","open","","hello-world","","","2018-09-21 18:06:32","2018-09-21 18:06:32","","0","http://www.destinationttn.com/?p=1","0","post","","1");
INSERT INTO wpjs_posts VALUES("2","1","2018-09-21 18:06:32","2018-09-21 18:06:32","This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:\n\n<blockquote>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my website. I live in Los Angeles, have a great dog named Jack, and I like pi&#241;a coladas. (And gettin\' caught in the rain.)</blockquote>\n\n...or something like this:\n\n<blockquote>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</blockquote>\n\nAs a new WordPress user, you should go to <a href=\"http://www.destinationttn.com/wp-admin/\">your dashboard</a> to delete this page and create new pages for your content. Have fun!","Sample Page","","publish","closed","open","","sample-page","","","2018-09-21 18:06:32","2018-09-21 18:06:32","","0","http://www.destinationttn.com/?page_id=2","0","page","","0");
INSERT INTO wpjs_posts VALUES("3","1","2018-09-21 18:06:32","2018-09-21 18:06:32","<h2>Who we are</h2><p>Our website address is: http://www.destinationttn.com.</p><h2>What personal data we collect and why we collect it</h2><h3>Comments</h3><p>When visitors leave comments on the site we collect the data shown in the comments form, and also the visitor&#8217;s IP address and browser user agent string to help spam detection.</p><p>An anonymized string created from your email address (also called a hash) may be provided to the Gravatar service to see if you are using it. The Gravatar service privacy policy is available here: https://automattic.com/privacy/. After approval of your comment, your profile picture is visible to the public in the context of your comment.</p><h3>Media</h3><p>If you upload images to the website, you should avoid uploading images with embedded location data (EXIF GPS) included. Visitors to the website can download and extract any location data from images on the website.</p><h3>Contact forms</h3><h3>Cookies</h3><p>If you leave a comment on our site you may opt-in to saving your name, email address and website in cookies. These are for your convenience so that you do not have to fill in your details again when you leave another comment. These cookies will last for one year.</p><p>If you have an account and you log in to this site, we will set a temporary cookie to determine if your browser accepts cookies. This cookie contains no personal data and is discarded when you close your browser.</p><p>When you log in, we will also set up several cookies to save your login information and your screen display choices. Login cookies last for two days, and screen options cookies last for a year. If you select &quot;Remember Me&quot;, your login will persist for two weeks. If you log out of your account, the login cookies will be removed.</p><p>If you edit or publish an article, an additional cookie will be saved in your browser. This cookie includes no personal data and simply indicates the post ID of the article you just edited. It expires after 1 day.</p><h3>Embedded content from other websites</h3><p>Articles on this site may include embedded content (e.g. videos, images, articles, etc.). Embedded content from other websites behaves in the exact same way as if the visitor has visited the other website.</p><p>These websites may collect data about you, use cookies, embed additional third-party tracking, and monitor your interaction with that embedded content, including tracking your interaction with the embedded content if you have an account and are logged in to that website.</p><h3>Analytics</h3><h2>Who we share your data with</h2><h2>How long we retain your data</h2><p>If you leave a comment, the comment and its metadata are retained indefinitely. This is so we can recognize and approve any follow-up comments automatically instead of holding them in a moderation queue.</p><p>For users that register on our website (if any), we also store the personal information they provide in their user profile. All users can see, edit, or delete their personal information at any time (except they cannot change their username). Website administrators can also see and edit that information.</p><h2>What rights you have over your data</h2><p>If you have an account on this site, or have left comments, you can request to receive an exported file of the personal data we hold about you, including any data you have provided to us. You can also request that we erase any personal data we hold about you. This does not include any data we are obliged to keep for administrative, legal, or security purposes.</p><h2>Where we send your data</h2><p>Visitor comments may be checked through an automated spam detection service.</p><h2>Your contact information</h2><h2>Additional information</h2><h3>How we protect your data</h3><h3>What data breach procedures we have in place</h3><h3>What third parties we receive data from</h3><h3>What automated decision making and/or profiling we do with user data</h3><h3>Industry regulatory disclosure requirements</h3>","Privacy Policy","","draft","closed","open","","privacy-policy","","","2018-09-21 18:06:32","2018-09-21 18:06:32","","0","http://www.destinationttn.com/?page_id=3","0","page","","0");
INSERT INTO wpjs_posts VALUES("4","1","2018-09-21 18:06:38","0000-00-00 00:00:00","","Auto Draft","","auto-draft","open","open","","","","","2018-09-21 18:06:38","0000-00-00 00:00:00","","0","http://www.destinationttn.com/?p=4","0","post","","0");



CREATE TABLE `wpjs_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wpjs_term_relationships VALUES("1","1","0");



CREATE TABLE `wpjs_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wpjs_term_taxonomy VALUES("1","1","category","","0","1");



CREATE TABLE `wpjs_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `wpjs_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wpjs_terms VALUES("1","Uncategorized","uncategorized","0");

