/* global tinymce */

( function() {
	tinymce.create(
		'tinymce.plugins.Subscribe2Plugin',
		{
			init: function( ed, url ) {
				var i      = 0,
				pb         = '<img src="' + url + '/../include/spacer.gif" class="mceSubscribe2 mceItemNoResize" />',
				cls        = 'mceSubscribe2',
				shortcode  = '[subscribe2]',
				pbreplaced = [],
				pbreplacedcount,
				pbRE       = new RegExp( /(\[|<!--)subscribe2.*?(\]|-->)/g ),
				replacer   = function( str ) {
					if ( -1 !== str.indexOf( 'class="mceSubscribe2' ) ) {
						str = pbreplaced[i];
					}
					return str;
				};

				// Register commands
				ed.addCommand(
					'mceSubscribe2',
					function() {
						ed.execCommand( 'mceInsertContent', 0, pb );
					}
				);

				// Register buttons
				ed.addButton(
					'subscribe2',
					{
						title: 'Insert Subscribe2 Token',
						image: url + '/../include/s2-button.png',
						cmd: cls
					}
				);

				// load the CSS and enable it on the right class
				ed.onInit.add(
					function() {
						ed.dom.loadCSS( url + '/css/content.css' );
						if ( ed.theme.onResolveName ) {
							ed.theme.onResolveName.add(
								function( th, o ) {
									if ( 'IMG' === o.node.nodeName && ed.dom.hasClass( o.node, cls ) ) {
										o.name = 'subscribe2';
									}
								}
							);
						}
					}
				);

				// allow selection of the image placeholder
				ed.onClick.add(
					function( ed, e ) {
						e = e.target;
						if ( 'IMG' === e.nodeName && ed.dom.hasClass( e, cls ) ) {
							ed.selection.select( e );
						}
					}
				);

				// re-enable the CSS when the node changes
				ed.onNodeChange.add(
					function( ed, cm, n ) {
						cm.setActive( 'subscribe2', 'IMG' === n.nodeName && ed.dom.hasClass( n, cls ) );
					}
				);

				// create an array of replaced shortcodes so we have additional parameters
				// then swap in the graphic
				ed.onBeforeSetContent.add(
					function( ed, o ) {
						pbreplaced = o.content.match( pbRE );
						o.content  = o.content.replace( pbRE, pb );
					}
				);

				// swap back the array of shortcodes to preserve parameters
				// replace any other instances with the default shortcode
				ed.onPostProcess.add(
					function( ed, o ) {
						if ( o.get ) {
							if ( null !== pbreplaced ) {
								pbreplacedcount = pbreplaced.length;
								for ( i = 0; i < pbreplacedcount; i++ ) {
									o.content = o.content.replace( /<img[^>]+>/, replacer );
								}
							}
							o.content = o.content.replace(
								/<img[^>]+>/g,
								function( im ) {
									if ( -1 !== im.indexOf( 'class="mceSubscribe2' ) ) {
										im = shortcode;
									}
									return im;
								}
							);
						}
					}
				);
			},

			getInfo: function() {
				return {
					longname: 'Insert Subscribe2 Token',
					author: 'Matthew Robinson',
					authorurl: 'http://subscribe2.wordpress.com',
					infourl: 'http://subscribe2.wordpress.com',
					version: tinymce.majorVersion + '.' + tinymce.minorVersion
				};
			}
		}
	);

	// Register plugin
	tinymce.PluginManager.add( 'subscribe2', tinymce.plugins.Subscribe2Plugin );
} () );
