<?php



add_theme_support( 'menus' );

add_theme_support( 'widgets' );

add_theme_support( 'post-thumbnails');



if( function_exists('acf_add_options_page') ) {

    acf_add_options_page();

    acf_set_options_page_menu("Theme Option");

}



add_action('admin_bar_menu', 'add_toolbar_items', 100);

function add_toolbar_items($admin_bar){

    $admin_bar->add_menu( array(

        'id'    => 'my-item',

        'title' => 'Theme Option',

        'href'  => site_url().'/wp-admin/admin.php?page=acf-options',

        'meta'  => array(

            'title' => __('Theme Option'),

        ),

    ));

}

function add_theme_scripts() {

    //    Style

    wp_enqueue_style( 'style-bootstrap', get_template_directory_uri() . '/css/bootstrap.min.css');

    wp_enqueue_style( 'style-font-awesome', get_template_directory_uri() . '/css/font-awesome.css');

    wp_enqueue_style( 'style-animate', get_template_directory_uri() . '/css/animate.css');
    wp_enqueue_style( 'style-main', get_template_directory_uri() . '/css/style.css');

    wp_enqueue_style( 'style-bootstrapcdn', 'https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css' );

    wp_enqueue_style( 'Poppins', 'https://fonts.googleapis.com/css?family=Heebo:100,300,400,500,700,800,900|Poppins:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i' );

    wp_enqueue_style( 'Oswald', 'https://fonts.googleapis.com/css?family=Oswald:200,300,400,500,600,700' );

    wp_enqueue_style( 'style', get_stylesheet_uri() );



    // Script

    wp_enqueue_script( 'script-jquery', get_template_directory_uri() . '/js/jquery.min.js', array(), null, true);

    wp_enqueue_script( 'script-bootstrap', get_template_directory_uri() . '/js/bootstrap.min.js', array(), null, true);
    wp_enqueue_script( 'script-wow', get_template_directory_uri() . '/js/wow.min.js', array(), null, true);

    wp_enqueue_script( 'script-revolution-extension', get_template_directory_uri() . '/js/custom_script.js', array(), null, true);

}

add_action( 'wp_enqueue_scripts', 'add_theme_scripts' );



function register_my_menus() {

    register_nav_menus(

        array(

            'header_menu' => __( 'Header Menu' ),

            'footer_menu' => __( 'Footer Menu' ),

        )

    );

}

add_action( 'init', 'register_my_menus' );



function rrregister_sidebars() {



    /* Register the primary sidebar. */

    register_sidebar(

        array(

            'id' => 'sidebar-1',

            'name' => __( 'Footer Column One', 'theme' ),

            'description' => __( 'A short description of the sidebar.', 'theme' ),

            'before_widget' => '<div id="%1$s" class="widget %2$s footer_item">',

            'after_widget' => '</div>',

            'before_title' => '<h3>',

            'after_title' => '</h3>'

        )

    );

    register_sidebar(

        array(

            'id' => 'sidebar-2',

            'name' => __( 'Footer Column Two', 'theme' ),

            'description' => __( 'A short description of the sidebar.', 'theme' ),

            'before_widget' => '<div id="%1$s" class="widget %2$s footer_item">',

            'after_widget' => '</div>',

            'before_title' => '<h3>',

            'after_title' => '</h3>'

        )

    );

    register_sidebar(

        array(

            'id' => 'sidebar-3',

            'name' => __( 'Footer Column Three', 'theme' ),

            'description' => __( 'A short description of the sidebar.', 'theme' ),

            'before_widget' => '<div id="%1$s" class="widget %2$s footer_item">',

            'after_widget' => '</div>',

            'before_title' => '<h3>',

            'after_title' => '</h3>'

        )

    );

    register_sidebar(

        array(

            'id' => 'sidebar-4',

            'name' => __( 'Footer Column Four', 'theme' ),

            'description' => __( 'A short description of the sidebar.', 'theme' ),

            'before_widget' => '<div id="%1$s" class="widget %2$s footer_item">',

            'after_widget' => '</div>',

            'before_title' => '<h3>',

            'after_title' => '</h3>'

        )

    );

}

add_action( 'widgets_init', 'rrregister_sidebars' );



add_filter('nav_menu_css_class','arg_menu_classes',110,3);



function arg_menu_classes($classes, $item, $args) {

    if($args->theme_location == 'header_menu') {

        $classes[] = 'nav-item';

    }

    return $classes;

}

function servicestype() {



    $labels = array(

        'name'                => _x( 'Services', 'Post Type General Name', 'theme' ),

        'singular_name'       => _x( 'Services', 'Post Type Singular Name', 'theme' ),

        'menu_name'           => __( 'Services', 'theme' ),

        'parent_item_colon'   => __( 'Parent Services', 'theme' ),

        'all_items'           => __( 'All Services', 'theme' ),

        'view_item'           => __( 'View Services', 'theme' ),

        'add_new_item'        => __( 'Add New Services', 'theme' ),

        'add_new'             => __( 'Add New', 'theme' ),

        'edit_item'           => __( 'Edit Services', 'theme' ),

        'update_item'         => __( 'Update Services', 'theme' ),

        'search_items'        => __( 'Search Services', 'theme' ),

        'not_found'           => __( 'Not Found', 'theme' ),

        'not_found_in_trash'  => __( 'Not found in Trash', 'theme' ),

    );



    $args = array(

        'label'               => __( 'Servicess', 'theme' ),

        'description'         => __( 'Services news and reviews', 'theme' ),

        'labels'              => $labels,

        'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),

        'taxonomies'          => array( 'genres' ),

        'hierarchical'        => false,

        'public'              => true,

        'show_ui'             => true,

        'show_in_menu'        => true,

        'show_in_nav_menus'   => true,

        'show_in_admin_bar'   => true,

        'menu_position'       => 5,

        'can_export'          => true,

        'has_archive'         => true,

        'exclude_from_search' => false,

        'publicly_queryable'  => true,

        'capability_type'     => 'page',

    );



    register_post_type( 'Services', $args );



}

add_action( 'init', 'servicestype', 0 );

function custom_excerpt_length( $length ) {

    return 20;

}

add_filter( 'excerpt_length', 'custom_excerpt_length', 999 );

function custom_excerpt_more( $more ) {

    return '...';

    //you can change this to whatever you want

}

add_filter( 'excerpt_more', 'custom_excerpt_more' );
add_filter( 'upload_mimes', 'wpse_mime_types_webp' );
function wpse_mime_types_webp( $mimes ) {
    $mimes['webp'] = 'image/webp';

    return $mimes;
}
