<!doctype html>

<html lang="en">

<head>

    <meta charset="UTF-8">

    <meta name="viewport"

          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">

    <meta http-equiv="X-UA-Compatible" content="ie=edge">

    <title><?php if (is_404()): echo "Page Not Found"; else: echo get_the_title(); endif; echo " - ".get_bloginfo(); ?></title>

    <!-- inject:css-->
	
    <!-- endinject -->

    <?php

    $favicon=get_field('favicon','option');

    if (!empty($favicon)):

        echo "<link rel=\"icon\" type=\"image/x-icon\" href=\"$favicon\">";

    endif; ?>

    <?php wp_head(); ?>

</head>

<body <?php body_class(); ?>>

    <header class="container-fluid">

        <div class="row">

            <nav class="navbar navbar-default navbar-fixed-top">

                <div class="container bigger p0">

                    <div class="container-fluid">

                        <div class="navbar-header">

                            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#myNavbar">

                                <span class="icon-bar"></span>

                                <span class="icon-bar"></span>

                                <span class="icon-bar"></span>

                            </button>

                            <?php

                            $logo = get_field('logo','option');

                            if( !empty($logo) ): ?>

                                <a class="navbar-brand" href="<?= site_url(); ?>">

                                    <img src="<?php echo $logo['url']; ?>" alt="<?php echo $logo['alt']; ?>" class="logo"//>

                                </a>

                            <?php endif; ?>

                        </div>

                        <div class="collapse navbar-collapse" id="myNavbar">

                            <?php

                            $phoneNumber=get_field('phone_number','option');

                            $phoneIcon=get_field('phone_icon','option');

                            if (!empty($phoneNumber) && !empty($phoneIcon)): ?>

                                <ul class="nav navbar-nav nav_2">

                                    <li>

                                        <a href="tel:<?= $phoneNumber; ?>"><img src="<?= get_template_directory_uri(); ?>/images/call_whatsapp.png"/><?= $phoneNumber; ?></a>

                                    </li>

                                </ul>

                            <?php endif; ?>



                            <?php

                            wp_nav_menu(

                                array(

                                    'menu' => false,

                                    'theme_location' => 'header_menu',

                                    'link_before' => false,

                                    'link_after' => false,

                                    'menu_class' => "nav navbar-nav navbar-right",

                                    'menu_id' => false,

                                    'container' => false,

                                )

                            );

                            ?>

                        </div>

                    </div>

                </div>

            </nav>

        </div>

    </header>