<?php
/*
* Template Name: Tour Details
*
* */

get_header();
?>
<?php $bnner_bg = get_field('bnner_bg'); ?>
<section class="container-fluid banner_img" style="background: url(<?= $bnner_bg['url']; ?>) center center / cover no-repeat;">
    <div class="row">
        <div class="container">
            <div class="row">
                <div class="banner_text col-md-10 col-md-offset-1">
                    <?php
                    if (get_field('bnner_subtitle')): ?>
                        <p><?php the_field('bnner_subtitle'); ?></p>
                    <?php endif;
                    if (get_field('bnner_title')): ?>
                        <h2 class="wow fadeIn" data-wow-delay="0.2s"><?php the_field('bnner_title'); ?></h2><br/>
                    <?php endif; ?>
                    <?php the_field('bnner_text'); ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php 
if( have_rows('tour_slider') ): ?>
    <section class="container-fluid">
        <div class="row m_t_90 m_b_50">
            <div class="container">
                <div class="row">
                    <div class="col-md-6">
                        <div id="myCarousel" class="carousel tours_details slide" data-ride="carousel">
                            <!-- Indicators -->
                            <ol class="carousel-indicators">
                                <?php $indicatorCounter = 0; ?>
                                <?php while ( have_rows('tour_slider') ) : the_row(); ?>
                                    <li data-target="#myCarousel" data-slide-to="<?= $indicatorCounter; ?>" class="<?php if ( $indicatorCounter == 0 ) : echo "active"; endif; ?>">
                                        <?php $indicatorImage = get_sub_field('ts_sldr_img'); ?>
                                        <img src="<?= $indicatorImage['url']; ?>" >
                                    </li>
                                    <?php $indicatorCounter++; endwhile; ?>
                            </ol>
                            <!-- Wrapper for slides -->
                            <div class="carousel-inner">
                                <?php
                                $sliderCounter = 0;
                                while ( have_rows('tour_slider') ) : the_row(); $sliderCounter++; ?>
                                    <div class="item <?php if ($sliderCounter == 1) : ?>active<?php endif; ?>">
                                        <?php $ts_sldr_img = get_sub_field('ts_sldr_img'); ?>
                                        <img src="<?= $ts_sldr_img['url']; ?>" alt="<?= $ts_sldr_img['alt']; ?>">
                                        <?php
                                        $ts_title=get_field('ts_title');
                                        $ts_text=get_field('ts_text');
                                        if (!empty($ts_title)&&!empty($ts_text)): ?>
                                            <div class="carousel-caption">
                                                <h3><?= $ts_title; ?></h3>
                                                <p><?= $ts_text; ?></p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php endwhile;
                                wp_reset_postdata();
                                ?>
                            </div>
                            <!-- Left and right controls -->
                            <a class="left carousel-control" href="#myCarousel" data-slide="prev">
                                <i class="fa fa-angle-left"></i>
                            </a>
                            <a class="right carousel-control" href="#myCarousel" data-slide="next">
                                <i class="fa fa-angle-right"></i>
                            </a>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <?php
                        while (have_posts()) : the_post();
                            the_content();
                        endwhile;
                        ?>
                    </div>

                </div>
            </div>
        </div>
    </section>
    <div class="container"><hr/></div>
<?php endif;
wp_reset_postdata();
?>
<section class="container-fluid">
	<div class="row m_b_90">
		<div class="container">
			<div class="row content_text">
                <div class="col-md-12">
                    <?php
                    if (get_field('tour_subtitle')) : ?>
                        <h3><?php the_field('tour_subtitle'); ?></h3>
                    <?php endif; ?>
                    <p><em><?php the_field('tour_text'); ?></em></p>
                    <?php
                    if( have_rows('tour_repeater') ):
                        while ( have_rows('tour_repeater') ) : the_row(); ?>
                            <p><strong><?php the_sub_field('tsr_title'); ?></strong> <?php the_sub_field('tsr_text'); ?></p>
                        <?php endwhile;
                    endif;
                    wp_reset_postdata();
                    ?>
                </div>
            </div>
			<div class="row">
                <div class="col-md-12">
                    <?php
                    $ts_btn_name=get_field('ts_btn_name');
                    $ts_btn_url=get_field('ts_btn_url');
                    if (!empty($ts_btn_name)&&!empty($ts_btn_url)): ?>
                        <a href="<?= $ts_btn_url; ?>" class="btn btn-primary" data-wow-delay="0.2s"><?= $ts_btn_name; ?></a>
                    <?php endif;
                    ?>
                </div>
            </div>
		</div>
	</div>
</section>
<?php get_footer();
